/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.GroovyObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriSupport;
import org.springframework.util.Assert;

public class DefaultGroovyPagesUriService
extends GroovyPagesUriSupport {
    ConcurrentMap<TupleStringKey, String> templateURICache = new ConcurrentHashMap<TupleStringKey, String>();
    ConcurrentMap<TupleStringKey, String> deployedViewURICache = new ConcurrentHashMap<TupleStringKey, String>();
    ConcurrentMap<ControllerObjectKey, String> controllerNameCache = new ConcurrentHashMap<ControllerObjectKey, String>();
    ConcurrentMap<TupleStringKey, String> noSuffixViewURICache = new ConcurrentHashMap<TupleStringKey, String>();

    @Override
    public String getTemplateURI(String controllerName, String templateName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, templateName);
        String uri = (String)this.templateURICache.get(key);
        if (uri == null && (prevuri = this.templateURICache.putIfAbsent(key, uri = super.getTemplateURI(controllerName, templateName))) != null) {
            return prevuri;
        }
        return uri;
    }

    @Override
    public String getDeployedViewURI(String controllerName, String viewName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, viewName);
        String uri = (String)this.deployedViewURICache.get(key);
        if (uri == null && (prevuri = this.deployedViewURICache.putIfAbsent(key, uri = super.getDeployedViewURI(controllerName, viewName))) != null) {
            return prevuri;
        }
        return uri;
    }

    @Override
    public String getLogicalControllerName(GroovyObject controller) {
        String prevname;
        ControllerObjectKey key = new ControllerObjectKey(controller);
        String name = (String)this.controllerNameCache.get(key);
        if (name == null && (prevname = this.controllerNameCache.putIfAbsent(key, name = super.getLogicalControllerName(controller))) != null) {
            return prevname;
        }
        return name;
    }

    @Override
    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getNoSuffixViewURI(this.getLogicalControllerName(controller), viewName);
    }

    @Override
    public String getNoSuffixViewURI(String controllerName, String viewName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, viewName);
        String uri = (String)this.noSuffixViewURICache.get(key);
        if (uri == null && (prevuri = this.noSuffixViewURICache.putIfAbsent(key, uri = super.getNoSuffixViewURI(controllerName, viewName))) != null) {
            return prevuri;
        }
        return uri;
    }

    @Override
    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName);
    }

    @Override
    public void clear() {
        this.templateURICache.clear();
        this.deployedViewURICache.clear();
        this.controllerNameCache.clear();
        this.noSuffixViewURICache.clear();
    }

    private static class ControllerObjectKey {
        private long controllerHashCode;
        private String controllerClassName;

        public ControllerObjectKey(GroovyObject controller) {
            this.controllerHashCode = System.identityHashCode(controller.getClass());
            this.controllerClassName = controller.getClass().getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControllerObjectKey that = (ControllerObjectKey)o;
            if (this.controllerHashCode != that.controllerHashCode) {
                return false;
            }
            return this.controllerClassName.equals(that.controllerClassName);
        }

        public int hashCode() {
            int result = (int)(this.controllerHashCode ^ this.controllerHashCode >>> 32);
            result = 31 * result + this.controllerClassName.hashCode();
            return result;
        }
    }

    private static class TupleStringKey {
        String keyPart1;
        String keyPart2;

        public TupleStringKey(String keyPart1, String keyPart2) {
            this.keyPart1 = keyPart1;
            this.keyPart2 = keyPart2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TupleStringKey that = (TupleStringKey)o;
            if (this.keyPart1 != null ? !this.keyPart1.equals(that.keyPart1) : that.keyPart1 != null) {
                return false;
            }
            return !(this.keyPart2 != null ? !this.keyPart2.equals(that.keyPart2) : that.keyPart2 != null);
        }

        public int hashCode() {
            int result = this.keyPart1 != null ? this.keyPart1.hashCode() : 0;
            result = 31 * result + (this.keyPart2 != null ? this.keyPart2.hashCode() : 0);
            return result;
        }
    }
}

