/*
 * Decompiled with CFR 0.152.
 */
package grails.test.mixin.support;

import grails.core.GrailsTagLibClass;
import groovy.lang.GroovyObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.core.gsp.DefaultGrailsTagLibClass;
import org.grails.plugins.web.GroovyPagesGrailsPlugin;
import org.grails.taglib.TagLibraryLookup;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

public class LazyTagLibraryLookup
extends TagLibraryLookup {
    List<Class> tagLibClasses = (List)new GroovyPagesGrailsPlugin().getProvidedArtefacts();
    private Map<String, GrailsTagLibClass> lazyLoadableTagLibs = new HashMap<String, GrailsTagLibClass>();

    protected void registerTagLibraries() {
        super.registerTagLibraries();
        for (Class providedArtefact : this.tagLibClasses) {
            this.registerLazyLoadableTagLibClass(providedArtefact);
        }
    }

    public void registerLazyLoadableTagLibClass(Class tagLibClass) {
        DefaultGrailsTagLibClass grailsTagLibClass = new DefaultGrailsTagLibClass(tagLibClass);
        if (!this.hasNamespace(grailsTagLibClass.getNamespace())) {
            this.registerNamespaceDispatcher(grailsTagLibClass.getNamespace());
        }
        for (String tagName : grailsTagLibClass.getTagNames()) {
            String tagKey = this.tagNameKey(grailsTagLibClass.getNamespace(), tagName);
            this.lazyLoadableTagLibs.put(tagKey, (GrailsTagLibClass)grailsTagLibClass);
        }
    }

    public GroovyObject lookupTagLibrary(String namespace, String tagName) {
        String tagKey;
        GrailsTagLibClass taglibClass;
        GroovyObject tagLibrary = super.lookupTagLibrary(namespace, tagName);
        if (tagLibrary == null && (taglibClass = this.lazyLoadableTagLibs.get(tagKey = this.tagNameKey(namespace, tagName))) != null) {
            if (!this.applicationContext.containsBean(taglibClass.getFullName())) {
                GenericBeanDefinition bd = new GenericBeanDefinition();
                bd.setBeanClass(taglibClass.getClazz());
                bd.setAutowireCandidate(true);
                bd.setAutowireMode(1);
                ((GenericApplicationContext)this.applicationContext).getDefaultListableBeanFactory().registerBeanDefinition(taglibClass.getFullName(), (BeanDefinition)bd);
            }
            this.registerTagLib(taglibClass);
            tagLibrary = super.lookupTagLibrary(namespace, tagName);
        }
        return tagLibrary;
    }

    protected String tagNameKey(String namespace, String tagName) {
        return namespace + ':' + tagName;
    }

    protected void putTagLib(Map<String, Object> tags, String name, GrailsTagLibClass taglib) {
        if (this.applicationContext.containsBean(taglib.getFullName())) {
            super.putTagLib(tags, name, taglib);
        }
    }
}

