/*
 * Decompiled with CFR 0.152.
 */
package grails.test.mixin.support;

import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import grails.util.BuildSettings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GroovyPageUnitTestResourceLoader
extends DefaultResourceLoader
implements GrailsApplicationAware,
InitializingBean {
    public static final String WEB_INF_PREFIX = "/WEB-INF/grails-app/views";
    private Map<String, String> groovyPages = new ConcurrentHashMap<String, String>();
    private String basePath;
    private GrailsApplication grailsApplication;

    public GroovyPageUnitTestResourceLoader(Map<String, String> groovyPages) {
        this.groovyPages = groovyPages;
    }

    public Resource getResource(String location) {
        if (location.startsWith(WEB_INF_PREFIX)) {
            location = location.substring(WEB_INF_PREFIX.length());
        }
        if (this.groovyPages.containsKey(location)) {
            try {
                return new ByteArrayResource(this.groovyPages.get(location).getBytes("UTF-8"), location);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (this.basePath == null) {
            String basedir = BuildSettings.BASE_DIR.getAbsolutePath();
            this.basePath = basedir + File.separatorChar + "grails-app/views/";
        }
        String path = this.basePath + location;
        path = this.makeCanonical(path);
        return new FileSystemResource(path);
    }

    private String makeCanonical(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void afterPropertiesSet() throws Exception {
        Map config;
        Object viewDir;
        if (this.grailsApplication != null && (viewDir = (config = this.grailsApplication.getFlatConfig()).get("grails.gsp.view.dir")) != null) {
            this.basePath = viewDir.toString();
        }
    }
}

