/*
 * Decompiled with CFR 0.152.
 */
package grails.test.mixin.support;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GroovyPageUnitTestResourceLoader
extends DefaultResourceLoader {
    public static final String WEB_INF_PREFIX = "/WEB-INF/grails-app/views";
    private Map<String, String> groovyPages = new ConcurrentHashMap<String, String>();

    public GroovyPageUnitTestResourceLoader(Map<String, String> groovyPages) {
        this.groovyPages = groovyPages;
    }

    public Resource getResource(String location) {
        String basedir;
        if (location.startsWith(WEB_INF_PREFIX)) {
            location = location.substring(WEB_INF_PREFIX.length());
        }
        if (this.groovyPages.containsKey(location)) {
            try {
                return new ByteArrayResource(this.groovyPages.get(location).getBytes("UTF-8"), location);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        BuildSettings buildSettings = BuildSettingsHolder.getSettings();
        String systemBaseDirectory = System.getProperty("base.dir");
        String string = basedir = systemBaseDirectory != null ? systemBaseDirectory : ".";
        if (buildSettings != null) {
            try {
                basedir = buildSettings.getBaseDir().getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String path = basedir + File.separatorChar + "grails-app/views/" + location;
        path = this.makeCanonical(path);
        return new FileSystemResource(path);
    }

    private String makeCanonical(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }
}

