/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve.reporting;

import grails.build.logging.GrailsConsole;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import org.codehaus.groovy.grails.resolve.reporting.DependencyGraphRenderer;
import org.codehaus.groovy.grails.resolve.reporting.GraphNode;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.fusesource.jansi.Ansi;

public class SimpleGraphRenderer
implements DependencyGraphRenderer,
GroovyObject {
    private static final GrailsConsole CONSOLE;
    private static final String TOP_LEVEL_PREFIX = "+--- ";
    private static final String UNRESOLVED_PREFIX = ">>>> ";
    private static final String INITIAL_TRANSITIVE_PREFIX = "|    ";
    private static final String PADDING = "     ";
    private static final String TRANSITIVE_PREFIX = "\\--- ";
    private boolean ansiEnabled;
    private String scope;
    private String description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public SimpleGraphRenderer(String string, String string2) {
        void description;
        void scope;
        MetaClass metaClass;
        boolean bl;
        this.ansiEnabled = bl = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = scope;
        this.scope = var5_5;
        void var6_6 = description;
        this.description = var6_6;
    }

    public void render(GraphNode root, Writer writer) {
        PrintWriter pw = new PrintWriter(writer);
        pw.println();
        if (this.ansiEnabled && CONSOLE.isAnsiEnabled()) {
            DefaultGroovyMethods.println((PrintWriter)pw, (Object)new Ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.GREEN).a(this.scope).fg(Ansi.Color.YELLOW).a(new GStringImpl(new Object[]{this.description}, new String[]{" - ", ""}).toString()).fg(Ansi.Color.DEFAULT).a(Ansi.Attribute.INTENSITY_BOLD_OFF));
        } else {
            DefaultGroovyMethods.println((PrintWriter)pw, (Object)new GStringImpl(new Object[]{this.scope, this.description}, new String[]{"", " - ", ""}));
        }
        GraphNode child = null;
        Iterator<GraphNode> iterator = root.getChildren().iterator();
        while (iterator.hasNext()) {
            child = (GraphNode)ScriptBytecodeAdapter.castToType((Object)iterator.next(), GraphNode.class);
            this.renderGraph(child, pw, 0);
        }
        if (this.ansiEnabled) {
            DefaultGroovyMethods.print((PrintWriter)pw, (Object)new Ansi().a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT));
        }
        pw.println();
        pw.flush();
    }

    private Object renderGraph(GraphNode current, PrintWriter writer, int depth) {
        if (depth == 0) {
            String prefix = TOP_LEVEL_PREFIX;
            this.writeDependency(writer, prefix, current);
        } else {
            if (this.ansiEnabled && CONSOLE.isAnsiEnabled()) {
                DefaultGroovyMethods.print((PrintWriter)writer, (Object)new Ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.YELLOW).a(INITIAL_TRANSITIVE_PREFIX).fg(Ansi.Color.DEFAULT).a(Ansi.Attribute.INTENSITY_BOLD_OFF));
            } else {
                writer.print(INITIAL_TRANSITIVE_PREFIX);
            }
            if (depth > 1) {
                Integer num = null;
                Iterator iterator = new IntRange(true, 1, depth - 1).iterator();
                while (iterator.hasNext()) {
                    num = (Integer)ScriptBytecodeAdapter.castToType(iterator.next(), Integer.class);
                    writer.print(PADDING);
                }
            }
            this.writeDependency(writer, TRANSITIVE_PREFIX, current);
        }
        GraphNode child = null;
        Iterator<GraphNode> iterator = current.getChildren().iterator();
        while (iterator.hasNext()) {
            child = (GraphNode)ScriptBytecodeAdapter.castToType((Object)iterator.next(), GraphNode.class);
            this.renderGraph(child, writer, depth + 1);
        }
        return null;
    }

    private void writeDependency(PrintWriter writer, String prefix, GraphNode node) {
        if (this.ansiEnabled && CONSOLE.isAnsiEnabled()) {
            Boolean resolved = node.getResolved();
            Boolean bl = resolved;
            Boolean bl2 = resolved;
            Boolean bl3 = resolved;
            DefaultGroovyMethods.println((PrintWriter)writer, (Object)new Ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg((bl == null ? false : bl) ? Ansi.Color.YELLOW : Ansi.Color.RED).a((bl2 == null ? false : bl2) ? prefix : UNRESOLVED_PREFIX).fg((bl3 == null ? false : bl3) ? Ansi.Color.DEFAULT : Ansi.Color.RED).a(node.getDependency().toString()).fg(Ansi.Color.DEFAULT).a(Ansi.Attribute.INTENSITY_BOLD_OFF));
        } else {
            DefaultGroovyMethods.println((PrintWriter)writer, (Object)new GStringImpl(new Object[]{prefix, node.getDependency()}, new String[]{"", "", ""}));
        }
    }

    @Override
    public void render(GraphNode root) {
        this.render(root, new OutputStreamWriter(System.out));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SimpleGraphRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        GrailsConsole grailsConsole;
        CONSOLE = grailsConsole = GrailsConsole.getInstance();
    }

    public boolean getAnsiEnabled() {
        return this.ansiEnabled;
    }

    public boolean isAnsiEnabled() {
        return this.ansiEnabled;
    }

    public void setAnsiEnabled(boolean bl) {
        this.ansiEnabled = bl;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

