/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli;

import gant.Gant;
import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.CosineSimilarity;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import grails.util.PluginBuildSettings;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.util.AntBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.InputHandler;
import org.codehaus.gant.GantBinding;
import org.codehaus.gant.GantMetaClass;
import org.codehaus.groovy.grails.cli.CommandLineInputHandler;
import org.codehaus.groovy.grails.cli.ScriptNameResolver;
import org.codehaus.groovy.grails.cli.ScriptNotFoundException;
import org.codehaus.groovy.grails.cli.interactive.InteractiveMode;
import org.codehaus.groovy.grails.cli.parsing.CommandLine;
import org.codehaus.groovy.grails.cli.parsing.CommandLineParser;
import org.codehaus.groovy.grails.cli.parsing.DefaultCommandLine;
import org.codehaus.groovy.grails.cli.parsing.ParseException;
import org.codehaus.groovy.grails.cli.support.ClasspathConfigurer;
import org.codehaus.groovy.grails.cli.support.PluginPathDiscoverySupport;
import org.codehaus.groovy.grails.cli.support.ScriptBindingInitializer;
import org.codehaus.groovy.grails.io.support.PathMatchingResourcePatternResolver;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class GrailsScriptRunner {
    private static final Pattern scriptFilePattern = Pattern.compile("^[^_]\\w+\\.groovy$");
    private static InputStream originalIn;
    private static PrintStream originalOut;
    public static final Closure DO_NOTHING_CLOSURE;
    private PluginPathDiscoverySupport pluginPathSupport;
    private BuildSettings settings;
    private PrintStream out = System.out;
    private GrailsConsole console = GrailsConsole.getInstance();
    private boolean isInteractive = System.getProperty("grails.console.enable.interactive") != null ? Boolean.getBoolean("grails.console.enable.interactive") : true;
    private URLClassLoader classLoader;
    private File scriptCacheDir;
    private final List<File> scriptsAllowedOutsideOfProject = new ArrayList<File>();

    public GrailsScriptRunner() {
        this(new BuildSettings());
    }

    public GrailsScriptRunner(String grailsHome) {
        this(new BuildSettings(new File(grailsHome)));
    }

    public GrailsScriptRunner(BuildSettings settings) {
        if (originalIn == null) {
            originalIn = System.in;
            originalOut = System.out;
        }
        this.settings = settings;
        this.pluginPathSupport = new PluginPathDiscoverySupport(settings);
    }

    public void setInteractive(boolean interactive) {
        this.isInteractive = interactive;
    }

    public static void main(String[] args) {
        boolean resolveDeps;
        CommandLine commandLine;
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        ExpandoMetaClass.enableGlobally();
        originalIn = System.in;
        originalOut = System.out;
        CommandLineParser parser = GrailsScriptRunner.getCommandLineParser();
        GrailsConsole console = GrailsConsole.getInstance();
        try {
            if (args.length == 0) {
                commandLine = new DefaultCommandLine();
            } else {
                commandLine = parser.parseString(args[0]);
                if (commandLine.hasOption("plain-output")) {
                    console.setAnsiEnabled(false);
                }
            }
        }
        catch (ParseException e) {
            console.error("Error processing command line arguments: " + e.getMessage());
            console.cleanlyExit(1);
            return;
        }
        ScriptAndArgs script = GrailsScriptRunner.processArgumentsAndReturnScriptName(commandLine);
        String grailsHome = System.getProperty("grails.home");
        BuildSettings build = null;
        try {
            build = new BuildSettings(new File(grailsHome));
            build.setModified(commandLine.hasOption("refresh-dependencies"));
            build.setOffline(commandLine.hasOption("offline"));
            if (commandLine.hasOption("debug-fork")) {
                System.setProperty("grails.debug.fork", "true");
            }
            if (build.getRootLoader() == null) {
                build.setRootLoader((URLClassLoader)GrailsScriptRunner.class.getClassLoader());
            }
        }
        catch (Exception e) {
            GrailsScriptRunner.exitWithError("An error occurred loading the grails-app/conf/BuildConfig.groovy file: " + e.getMessage(), null);
        }
        File grailsHomeInSettings = build.getGrailsHome();
        if (grailsHomeInSettings == null || !grailsHomeInSettings.exists()) {
            GrailsScriptRunner.exitWithError("Grails' installation directory not found: " + build.getGrailsHome(), null);
        }
        if (commandLine.hasOption("version")) {
            console.log("Grails version: " + build.getGrailsVersion());
            console.cleanlyExit(0);
        }
        if (commandLine.hasOption("help")) {
            if (commandLine.getCommandName() != null) {
                console.log("The '-help' option is deprecated; use 'grails help [target]'");
            } else {
                console.log("The '-help' option is deprecated; use 'grails help'");
            }
            console.cleanlyExit(0);
        }
        if (resolveDeps = commandLine.hasOption("refresh-dependencies")) {
            if (commandLine.hasOption("include-source")) {
                build.setIncludeSource(true);
            }
            if (commandLine.hasOption("include-javadoc")) {
                build.setIncludeJavadoc(true);
            }
        }
        GrailsScriptRunner scriptRunner = new GrailsScriptRunner(build);
        scriptRunner.setInteractive(!commandLine.hasOption("non-interactive"));
        if ("Interactive".equals(script.name)) {
            console.error("The 'interactive' script is deprecated; to run in interactive mode just omit the script name");
            script.name = null;
        }
        if (script.name == null) {
            String version = System.getProperty("grails.version");
            console.updateStatus("Loading Grails " + (version == null ? build.getGrailsVersion() : version));
            GrailsScriptRunner.loadConfigEnvironment(commandLine, build);
            if (resolveDeps) {
                ClasspathConfigurer.cleanResolveCache(build);
            }
            scriptRunner.initializeState();
            try {
                new InteractiveMode(build, scriptRunner).run();
            }
            catch (Throwable e) {
                console.error("Interactive mode exited with error: " + e.getMessage(), e);
            }
        } else {
            console.getCategory().push(script.inputName);
            console.verbose("Base Directory: " + build.getBaseDir().getPath());
            try {
                int exitCode = scriptRunner.executeCommand(commandLine, script.name, script.env);
                GrailsConsole.getInstance().cleanlyExit(exitCode);
            }
            catch (ScriptNotFoundException ex) {
                String msg = "Script not found: " + ex.getScriptName();
                GrailsScriptRunner.exitWithError(msg, null);
            }
            catch (Throwable t) {
                String msg = "Error executing script " + script.name + ": " + t.getMessage();
                GrailsScriptRunner.exitWithError(msg, t);
            }
        }
    }

    private static void loadConfigEnvironment(CommandLine commandLine, BuildSettings build) {
        String env = commandLine.isEnvironmentSet() ? commandLine.getEnvironment() : commandLine.lookupEnvironmentForCommand();
        build.setGrailsEnv(env);
        build.loadConfig(env);
    }

    public static CommandLineParser getCommandLineParser() {
        CommandLineParser parser = new CommandLineParser();
        parser.addOption("refresh-dependencies", "Whether to force a resolve of dependencies (skipping any caching)");
        parser.addOption("verbose", "Enable verbose output");
        parser.addOption("offline", "Indicates that Grails should not connect to any remote servers during processing of the build");
        parser.addOption("stacktrace", "Enable stack traces in output");
        parser.addOption("reloading", "Enable the reloading agent");
        parser.addOption("non-interactive", "Whether to allow the command line to request input");
        parser.addOption("version", "Current Grails version");
        parser.addOption("plain-output", "Disables ANSI output");
        parser.addOption("debug-fork", "Whether to debug the forked JVM if using forked mode");
        return parser;
    }

    private static void exitWithError(String error, Throwable t) {
        GrailsConsole grailsConsole = GrailsConsole.getInstance();
        if (t == null) {
            grailsConsole.error(error);
        } else {
            grailsConsole.error(error, t);
        }
        grailsConsole.cleanlyExit(1);
    }

    private static ScriptAndArgs processArgumentsAndReturnScriptName(CommandLine commandLine) {
        if (commandLine.hasOption("verbose")) {
            GrailsConsole.getInstance().setVerbose(true);
        }
        if (commandLine.hasOption("stacktrace")) {
            GrailsConsole.getInstance().setStacktrace(true);
        }
        GrailsScriptRunner.processSystemArguments(commandLine);
        return GrailsScriptRunner.processAndReturnArguments(commandLine);
    }

    private static ScriptAndArgs processAndReturnArguments(CommandLine commandLine) {
        ScriptAndArgs info = new ScriptAndArgs();
        if (Environment.isSystemSet()) {
            info.env = Environment.getCurrent().getName();
        } else if (commandLine.getEnvironment() != null) {
            info.env = commandLine.getEnvironment();
        }
        info.inputName = commandLine.getCommandName();
        info.name = GrailsNameUtils.getNameFromScript(commandLine.getCommandName());
        return info;
    }

    private static void processSystemArguments(CommandLine allArgs) {
        Properties systemProps = allArgs.getSystemProperties();
        if (systemProps != null) {
            for (Map.Entry<Object, Object> entry : systemProps.entrySet()) {
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream outputStream) {
        this.out = outputStream;
    }

    public int executeCommand(String scriptName, String args) {
        return this.executeCommand(scriptName, args, null);
    }

    public int executeCommand(String scriptName, String args, String env) {
        if (args != null) {
            System.setProperty("grails.cli.args", args.replace(' ', '\n'));
        } else {
            System.setProperty("grails.cli.args", "");
        }
        CommandLineParser parser = GrailsScriptRunner.getCommandLineParser();
        DefaultCommandLine commandLine = (DefaultCommandLine)parser.parseString(scriptName, args);
        this.setInteractive(!commandLine.hasOption("non-interactive"));
        if (env != null) {
            commandLine.setEnvironment(env);
        }
        return this.executeCommand(commandLine, scriptName, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommand(CommandLine commandLine, String scriptName, String env) {
        GrailsConsole console = this.getConsole(commandLine);
        try {
            System.setProperty("disable.grails.plugin.transform", "true");
            console.updateStatus("Loading Grails " + this.settings.getGrailsVersion());
            GrailsScriptRunner.loadConfigEnvironment(commandLine, this.settings);
            this.settings.initializeResourcesDir();
            System.setProperty("springloaded.directoriesContainingReloadableCode", this.settings.getClassesDir().getAbsolutePath() + ',' + this.settings.getPluginClassesDir().getAbsolutePath());
        }
        catch (Exception e) {
            console.error("There was an error loading the BuildConfig: " + e.getMessage(), e);
            console.cleanlyExit(1);
        }
        finally {
            System.setProperty("disable.grails.plugin.transform", "false");
        }
        try {
            BuildSettingsHolder.setSettings(this.settings);
            int n = this.callPluginOrGrailsScript(commandLine, scriptName, env);
            return n;
        }
        finally {
            GrailsConsole.getInstance().flush();
            BuildSettingsHolder.setSettings(null);
        }
    }

    private GrailsConsole getConsole(CommandLine commandLine) {
        GrailsConsole console = GrailsConsole.getInstance();
        console.setAnsiEnabled(!commandLine.hasOption("plain-output"));
        console.setStacktrace(commandLine.hasOption("stacktrace"));
        console.setVerbose(commandLine.hasOption("verbose"));
        return console;
    }

    private void setRunningEnvironment(CommandLine commandLine, String env) {
        System.setProperty("base.dir", this.settings.getBaseDir().getPath());
        if (env != null) {
            this.settings.setGrailsEnv(env);
            this.settings.setDefaultEnv(false);
        } else {
            this.settings.setGrailsEnv(commandLine.getEnvironment());
            this.settings.setDefaultEnv(!commandLine.isEnvironmentSet());
        }
    }

    private int callPluginOrGrailsScript(CommandLine commandLine, String scriptName, String env) {
        this.initializeState(scriptName);
        return this.executeScriptWithCaching(commandLine, scriptName, env);
    }

    public int executeScriptWithCaching(CommandLine commandLine) {
        GrailsScriptRunner.processSystemArguments(commandLine);
        System.setProperty("grails.cli.args", commandLine.getRemainingArgsLineSeparated());
        return this.executeScriptWithCaching(commandLine, GrailsNameUtils.getNameFromScript(commandLine.getCommandName()), commandLine.getEnvironment());
    }

    private int executeScriptWithCaching(CommandLine commandLine, String scriptName, String env) {
        List<File> allScripts = this.getAvailableScripts();
        GantBinding binding = new GantBinding();
        binding.setVariable("scriptName", (Object)scriptName);
        this.setDefaultInputStream(binding);
        List<File> potentialScripts = this.getPotentialScripts(scriptName, allScripts);
        if (potentialScripts.size() == 0) {
            try {
                File aliasFile = new File(this.settings.getUserHome(), ".grails/.aliases");
                if (aliasFile.exists()) {
                    String aliasValue;
                    String[] aliasPieces;
                    String commandName;
                    String correspondingScriptName;
                    Properties aliasProperties = new Properties();
                    aliasProperties.load(new FileReader(aliasFile));
                    if (aliasProperties.containsKey(commandLine.getCommandName()) && (potentialScripts = this.getPotentialScripts(correspondingScriptName = GrailsNameUtils.getNameFromScript(commandName = (aliasPieces = (aliasValue = (String)aliasProperties.get(commandLine.getCommandName())).split(" "))[0]), allScripts)).size() > 0) {
                        String[] additionalArgs = new String[aliasPieces.length - 1];
                        System.arraycopy(aliasPieces, 1, additionalArgs, 0, additionalArgs.length);
                        this.insertArgumentsInFrontOfExistingArguments(commandLine, additionalArgs);
                    }
                }
            }
            catch (Exception e) {
                this.console.error(e);
            }
        }
        if (potentialScripts.size() > 0) {
            potentialScripts = DefaultGroovyMethods.unique(potentialScripts);
            File scriptFile = (File)potentialScripts.get(0);
            if (!this.isGrailsProject() && !this.isExternalScript(scriptFile)) {
                return this.handleScriptExecutedOutsideProjectError();
            }
            return this.executeScriptFile(commandLine, scriptName, env, binding, scriptFile);
        }
        return this.attemptPrecompiledScriptExecute(commandLine, scriptName, env, binding, allScripts);
    }

    private List<File> getPotentialScripts(String scriptName, List<File> allScripts) {
        boolean exactMatchFound = false;
        ArrayList<File> potentialScripts = new ArrayList<File>();
        for (File scriptPath : allScripts) {
            String fileName = scriptPath.getName();
            String scriptFileName = fileName.substring(0, fileName.length() - 7);
            if (scriptFileName.endsWith("_")) {
                this.scriptsAllowedOutsideOfProject.add(scriptPath);
                scriptFileName = scriptFileName.substring(0, scriptFileName.length() - 1);
            }
            if (scriptFileName.equals(scriptName)) {
                potentialScripts.add(scriptPath);
                exactMatchFound = true;
                continue;
            }
            if (exactMatchFound || !ScriptNameResolver.resolvesTo(scriptName, scriptFileName)) continue;
            potentialScripts.add(scriptPath);
        }
        return potentialScripts;
    }

    private void insertArgumentsInFrontOfExistingArguments(CommandLine commandLine, String[] argumentsToInsert) {
        List<String> remainingArgs = commandLine.getRemainingArgs();
        for (int i = argumentsToInsert.length - 1; i >= 0; --i) {
            remainingArgs.add(0, argumentsToInsert[i]);
        }
    }

    private int attemptPrecompiledScriptExecute(CommandLine commandLine, String scriptName, String env, GantBinding binding, List<File> allScripts) {
        Gant gant;
        block6: {
            this.console.updateStatus("Running pre-compiled script");
            this.setRunningEnvironment(commandLine, env);
            ScriptBindingInitializer bindingInitializer = new ScriptBindingInitializer(commandLine, this.classLoader, this.settings, this.pluginPathSupport, this.isInteractive);
            gant = new Gant(bindingInitializer.initBinding(binding, scriptName), (ClassLoader)this.classLoader);
            try {
                this.loadScriptClass(gant, scriptName);
            }
            catch (ScriptNotFoundException e) {
                if (!this.isInteractive || InteractiveMode.isActive()) {
                    throw e;
                }
                if ((scriptName = this.fixScriptName(scriptName, allScripts)) == null) {
                    throw e;
                }
                try {
                    this.loadScriptClass(gant, scriptName);
                }
                catch (ScriptNotFoundException ce) {
                    return this.executeScriptWithCaching(commandLine, scriptName, env);
                }
                if (!Boolean.TRUE.toString().equals(System.getProperty("grails.env.default"))) break block6;
                commandLine.setCommand(GrailsNameUtils.getScriptName(scriptName));
                env = commandLine.lookupEnvironmentForCommand();
                binding.setVariable("grailsEnv", (Object)env);
                this.settings.setGrailsEnv(env);
                System.setProperty(Environment.KEY, env);
                this.settings.setDefaultEnv(false);
                System.setProperty("grails.env.default", Boolean.FALSE.toString());
            }
        }
        return this.executeWithGantInstance((Gant)gant, GrailsScriptRunner.DO_NOTHING_CLOSURE, (GantBinding)binding).exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeScriptFile(CommandLine commandLine, String scriptName, String env, GantBinding binding, File scriptFile) {
        String scriptFileName = this.getScriptNameFromFile(scriptFile);
        this.setRunningEnvironment(commandLine, env);
        binding.setVariable("scriptName", (Object)scriptFileName);
        ScriptBindingInitializer bindingInitializer = new ScriptBindingInitializer(commandLine, this.classLoader, this.settings, this.pluginPathSupport, this.isInteractive);
        Gant gant = new Gant(bindingInitializer.initBinding(binding, scriptName), (ClassLoader)this.classLoader);
        gant.setUseCache(true);
        gant.setCacheDirectory(this.scriptCacheDir);
        GantResult result = null;
        try {
            gant.loadScript(scriptFile.toURI().toURL());
            result = this.executeWithGantInstance(gant, DO_NOTHING_CLOSURE, binding);
            int n = result.exitCode;
            this.cleanup(result, binding);
            return n;
        }
        catch (IOException e) {
            try {
                this.console.error("I/O exception loading script [" + e.getMessage() + "]: " + e.getMessage());
                int n = 1;
                this.cleanup(result, binding);
                return n;
            }
            catch (Throwable throwable) {
                this.cleanup(result, binding);
                throw throwable;
            }
        }
    }

    private void cleanup(GantResult result, GantBinding binding) {
        if (result != null) {
            Class<GantMetaClass> cls = GantMetaClass.class;
            try {
                Field methodsInvoked = cls.getDeclaredField("methodsInvoked");
                methodsInvoked.setAccessible(true);
                Set methodsInvokedSet = (Set)methodsInvoked.get(cls);
                if (methodsInvokedSet != null) {
                    methodsInvokedSet.clear();
                }
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        System.setIn(originalIn);
        System.setOut(originalOut);
        GrailsPluginUtils.clearCaches();
        Map variables = binding.getVariables();
        Object pluginsSettingsObject = variables.get("pluginsSettings");
        if (pluginsSettingsObject instanceof PluginBuildSettings) {
            ((PluginBuildSettings)pluginsSettingsObject).clearCache();
        }
        GroovySystem.getMetaClassRegistry().removeMetaClass(GantBinding.class);
        GroovySystem.getMetaClassRegistry().removeMetaClass(Gant.class);
    }

    public void initializeState() {
        this.initializeState(null);
    }

    private void initializeState(String scriptName) {
        this.scriptCacheDir = new File(this.settings.getProjectWorkDir(), "scriptCache");
        this.console = GrailsConsole.getInstance();
        boolean skipPlugins = scriptName != null && ("UninstallPlugin".equals(scriptName) || "InstallPlugin".equals(scriptName));
        this.console.updateStatus("Configuring classpath");
        ClasspathConfigurer configurer = new ClasspathConfigurer(this.pluginPathSupport, this.settings, skipPlugins);
        if ("DependencyReport".equals(scriptName) || "Upgrade".equals(scriptName) || "SetProxy".equals(scriptName) || "AddProxy".equals(scriptName)) {
            configurer.setExitOnResolveError(false);
        }
        this.classLoader = configurer.configuredClassLoader();
        this.initializeLogging();
    }

    private int handleScriptExecutedOutsideProjectError() {
        this.console.error(this.settings.getBaseDir().getPath() + " does not appear to be part of a Grails application.");
        this.console.error("The following commands are supported outside of a project:");
        Collections.sort(this.scriptsAllowedOutsideOfProject, new Comparator<File>(){

            @Override
            public int compare(File resource, File resource1) {
                return resource.getName().compareTo(resource1.getName());
            }
        });
        for (File file : this.scriptsAllowedOutsideOfProject) {
            this.console.log("\t" + GrailsNameUtils.getScriptName(file.getName()));
        }
        this.console.addStatus("Run 'grails help' for a complete list of available scripts.");
        return -1;
    }

    protected void initializeLogging() {
        if (this.settings.getGrailsHome() == null) {
            return;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass("org.apache.log4j.PropertyConfigurator");
            Method configure = cls.getMethod("configure", URL.class);
            configure.setAccessible(true);
            File f = new File(this.settings.getGrailsHome() + "/grails-scripts/src/main/scripts/log4j.properties");
            if (f.exists()) {
                configure.invoke(cls, f.toURI().toURL());
            } else {
                f = new File(this.settings.getGrailsHome() + "/scripts/log4j.properties");
                configure.invoke(cls, f.toURI().toURL());
            }
        }
        catch (Throwable e) {
            this.console.verbose("Log4j was not found on the classpath and will not be used for command line logging. Cause " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void setDefaultInputStream(GantBinding binding) {
        AntBuilder antBuilder = (AntBuilder)binding.getVariable("ant");
        Project p = antBuilder.getAntProject();
        try {
            System.setIn(originalIn);
            p.setInputHandler((InputHandler)new CommandLineInputHandler());
            p.setDefaultInputStream(originalIn);
        }
        catch (NoSuchMethodError nsme) {
            for (Method m : p.getClass().getMethods()) {
                if (!"setDefaultInputStream".equals(m.getName()) || m.getParameterTypes().length != 1 || !InputStream.class.equals(m.getParameterTypes()[0])) continue;
                try {
                    m.invoke((Object)p, originalIn);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void loadScriptClass(Gant gant, String scriptName) {
        block4: {
            try {
                gant.loadScriptClass(scriptName + "_");
            }
            catch (Exception e) {
                try {
                    gant.loadScriptClass(scriptName);
                }
                catch (Exception ex) {
                    if (!(ex instanceof ClassNotFoundException) || ex.getMessage() == null || !ex.getMessage().contains(scriptName)) break block4;
                    throw new ScriptNotFoundException(scriptName);
                }
            }
        }
    }

    private String fixScriptName(String scriptName, List<File> allScripts) {
        try {
            HashSet<String> names = new HashSet<String>();
            for (File script : allScripts) {
                String fileName = script.getName();
                names.add(fileName.substring(0, fileName.length() - 7));
            }
            List<String> mostSimilar = CosineSimilarity.mostSimilar(scriptName, names);
            if (mostSimilar.isEmpty()) {
                return null;
            }
            List<String> topMatches = mostSimilar.subList(0, Math.min(5, mostSimilar.size()));
            return this.askUserForBestMatch(scriptName, topMatches);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String askUserForBestMatch(String scriptName, List<String> topMatches) {
        GrailsConsole console = GrailsConsole.getInstance();
        console.addStatus("Script '" + scriptName + "' not found, did you mean:");
        int i = 0;
        for (String s : topMatches) {
            console.log("   " + ++i + ") " + s);
        }
        int attempts = 0;
        while (true) {
            String selection;
            if ("Q".equalsIgnoreCase(selection = console.userInput("Please make a selection or enter Q to quit: "))) {
                GrailsConsole.getInstance().cleanlyExit(0);
            }
            try {
                int number = Integer.parseInt(selection);
                if (number > 0 && number <= topMatches.size()) {
                    return topMatches.get(number - 1);
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            if (++attempts <= 4) continue;
            GrailsScriptRunner.exitWithError("Selection not found.", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GantResult executeWithGantInstance(Gant gant, Closure<?> doNothingClosure, GantBinding binding) {
        GantResult result = new GantResult();
        try {
            result.script = gant.prepareTargets();
            gant.setAllPerTargetPostHooks(doNothingClosure);
            gant.setAllPerTargetPreHooks(doNothingClosure);
            result.exitCode = gant.executeTargets();
            GantResult gantResult = result;
            return gantResult;
        }
        finally {
            this.cleanup(result, binding);
        }
    }

    private boolean isGrailsProject() {
        return new File(this.settings.getBaseDir(), "grails-app").exists();
    }

    private boolean isExternalScript(File scriptFile) {
        return this.scriptsAllowedOutsideOfProject.contains(scriptFile);
    }

    private String getScriptNameFromFile(File scriptPath) {
        String fileName = scriptPath.getName();
        String scriptFileName = fileName.substring(0, fileName.length() - 7);
        if (scriptFileName.endsWith("_")) {
            scriptFileName = scriptFileName.substring(0, scriptFileName.length() - 1);
        }
        return scriptFileName;
    }

    public List<File> getAvailableScripts() {
        ArrayList<File> scripts = new ArrayList<File>();
        if (this.settings.getGrailsHome() != null) {
            GrailsScriptRunner.addCommandScripts(new File(this.settings.getGrailsHome(), "scripts"), scripts);
            GrailsScriptRunner.addCommandScripts(new File(this.settings.getGrailsHome(), "grails-scripts/src/main/scripts"), scripts);
        }
        GrailsScriptRunner.addCommandScripts(new File(this.settings.getBaseDir(), "scripts"), scripts);
        GrailsScriptRunner.addCommandScripts(new File(this.settings.getUserHome(), ".grails/scripts"), scripts);
        for (File dir : this.pluginPathSupport.listKnownPluginDirs()) {
            GrailsScriptRunner.addPluginScripts(dir, scripts);
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.settings.getRootLoader());
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:META-INF/scripts/*.groovy")) {
                scripts.add(resource.getFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return scripts;
    }

    private static void addPluginScripts(File pluginDir, List<File> scripts) {
        if (!pluginDir.exists()) {
            return;
        }
        File scriptDir = new File(pluginDir, "scripts");
        if (scriptDir.exists()) {
            GrailsScriptRunner.addCommandScripts(scriptDir, scripts);
        }
    }

    private static void addCommandScripts(File dir, List<File> scripts) {
        if (!dir.exists()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (!scriptFilePattern.matcher(file.getName()).matches()) continue;
            scripts.add(file);
        }
    }

    static {
        DO_NOTHING_CLOSURE = new Closure(GrailsScriptRunner.class){
            private static final long serialVersionUID = 1L;

            public Object call(Object arguments) {
                return null;
            }

            public Object call() {
                return null;
            }

            public Object call(Object ... args) {
                return null;
            }
        };
    }

    private static class ScriptAndArgs {
        public String inputName;
        public String name;
        public String env;

        private ScriptAndArgs() {
        }
    }

    class GantResult {
        int exitCode;
        GroovyObject script;

        GantResult() {
        }
    }
}

