/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.interactive;

import java.io.IOException;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.CompletionHandler;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private boolean eagerNewlines = true;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            jline.console.completer.CandidateListCompletionHandler.setBuffer((ConsoleReader)reader, (CharSequence)value, (int)pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            jline.console.completer.CandidateListCompletionHandler.setBuffer((ConsoleReader)reader, (CharSequence)value, (int)pos);
        }
        if (this.eagerNewlines) {
            reader.println();
        }
        jline.console.completer.CandidateListCompletionHandler.printCandidates((ConsoleReader)reader, candidates);
        reader.drawLine();
        return true;
    }

    private final String getUnambiguousCompletions(List<?> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuilder candidate = new StringBuilder();
        int count = first.length();
        for (int i = 0; i < count && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].startsWith(starts)) continue;
            return false;
        }
        return true;
    }
}

