/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.fork;

import java.util.LinkedHashSet;
import java.util.Set;

public class ForkedProcessShutdownHooks {
    private static final Set<Process> processes = new LinkedHashSet<Process>();
    private static Thread shutdownHook;

    public static synchronized boolean add(Process process) {
        if (shutdownHook == null) {
            shutdownHook = new Thread("ForkedGrailsProcess Shutdown Hook"){

                @Override
                public void run() {
                    ForkedProcessShutdownHooks.destroyProcesses();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        return processes.add(process);
    }

    public static synchronized boolean remove(Process process) {
        boolean wasRemoved = processes.remove(process);
        if (processes.isEmpty() && shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            shutdownHook = null;
        }
        return wasRemoved;
    }

    private static synchronized void destroyProcesses() {
        for (Process process : processes) {
            try {
                process.destroy();
            }
            catch (Throwable throwable) {}
        }
        processes.clear();
    }
}

