/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.grails.cli.support.PluginPathDiscoverySupport;
import org.codehaus.groovy.grails.resolve.DependencyReport;

public class ClasspathConfigurer {
    private BuildSettings settings;
    private boolean skipPlugins;
    private PluginPathDiscoverySupport pluginPathSupport;
    private boolean exitOnResolveError = true;

    public ClasspathConfigurer(PluginPathDiscoverySupport pluginPathSupport, BuildSettings settings, boolean skipPlugins) {
        this.settings = settings;
        this.skipPlugins = skipPlugins;
        this.pluginPathSupport = pluginPathSupport;
    }

    public ClasspathConfigurer(BuildSettings build, boolean skipPlugins) {
        this(new PluginPathDiscoverySupport(build), build, skipPlugins);
    }

    public URLClassLoader configuredClassLoader() {
        URLClassLoader classLoader;
        try {
            HashSet<String> existingJars = new HashSet<String>();
            for (URL url : this.settings.getRootLoader().getURLs()) {
                existingJars.add(url.getFile());
            }
            URL[] urls = this.getClassLoaderUrls(this.settings, new File(this.settings.getProjectWorkDir(), "scriptCache"), existingJars, this.skipPlugins);
            this.addUrlsToRootLoader(this.settings.getRootLoader(), urls);
            urls = new URL[]{this.settings.getClassesDir().toURI().toURL(), this.settings.getPluginClassesDir().toURI().toURL()};
            classLoader = new URLClassLoader(urls, (ClassLoader)this.settings.getRootLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Invalid classpath URL", ex);
        }
        return classLoader;
    }

    protected URL[] getClassLoaderUrls(BuildSettings settings, File cacheDir, Set<String> excludes, boolean skipPlugins) throws MalformedURLException {
        DependencyReport providedResolveReport;
        DependencyReport testResolveReport;
        DependencyReport runtimeResolveReport;
        DependencyReport compileResolveReport;
        DependencyReport buildResolveReport;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (settings.getGrailsHome() != null) {
            urls.add(cacheDir.toURI().toURL());
        }
        if (settings.getResourcesDir() != null && settings.getResourcesDir().exists()) {
            urls.add(settings.getResourcesDir().toURI().toURL());
        }
        boolean dependenciesExternallyConfigured = settings.isDependenciesExternallyConfigured();
        List<File> buildDependencies = settings.getBuildDependencies();
        if (!dependenciesExternallyConfigured && buildDependencies.isEmpty()) {
            GrailsConsole.getInstance().error("Required Grails build dependencies were not found. This is normally due to internet connectivity issues (such as a misconfigured proxy) or missing repositories in grails-app/conf/BuildConfig.groovy. Please verify your configuration to continue.");
            ClasspathConfigurer.cleanResolveCache(settings);
            System.exit(1);
        }
        this.addDependenciesToURLs(excludes, urls, buildDependencies);
        this.addDependenciesToURLs(excludes, urls, settings.getProvidedDependencies());
        this.addDependenciesToURLs(excludes, urls, settings.getTestDependencies());
        settings.getRuntimeDependencies();
        settings.getCompileDependencies();
        if (!skipPlugins) {
            for (File dir : this.pluginPathSupport.listKnownPluginDirs()) {
                this.addPluginLibs(dir, urls, settings);
            }
        }
        if ((buildResolveReport = settings.getBuildResolveReport()) != null && buildResolveReport.hasError()) {
            this.handleResolveError(settings, buildResolveReport);
        }
        if ((compileResolveReport = settings.getCompileResolveReport()) != null && compileResolveReport.hasError()) {
            this.handleResolveError(settings, compileResolveReport);
        }
        if ((runtimeResolveReport = settings.getRuntimeResolveReport()) != null && runtimeResolveReport.hasError()) {
            this.handleResolveError(settings, runtimeResolveReport);
        }
        if ((testResolveReport = settings.getTestResolveReport()) != null && testResolveReport.hasError()) {
            this.handleResolveError(settings, testResolveReport);
        }
        if ((providedResolveReport = settings.getProvidedResolveReport()) != null && providedResolveReport.hasError()) {
            this.handleResolveError(settings, providedResolveReport);
        }
        settings.storeDependencyCache();
        return urls.toArray(new URL[urls.size()]);
    }

    private void handleResolveError(BuildSettings settings, DependencyReport buildResolveReport) {
        ClasspathConfigurer.cleanResolveCache(settings);
        GrailsConsole grailsConsole = GrailsConsole.getInstance();
        grailsConsole.error(buildResolveReport.getResolveError().getMessage());
        grailsConsole.addStatus("Run 'grails dependency-report' for further information.");
        if (this.exitOnResolveError) {
            System.exit(1);
        }
    }

    public static void cleanResolveCache(BuildSettings settings) {
        File[] files;
        File projectWorkDir = settings.getProjectWorkDir();
        if (projectWorkDir != null && (files = projectWorkDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(".resolve");
            }
        })) != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    protected void addDependenciesToURLs(Set<String> excludes, List<URL> urls, List<File> runtimeDeps) throws MalformedURLException {
        if (runtimeDeps == null) {
            return;
        }
        for (File file : runtimeDeps) {
            URL url;
            if (file == null) continue;
            if (file.getName().contains("xercesImpl")) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            }
            if (excludes == null || excludes.contains(file.getName()) || urls.contains(url = file.toURI().toURL())) continue;
            urls.add(url);
            excludes.add(file.getName());
        }
    }

    protected void addPluginLibs(File pluginDir, List<URL> urls, BuildSettings settings) throws MalformedURLException {
        if (!pluginDir.exists()) {
            return;
        }
        File libDir = new File(pluginDir, "lib");
        if (libDir.exists()) {
            this.addLibs(libDir, urls, Collections.emptyList());
        }
    }

    protected void addLibs(File dir, List<URL> urls, Collection<?> excludes) throws MalformedURLException {
        if (!dir.exists()) {
            return;
        }
        for (File file : dir.listFiles()) {
            boolean include = true;
            for (Object me : excludes) {
                String exclude = me.toString();
                if (!file.getName().contains(exclude)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            urls.add(file.toURI().toURL());
        }
    }

    protected void addUrlsToRootLoader(URLClassLoader loader, URL[] urls) {
        try {
            Class<?> loaderClass = loader.getClass();
            Method method = loaderClass.getMethod("addURL", URL.class);
            for (URL url : urls) {
                method.invoke((Object)loader, url);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot dynamically add URLs to GrailsScriptRunner's class loader - make sure that it is loaded by Groovy's RootLoader or a sub-class.");
        }
    }

    public void setExitOnResolveError(boolean exitOnResolveError) {
        this.exitOnResolveError = exitOnResolveError;
    }
}

