/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve.config;

import grails.build.logging.GrailsConsole;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.codehaus.groovy.grails.resolve.EnhancedDefaultDependencyDescriptor;
import org.codehaus.groovy.grails.resolve.config.AbstractDependencyManagementConfigurer;
import org.codehaus.groovy.grails.resolve.config.DependencyConfigurationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDependenciesConfigurer
extends AbstractDependencyManagementConfigurer {
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*?):([a-zA-Z0-9\\-/\\._+=]+?):([a-zA-Z0-9\\-/\\.,\\]\\[\\(\\)_+=]+)");

    public AbstractDependenciesConfigurer(DependencyConfigurationContext context) {
        super(context);
    }

    public Object invokeMethod(String name, Object args) {
        if (args == null) {
            GrailsConsole.getInstance().error("WARNING: Configurational method [" + name + "] in grails-app/conf/BuildConfig.groovy doesn't exist. Ignoring..");
            return null;
        }
        List<Object> argsList = Arrays.asList((Object[])args);
        if (argsList.isEmpty()) {
            GrailsConsole.getInstance().error("WARNING: Configurational method [" + name + "] in grails-app/conf/BuildConfig.groovy doesn't exist. Ignoring..");
            return null;
        }
        if (this.isOnlyStrings(argsList)) {
            this.addDependencyStrings(name, argsList, null, null);
        } else if (this.isProperties(argsList)) {
            this.addDependencyMaps(name, argsList, null);
        } else if (this.isStringsAndConfigurer(argsList)) {
            this.addDependencyStrings(name, argsList.subList(0, argsList.size() - 1), null, (Closure)argsList.get(argsList.size() - 1));
        } else if (this.isPropertiesAndConfigurer(argsList)) {
            this.addDependencyMaps(name, argsList.subList(0, argsList.size() - 1), (Closure)argsList.get(argsList.size() - 1));
        } else if (this.isStringsAndProperties(argsList)) {
            this.addDependencyStrings(name, argsList.subList(0, argsList.size() - 1), (Map)argsList.get(argsList.size() - 1), null);
        } else {
            GrailsConsole.getInstance().error("WARNING: Configurational method [" + name + "] in grails-app/conf/BuildConfig.groovy doesn't exist. Ignoring..");
        }
        return null;
    }

    private boolean isOnlyStrings(List<Object> args) {
        for (Object arg : args) {
            if (arg instanceof CharSequence) continue;
            return false;
        }
        return true;
    }

    private boolean isStringsAndConfigurer(List<Object> args) {
        if (args.size() == 1) {
            return false;
        }
        return this.isOnlyStrings(args.subList(0, args.size() - 1)) && args.get(args.size() - 1) instanceof Closure;
    }

    private boolean isStringsAndProperties(List<Object> args) {
        if (args.size() == 1) {
            return false;
        }
        return this.isOnlyStrings(args.subList(0, args.size() - 1)) && args.get(args.size() - 1) instanceof Map;
    }

    private boolean isProperties(List<Object> args) {
        for (Object arg : args) {
            if (arg instanceof Map) continue;
            return false;
        }
        return true;
    }

    private boolean isPropertiesAndConfigurer(List<Object> args) {
        if (args.size() == 1) {
            return false;
        }
        return this.isProperties(args.subList(0, args.size() - 1)) && args.get(args.size() - 1) instanceof Closure;
    }

    private Map<Object, Object> extractDependencyProperties(String scope, String dependency) {
        Matcher matcher = DEPENDENCY_PATTERN.matcher(dependency);
        if (matcher.matches()) {
            HashMap<Object, Object> properties = new HashMap<Object, Object>(3);
            properties.put("name", matcher.group(2));
            properties.put("group", matcher.group(1));
            properties.put("version", matcher.group(3));
            return properties;
        }
        GrailsConsole.getInstance().error("WARNING: Specified dependency definition " + scope + "(" + dependency + ") is invalid! Skipping..");
        return null;
    }

    private void addDependencyStrings(String scope, List<Object> dependencies, Map<Object, Object> overrides, Closure<?> configurer) {
        for (Object dependency : dependencies) {
            Map<Object, Object> dependencyProperties = this.extractDependencyProperties(scope, dependency.toString());
            if (dependencyProperties == null) continue;
            if (overrides != null) {
                for (Map.Entry<Object, Object> override : overrides.entrySet()) {
                    dependencyProperties.put(override.getKey().toString(), override.getValue().toString());
                }
            }
            this.addDependency(scope, dependencyProperties, configurer);
        }
    }

    private void addDependencyMaps(String scope, List<Object> dependencies, Closure<?> configurer) {
        for (Object dependency : dependencies) {
            this.addDependency(scope, (Map)dependency, configurer);
        }
    }

    private String nullSafeToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private void addDependency(String scope, Map<Object, Object> dependency, Closure<?> configurer) {
        boolean isExcluded;
        this.preprocessDependencyProperties(dependency);
        String name = this.nullSafeToString(dependency.get("name"));
        String group = this.nullSafeToString(dependency.get("group"));
        String version = this.nullSafeToString(dependency.get("version"));
        String classifier = this.nullSafeToString(dependency.get("classifier"));
        String branch = this.nullSafeToString(dependency.get("branch"));
        boolean transitive = this.getBooleanValueOrDefault(dependency, "transitive", true);
        Boolean export = this.getExportSetting(dependency);
        boolean bl = isExcluded = this.context.pluginName == null ? this.context.dependencyManager.isExcluded(name) : this.context.dependencyManager.isExcludedFromPlugin(this.context.pluginName, name);
        if (isExcluded) {
            return;
        }
        HashMap<String, String> attrs = null;
        if (classifier != null) {
            attrs = new HashMap<String, String>(1);
            attrs.put("m:classifier", classifier);
        }
        ModuleRevisionId mrid = branch == null ? ModuleRevisionId.newInstance((String)group, (String)name, (String)version, attrs) : ModuleRevisionId.newInstance((String)group, (String)name, (String)branch, (String)version, attrs);
        EnhancedDefaultDependencyDescriptor dependencyDescriptor = new EnhancedDefaultDependencyDescriptor(mrid, false, transitive, scope);
        this.handleExport(dependencyDescriptor, export);
        boolean inherited = this.context.inherited || this.context.dependencyManager.getInheritsAll() || this.context.pluginName != null;
        dependencyDescriptor.setInherited(inherited);
        if (this.context.pluginName != null) {
            dependencyDescriptor.setPlugin(this.context.pluginName);
        }
        if (configurer != null) {
            dependencyDescriptor.configure(configurer);
        }
        this.addArtifacts(scope, dependencyDescriptor);
        if (!this.isExcluded(dependencyDescriptor)) {
            this.addDependency(scope, dependencyDescriptor);
        }
    }

    private boolean isExcluded(EnhancedDefaultDependencyDescriptor dependencyDescriptor) {
        ExcludeRule[] excludeRules = this.context.getExcludeRules();
        if (excludeRules != null) {
            ArtifactId aid = new ArtifactId(dependencyDescriptor.getDependencyId(), "*", "*", "*");
            for (ExcludeRule excludeRule : excludeRules) {
                if (!MatcherHelper.matches((PatternMatcher)excludeRule.getMatcher(), (ArtifactId)excludeRule.getId(), (ArtifactId)aid)) continue;
                return true;
            }
        }
        return false;
    }

    protected Boolean getExportSetting(Map<Object, Object> dependency) {
        return dependency.containsKey("export") ? Boolean.valueOf(dependency.get("export").toString()) : null;
    }

    private boolean getBooleanValueOrDefault(Map<Object, Object> properties, String propertyName, boolean defaultValue) {
        return properties.containsKey(propertyName) ? Boolean.valueOf(properties.get(propertyName).toString()) : defaultValue;
    }

    protected void preprocessDependencyProperties(Map<Object, Object> dependency) {
    }

    protected abstract void addDependency(String var1, EnhancedDefaultDependencyDescriptor var2);

    protected abstract void handleExport(EnhancedDefaultDependencyDescriptor var1, Boolean var2);

    protected abstract void addArtifacts(String var1, EnhancedDefaultDependencyDescriptor var2);
}

