/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.parsing;

import grails.util.Environment;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.codehaus.groovy.grails.cli.parsing.CommandLine;
import org.codehaus.groovy.grails.cli.parsing.DefaultCommandLine;
import org.codehaus.groovy.grails.cli.parsing.Option;
import org.codehaus.groovy.grails.cli.parsing.ParseException;

public class CommandLineParser {
    static Map<String, String> ENV_ARGS = new HashMap<String, String>();
    static Map<String, String> DEFAULT_ENVS = new HashMap<String, String>();
    private static final String DEFAULT_PADDING = "        ";
    private Map<String, Option> declaredOptions = new HashMap<String, Option>();
    private int longestOptionNameLength = 0;
    private String usageMessage;

    public void addOption(String name, String description) {
        int length = name.length();
        if (length > this.longestOptionNameLength) {
            this.longestOptionNameLength = length;
        }
        this.declaredOptions.put(name, new Option(name, description));
    }

    public CommandLine parseString(String string) {
        try {
            return this.parse(Commandline.translateCommandline((String)string));
        }
        catch (BuildException e) {
            throw new ParseException(e);
        }
    }

    public CommandLine parseString(String commandName, String args) {
        try {
            String[] argArray = Commandline.translateCommandline((String)args);
            DefaultCommandLine cl = this.createCommandLine();
            cl.setCommandName(commandName);
            this.parseInternal(cl, argArray, false);
            return cl;
        }
        catch (BuildException e) {
            throw new ParseException(e);
        }
    }

    public CommandLine parse(String ... args) {
        DefaultCommandLine cl = this.createCommandLine();
        this.parseInternal(cl, args, true);
        return cl;
    }

    private void parseInternal(DefaultCommandLine cl, String[] args, boolean firstArgumentIsCommand) {
        for (String arg : args) {
            String trimmed;
            if (arg == null || (trimmed = arg.trim()) == null || trimmed.length() <= 0) continue;
            if (trimmed.charAt(0) == '-') {
                this.processOption(cl, trimmed);
                continue;
            }
            if (firstArgumentIsCommand && ENV_ARGS.containsKey(trimmed)) {
                cl.setEnvironment(ENV_ARGS.get(trimmed));
                continue;
            }
            if (firstArgumentIsCommand) {
                cl.setCommandName(trimmed);
                firstArgumentIsCommand = false;
                continue;
            }
            cl.addRemainingArg(trimmed);
        }
    }

    public String getOptionsHelpMessage() {
        String ls = System.getProperty("line.separator");
        this.usageMessage = "Available options:";
        StringBuilder sb = new StringBuilder(this.usageMessage);
        sb.append(ls);
        for (Option option : this.declaredOptions.values()) {
            String name = option.getName();
            int extraPadding = this.longestOptionNameLength - name.length();
            sb.append(" -").append(name);
            for (int i = 0; i < extraPadding; ++i) {
                sb.append(' ');
            }
            sb.append(DEFAULT_PADDING).append(option.getDescription()).append(ls);
        }
        return sb.toString();
    }

    protected DefaultCommandLine createCommandLine() {
        return new DefaultCommandLine();
    }

    protected void processOption(DefaultCommandLine cl, String arg) {
        if (arg.length() < 2) {
            return;
        }
        if (arg.charAt(1) == 'D' && arg.contains("=")) {
            this.processSystemArg(cl, arg);
            return;
        }
        if ((arg = (arg.charAt(1) == '-' ? arg.substring(2, arg.length()) : arg.substring(1, arg.length())).trim()).contains("=")) {
            String[] split = arg.split("=");
            String name = split[0].trim();
            this.validateOptionName(name);
            String value = split[1].trim();
            if (this.declaredOptions.containsKey(name)) {
                cl.addDeclaredOption(name, this.declaredOptions.get(name), value);
            } else {
                cl.addUndeclaredOption(name, value);
            }
            return;
        }
        this.validateOptionName(arg);
        if (this.declaredOptions.containsKey(arg)) {
            cl.addDeclaredOption(arg, this.declaredOptions.get(arg));
        } else {
            cl.addUndeclaredOption(arg);
        }
    }

    private void validateOptionName(String name) {
        if (name.contains(" ")) {
            throw new ParseException("Invalid argument: " + name);
        }
    }

    protected void processSystemArg(DefaultCommandLine cl, String arg) {
        int i = arg.indexOf("=");
        String name = arg.substring(2, i);
        String value = arg.substring(i + 1, arg.length());
        cl.addSystemProperty(name, value);
    }

    static {
        ENV_ARGS.put("dev", Environment.DEVELOPMENT.getName());
        ENV_ARGS.put("prod", Environment.PRODUCTION.getName());
        ENV_ARGS.put("test", Environment.TEST.getName());
        DEFAULT_ENVS.put("war", Environment.PRODUCTION.getName());
        DEFAULT_ENVS.put("test-app", Environment.TEST.getName());
    }
}

