/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import grails.build.GrailsBuildListener;
import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import grails.util.PluginBuildSettings;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.runtime.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsBuildEventListener
implements BuildListener {
    private static final Pattern EVENT_NAME_PATTERN = Pattern.compile("event([A-Z]\\w*)");
    private GroovyClassLoader classLoader;
    private Binding binding;
    protected Map<String, List<Closure>> globalEventHooks = new HashMap<String, List<Closure>>();
    private BuildSettings buildSettings;
    private List<GrailsBuildListener> buildListeners = new LinkedList<GrailsBuildListener>();

    public GrailsBuildEventListener(GroovyClassLoader scriptClassLoader, Binding binding, BuildSettings buildSettings) {
        this.classLoader = scriptClassLoader;
        this.binding = binding;
        this.buildSettings = buildSettings;
    }

    public void initialize() {
        this.loadEventHooks(this.buildSettings);
        this.loadGrailsBuildListeners();
    }

    public void setClassLoader(GroovyClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setGlobalEventHooks(Map<String, List<Closure>> globalEventHooks) {
        this.globalEventHooks = globalEventHooks;
    }

    protected void loadEventHooks(BuildSettings buildSettings) {
        if (buildSettings == null) {
            return;
        }
        this.loadEventsScript(this.findEventsScript(new File(buildSettings.getUserHome(), ".grails/scripts")));
        this.loadEventsScript(this.findEventsScript(new File(buildSettings.getBaseDir(), "scripts")));
        PluginBuildSettings pluginSettings = (PluginBuildSettings)this.binding.getVariable("pluginSettings");
        for (Resource pluginBase : pluginSettings.getPluginDirectories()) {
            try {
                this.loadEventsScript(this.findEventsScript(new File(pluginBase.getFile(), "scripts")));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void loadGrailsBuildListeners() {
        for (Object listener : this.buildSettings.getBuildListeners()) {
            if (listener instanceof String) {
                this.addGrailsBuildListener((String)listener);
                continue;
            }
            if (listener instanceof Class) {
                this.addGrailsBuildListener((Class)listener);
                continue;
            }
            throw new IllegalStateException("buildSettings.getBuildListeners() returned a " + listener.getClass().getName());
        }
    }

    public void loadEventsScript(File eventScript) {
        if (eventScript == null) {
            return;
        }
        GrailsConsole console = GrailsConsole.getInstance();
        try {
            Class scriptClass = this.classLoader.parseClass(eventScript);
            if (scriptClass == null) {
                console.error("Could not load event script (script may be empty): " + eventScript);
                return;
            }
            Script script = (Script)scriptClass.newInstance();
            script.setBinding(new Binding(this.binding.getVariables()){

                public void setVariable(String var, Object o) {
                    Matcher matcher = EVENT_NAME_PATTERN.matcher(var);
                    if (matcher.matches() && o instanceof Closure) {
                        String eventName = matcher.group(1);
                        List<Closure> hooks = GrailsBuildEventListener.this.globalEventHooks.get(eventName);
                        if (hooks == null) {
                            hooks = new ArrayList<Closure>();
                            GrailsBuildEventListener.this.globalEventHooks.put(eventName, hooks);
                        }
                        hooks.add((Closure)o);
                    }
                    super.setVariable(var, o);
                }
            });
            script.run();
        }
        catch (Throwable e) {
            StackTraceUtils.deepSanitize((Throwable)e);
            console.error("Error loading event script from file [" + eventScript + "] " + e.getMessage(), e);
        }
    }

    protected File findEventsScript(File dir) {
        File f = new File(dir, "_Events.groovy");
        if (!f.exists()) {
            f = new File(dir, "Events.groovy");
        }
        return f.exists() ? f : null;
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
        String targetName = buildEvent.getTarget().getName();
        String eventName = GrailsNameUtils.getClassNameRepresentation(targetName) + "Start";
        this.triggerEvent(eventName, this.binding);
    }

    @Deprecated
    public void event(String eventName, List arguments) {
        this.triggerEvent(eventName, arguments.toArray());
    }

    @Deprecated
    public void event(String eventName) {
        this.triggerEvent(eventName);
    }

    public void triggerEvent(String eventName) {
        this.triggerEvent(eventName, this.binding);
    }

    public void triggerEvent(String eventName, Object ... arguments) {
        List<Closure> handlers = this.globalEventHooks.get(eventName);
        if (handlers != null) {
            for (Closure handler : handlers) {
                handler.setDelegate((Object)this.binding);
                try {
                    handler.call(arguments);
                }
                catch (MissingPropertyException mpe) {}
            }
        }
        for (GrailsBuildListener buildListener : this.buildListeners) {
            buildListener.receiveGrailsBuildEvent(eventName, arguments);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        String targetName = buildEvent.getTarget().getName();
        String eventName = GrailsNameUtils.getClassNameRepresentation(targetName) + "End";
        this.triggerEvent(eventName, this.binding);
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    protected void addGrailsBuildListener(String listenerClassName) {
        Class listenerClass;
        try {
            listenerClass = this.classLoader.loadClass(listenerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load grails build listener class", e);
        }
        this.addGrailsBuildListener(listenerClass);
    }

    protected void addGrailsBuildListener(Class listenerClass) {
        if (!GrailsBuildListener.class.isAssignableFrom(listenerClass)) {
            throw new RuntimeException("Intended grails build listener class of " + listenerClass.getName() + " does not implement " + GrailsBuildListener.class.getName());
        }
        try {
            this.addGrailsBuildListener((GrailsBuildListener)listenerClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate " + listenerClass.getName(), e);
        }
    }

    public void addGrailsBuildListener(GrailsBuildListener listener) {
        this.buildListeners.add(listener);
    }
}

