/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve.maven;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public class GrailsPackagingAwarePomModuleDescriptorBuilder
extends PomModuleDescriptorBuilder {
    private static final String DEPENDENCY_MANAGEMENT = "m:dependency.management";
    private static final String PROPERTIES = "m:properties";
    private static final String EXTRA_INFO_DELIMITER = "__";
    private static final String WRONG_NUMBER_OF_PARTS_MSG = "what seemed to be a dependency management extra info exclusion had the wrong number of parts (should have 2) ";
    private static final Collection JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin");
    static final Map MAVEN2_CONF_MAPPING = new HashMap();
    public static final String GRAILS_PLUGIN_PACKAGING = "grails-plugin";
    public static final String GRAILS_BINARY_PLUGIN_PACKAGING = "grails-binary-plugin";
    public static final String GRAILS_APP_PACKAGING = "grails-app";

    public GrailsPackagingAwarePomModuleDescriptorBuilder(ModuleDescriptorParser parser, Resource res, ParserSettings ivySettings) {
        super(parser, res, ivySettings);
    }

    public void addMainArtifact(String artifactId, String packaging) {
        super.addMainArtifact(artifactId, this.getPackagingForGrailsType(packaging));
    }

    private String getPackagingForGrailsType(String packaging) {
        if (GRAILS_PLUGIN_PACKAGING.equals(packaging)) {
            packaging = "zip";
        } else if (GRAILS_BINARY_PLUGIN_PACKAGING.equals(packaging)) {
            packaging = "jar";
        } else if (GRAILS_APP_PACKAGING.equals(packaging)) {
            packaging = "war";
        }
        return packaging;
    }

    public void addDependency(Resource res, PomReader.PomDependencyData dep) {
        List excluded;
        String version;
        String scope = dep.getScope();
        if (scope != null && scope.length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(scope)) {
            scope = "compile";
        }
        version = (version = dep.getVersion()) == null || version.length() == 0 ? this.getDefaultVersion(dep) : version;
        ModuleRevisionId moduleRevId = ModuleRevisionId.newInstance((String)dep.getGroupId(), (String)dep.getArtifactId(), (String)version);
        if (moduleRevId.getName().equals("grails-dependencies")) {
            return;
        }
        DefaultModuleDescriptor ivyModuleDescriptor = this.getIvyModuleDescriptor();
        ModuleRevisionId mRevId = ivyModuleDescriptor.getModuleRevisionId();
        if (mRevId != null && mRevId.getModuleId().equals((Object)moduleRevId.getModuleId())) {
            return;
        }
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)ivyModuleDescriptor, moduleRevId, true, false, true);
        scope = scope == null || scope.length() == 0 ? this.getDefaultScope(dep) : scope;
        Object mapping = MAVEN2_CONF_MAPPING.get(scope);
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(mapping.getClass());
        metaClass.invokeMethod(mapping, "addMappingConfs", new Object[]{dd, dep.isOptional()});
        HashMap<String, String> extraAtt = new HashMap<String, String>();
        if (dep.getClassifier() != null || dep.getType() != null && !"jar".equals(dep.getType())) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            String ext = type = this.getPackagingForGrailsType(type);
            if ("test-jar".equals(type)) {
                ext = "jar";
                extraAtt.put("m:classifier", "tests");
            } else if (JAR_PACKAGINGS.contains(type)) {
                ext = "jar";
            }
            ext = this.getPackagingForGrailsType(type);
            if (dep.getClassifier() != null) {
                extraAtt.put("m:classifier", dep.getClassifier());
            }
            DefaultDependencyArtifactDescriptor depArtifact = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)dd, dd.getDependencyId().getName(), type, ext, null, extraAtt);
            String optionalizedScope = dep.isOptional() ? "optional" : scope;
            dd.addDependencyArtifact(optionalizedScope, (DependencyArtifactDescriptor)depArtifact);
        }
        if ((excluded = dep.getExcludedModules()).isEmpty()) {
            excluded = GrailsPackagingAwarePomModuleDescriptorBuilder.getDependencyMgtExclusions((ModuleDescriptor)ivyModuleDescriptor, dep.getGroupId(), dep.getArtifactId());
        }
        for (ModuleId excludedModule : excluded) {
            String[] confs = dd.getModuleConfigurations();
            for (int k = 0; k < confs.length; ++k) {
                dd.addExcludeRule(confs[k], (ExcludeRule)new DefaultExcludeRule(new ArtifactId(excludedModule, "*", "*", "*"), (PatternMatcher)ExactPatternMatcher.INSTANCE, null));
            }
        }
        ivyModuleDescriptor.addDependency((DependencyDescriptor)dd);
    }

    private DefaultModuleDescriptor getIvyModuleDescriptor() {
        try {
            Field field = PomModuleDescriptorBuilder.class.getDeclaredField("ivyModuleDescriptor");
            field.setAccessible(true);
            return (DefaultModuleDescriptor)field.get((Object)this);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Cannot obtain reference to ivy module descriptor to configure POM data correctly. Message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot obtain reference to ivy module descriptor to configure POM data correctly. Message: " + e.getMessage());
        }
    }

    private static List getDependencyMgtExclusions(ModuleDescriptor descriptor, String groupId, String artifactId) {
        String exclusionPrefix = GrailsPackagingAwarePomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion(groupId, artifactId);
        LinkedList<ModuleId> exclusionIds = new LinkedList<ModuleId>();
        Map extras = descriptor.getExtraInfo();
        for (Map.Entry ent : extras.entrySet()) {
            String key = (String)ent.getKey();
            if (!key.startsWith(exclusionPrefix)) continue;
            String fullExclusion = (String)ent.getValue();
            String[] exclusionParts = fullExclusion.split(EXTRA_INFO_DELIMITER);
            if (exclusionParts.length != 2) {
                Message.error((String)(WRONG_NUMBER_OF_PARTS_MSG + exclusionParts.length + " : " + fullExclusion));
                continue;
            }
            exclusionIds.add(ModuleId.newInstance((String)exclusionParts[0], (String)exclusionParts[1]));
        }
        return exclusionIds;
    }

    private static String getDependencyMgtExtraInfoPrefixForExclusion(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + EXTRA_INFO_DELIMITER + artifaceId + EXTRA_INFO_DELIMITER + "exclusion_";
    }

    private static String getDependencyMgtExtraInfoKeyForScope(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + EXTRA_INFO_DELIMITER + artifaceId + EXTRA_INFO_DELIMITER + "scope";
    }

    private static String getDependencyMgtExtraInfoKeyForVersion(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + EXTRA_INFO_DELIMITER + artifaceId + EXTRA_INFO_DELIMITER + "version";
    }

    private String getDefaultScope(PomReader.PomDependencyData dep) {
        String key = GrailsPackagingAwarePomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(dep.getGroupId(), dep.getArtifactId());
        String result = (String)this.getIvyModuleDescriptor().getExtraInfo().get(key);
        if (result == null || !MAVEN2_CONF_MAPPING.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        String key = GrailsPackagingAwarePomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(dep.getGroupId(), dep.getArtifactId());
        return (String)this.getIvyModuleDescriptor().getExtraInfo().get(key);
    }

    static {
        try {
            Field field = PomModuleDescriptorBuilder.class.getDeclaredField("MAVEN2_CONF_MAPPING");
            field.setAccessible(true);
            Map m = (Map)field.get(PomModuleDescriptorBuilder.class);
            MAVEN2_CONF_MAPPING.putAll(m);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Cannot obtain reference to ivy module descriptor to configure POM data correctly. Message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot obtain reference to ivy module descriptor to configure POM data correctly. Message: " + e.getMessage());
        }
    }
}

