/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve.config;

import grails.util.BuildSettings;
import grails.util.Metadata;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.codehaus.groovy.grails.resolve.EnhancedDefaultDependencyDescriptor;
import org.codehaus.groovy.grails.resolve.GrailsCoreDependencies;
import org.codehaus.groovy.grails.resolve.IvyDependencyManager;

public class DependencyConfigurationContext {
    public final IvyDependencyManager dependencyManager;
    public final String pluginName;
    public final boolean inherited;
    public final boolean exported;
    private boolean offline;
    private ExcludeRule[] excludeRules;
    private String parentScope;

    private DependencyConfigurationContext(IvyDependencyManager dependencyManager, String pluginName, boolean inherited) {
        this.dependencyManager = dependencyManager;
        this.pluginName = pluginName;
        this.inherited = inherited;
        if (pluginName != null) {
            DependencyDescriptor pluginDependencyDescriptor = dependencyManager.getPluginDependencyDescriptor(pluginName);
            this.exported = Metadata.getCurrent().getInstalledPlugins().containsKey(pluginName) || !(pluginDependencyDescriptor instanceof EnhancedDefaultDependencyDescriptor) || ((EnhancedDefaultDependencyDescriptor)pluginDependencyDescriptor).getExported();
        } else {
            this.exported = true;
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public static DependencyConfigurationContext forApplication(IvyDependencyManager dependencyManager) {
        return new DependencyConfigurationContext(dependencyManager, null, false);
    }

    public static DependencyConfigurationContext forPlugin(IvyDependencyManager dependencyManager, String pluginName) {
        return new DependencyConfigurationContext(dependencyManager, pluginName, false);
    }

    public DependencyConfigurationContext createInheritedContext() {
        return new DependencyConfigurationContext(this.dependencyManager, this.pluginName, true);
    }

    public GrailsCoreDependencies getGrailsCoreDependencies() {
        BuildSettings buildSettings = this.dependencyManager.getBuildSettings();
        if (buildSettings == null) {
            throw new IllegalStateException("Cannot ask for grails core dependencies if the dependency manager was configured without build settings, as it was in this case.");
        }
        return buildSettings.getCoreDependencies();
    }

    public void setExcludeRules(ExcludeRule[] excludeRules) {
        this.excludeRules = excludeRules;
    }

    public ExcludeRule[] getExcludeRules() {
        return this.excludeRules;
    }

    public void setParentScope(String scope) {
        this.parentScope = scope;
    }

    public String getParentScope() {
        return this.parentScope;
    }
}

