/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.springframework.core.io.Resource;

public class BasicGrailsPluginInfo
extends GroovyObjectSupport
implements GrailsPluginInfo {
    private String name;
    private String version;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private Resource descriptor;

    public BasicGrailsPluginInfo(Resource pluginLocation) {
        this.descriptor = pluginLocation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setProperty(String property, Object newValue) {
        try {
            super.setProperty(property, newValue);
        }
        catch (MissingPropertyException e) {
            this.attributes.put(property, newValue);
        }
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return this.attributes.get(property);
        }
    }

    public String getFullName() {
        return this.name + '-' + this.version;
    }

    public Resource getDescriptor() {
        return this.descriptor;
    }

    public Resource getPluginDir() {
        try {
            return this.descriptor.createRelative(".");
        }
        catch (IOException e) {
            return null;
        }
    }

    public Map getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.attributes);
        props.put("name", this.name);
        props.put("version", this.version);
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicGrailsPluginInfo that = (BasicGrailsPluginInfo)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

