/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli;

import gant.Gant;
import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.util.AntBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;
import org.codehaus.gant.GantBinding;
import org.codehaus.groovy.grails.cli.CachedScript;
import org.codehaus.groovy.grails.cli.CommandLineHelper;
import org.codehaus.groovy.grails.cli.ScriptExitException;
import org.codehaus.groovy.grails.cli.ScriptNotFoundException;
import org.codehaus.groovy.grails.resolve.IvyDependencyManager;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsScriptRunner {
    private static Map<String, String> ENV_ARGS = new HashMap<String, String>();
    private static Map<String, String> DEFAULT_ENVS = new HashMap<String, String>();
    private static final Pattern scriptFilePattern;
    private static final Pattern pluginDescriptorPattern;
    private BuildSettings settings;
    private PrintStream out = System.out;
    private CommandLineHelper helper = new CommandLineHelper(this.out);
    private boolean isInteractive = true;
    private final Map<String, CachedScript> scriptCache = new HashMap<String, CachedScript>();
    private final List<File> scriptsAllowedOutsideOfProject = new ArrayList<File>();

    public static void main(String[] args) throws MalformedURLException {
        StringBuilder allArgs = new StringBuilder("");
        for (String arg : args) {
            allArgs.append(" ").append(arg);
        }
        ScriptAndArgs script = GrailsScriptRunner.processArgumentsAndReturnScriptName(allArgs.toString().trim());
        String grailsHome = System.getProperty("grails.home");
        BuildSettings build = null;
        try {
            build = new BuildSettings(new File(grailsHome));
        }
        catch (Exception e) {
            System.err.println("An error occurred loading the grails-app/conf/BuildConfig.groovy file: " + e.getMessage());
            System.exit(1);
        }
        File grailsHomeInSettings = build.getGrailsHome();
        if (grailsHomeInSettings == null || !grailsHomeInSettings.exists()) {
            GrailsScriptRunner.exitWithError("Grails' installation directory not found: " + build.getGrailsHome());
        }
        System.out.println("Welcome to Grails " + build.getGrailsVersion() + " - http://grails.org/" + '\n' + "Licensed under Apache Standard License 2.0" + '\n' + "Grails home is " + (grailsHome == null ? "not set" : "set to: " + grailsHome) + '\n');
        if (script.name == null) {
            System.out.println("No script name specified. Use 'grails help' for more info or 'grails interactive' to enter interactive mode");
            System.exit(0);
        }
        System.out.println("Base Directory: " + build.getBaseDir().getPath());
        try {
            GrailsScriptRunner runner = new GrailsScriptRunner(build);
            int exitCode = runner.executeCommand(script.name, script.args, script.env);
            System.exit(exitCode);
        }
        catch (ScriptNotFoundException ex) {
            System.out.println("Script not found: " + ex.getScriptName());
        }
        catch (Throwable t) {
            String msg = "Error executing script " + script.name + ": " + t.getMessage();
            System.out.println(msg);
            GrailsScriptRunner.sanitizeStacktrace(t);
            t.printStackTrace(System.out);
            System.out.println(msg);
            System.exit(1);
        }
    }

    private static void exitWithError(String error) {
        System.out.println(error);
        System.exit(1);
    }

    private static ScriptAndArgs processArgumentsAndReturnScriptName(String allArgs) {
        String paramName;
        ScriptAndArgs info = new ScriptAndArgs();
        if (allArgs == null || allArgs.length() == 0) {
            return info;
        }
        String[] splitArgs = GrailsScriptRunner.processSystemArguments(allArgs).trim().split(" ");
        int currentParamIndex = 0;
        if (Environment.isSystemSet()) {
            info.env = Environment.getCurrent().getName();
        } else if (GrailsScriptRunner.isEnvironmentArgs(splitArgs[currentParamIndex])) {
            String env = splitArgs[currentParamIndex++];
            info.env = ENV_ARGS.get(env);
        }
        if (currentParamIndex >= splitArgs.length) {
            System.out.println("You should specify a script to run. Run 'grails help' for a complete list of available scripts.");
            System.exit(0);
        }
        if ((paramName = splitArgs[currentParamIndex++]).charAt(0) == '-') {
            paramName = paramName.substring(1);
        }
        info.name = GrailsNameUtils.getNameFromScript(paramName);
        if (currentParamIndex < splitArgs.length) {
            StringBuilder b = new StringBuilder(splitArgs[currentParamIndex]);
            for (int i = currentParamIndex + 1; i < splitArgs.length; ++i) {
                b.append(' ').append(splitArgs[i]);
            }
            info.args = b.toString();
        }
        return info;
    }

    private static String processSystemArguments(String allArgs) {
        String lastMatch = null;
        Pattern sysPropPattern = Pattern.compile("-D(.+?)=(.+?)\\s+?");
        Matcher m = sysPropPattern.matcher(allArgs);
        while (m.find()) {
            System.setProperty(m.group(1).trim(), m.group(2).trim());
            lastMatch = m.group();
        }
        if (lastMatch != null) {
            int i = allArgs.lastIndexOf(lastMatch) + lastMatch.length();
            allArgs = allArgs.substring(i);
        }
        return allArgs;
    }

    private static boolean isEnvironmentArgs(String env) {
        return ENV_ARGS.containsKey(env);
    }

    public GrailsScriptRunner() {
        this(new BuildSettings());
    }

    public GrailsScriptRunner(String grailsHome) {
        this(new BuildSettings(new File(grailsHome)));
    }

    public GrailsScriptRunner(BuildSettings settings) {
        this.settings = settings;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream outputStream) {
        this.out = outputStream;
        this.helper = new CommandLineHelper(this.out);
    }

    public int executeCommand(String scriptName, String args) {
        return this.executeCommand(scriptName, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String scriptName, String args, String env) {
        boolean useDefaultEnv;
        if (this.settings.getRootLoader() == null) {
            this.settings.setRootLoader((URLClassLoader)GrailsScriptRunner.class.getClassLoader());
        }
        boolean bl = useDefaultEnv = env == null;
        if (useDefaultEnv) {
            env = DEFAULT_ENVS.get(scriptName);
            env = env != null ? env : Environment.DEVELOPMENT.getName();
        }
        System.setProperty("base.dir", this.settings.getBaseDir().getPath());
        System.setProperty(Environment.KEY, env);
        System.setProperty("grails.env.default", "true");
        if (args != null) {
            String[] argArray = args.split("\\s+");
            Pattern pattern = Pattern.compile("^(?:-)?-non-interactive$");
            for (String arg : argArray) {
                if (!pattern.matcher(arg).matches()) continue;
                this.isInteractive = false;
                break;
            }
            System.setProperty("grails.cli.args", args.replace(' ', '\n'));
        } else {
            System.setProperty("grails.cli.args", "");
        }
        try {
            System.setProperty("disable.grails.plugin.transform", "true");
            this.settings.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("WARNING: There was an error loading the BuildConfig: " + e.getMessage());
            System.exit(1);
        }
        finally {
            System.setProperty("disable.grails.plugin.transform", "false");
        }
        this.settings.setGrailsEnv(env);
        this.settings.setDefaultEnv(useDefaultEnv);
        BuildSettingsHolder.setSettings(this.settings);
        if (scriptName.equalsIgnoreCase("interactive")) {
            if (!this.isInteractive) {
                this.out.println("You cannot use '--non-interactive' with interactive mode.");
                return 1;
            }
            this.runInteractive();
            return 0;
        }
        return this.callPluginOrGrailsScript(scriptName);
    }

    private void runInteractive() {
        String message = "Interactive mode ready. Enter a Grails command or type \"exit\" to quit interactive mode (hit ENTER to run the last command):\n";
        System.setProperty("grails.disable.exit", "true");
        System.setProperty("grails.interactive.mode", "true");
        ScriptAndArgs script = new ScriptAndArgs();
        while (true) {
            System.clearProperty("grails.env.set");
            System.clearProperty(Environment.KEY);
            this.out.println("--------------------------------------------------------");
            String enteredName = this.helper.userInput(message);
            if (enteredName != null && enteredName.trim().length() > 0) {
                script = GrailsScriptRunner.processArgumentsAndReturnScriptName(enteredName);
                if (script.args != null) {
                    System.setProperty("grails.cli.args", script.args);
                } else {
                    System.setProperty("grails.cli.args", "");
                }
                if (script.env != null) {
                    this.settings.setGrailsEnv(script.env);
                    this.settings.setDefaultEnv(false);
                } else {
                    String defaultEnv = DEFAULT_ENVS.get(script.name);
                    if (defaultEnv == null) {
                        defaultEnv = Environment.DEVELOPMENT.getName();
                    }
                    this.settings.setGrailsEnv(defaultEnv);
                    this.settings.setDefaultEnv(true);
                }
            }
            if (script.name == null) {
                this.out.println("You must enter a command.\n");
                continue;
            }
            if (script.name.equalsIgnoreCase("exit") || script.name.equalsIgnoreCase("quit")) {
                return;
            }
            long now = System.currentTimeMillis();
            try {
                this.callPluginOrGrailsScript(script.name);
            }
            catch (ScriptNotFoundException ex) {
                this.out.println("No script found for " + script.name);
            }
            catch (Throwable ex) {
                if (ex.getCause() instanceof ScriptExitException) {
                    this.out.println("Script exited with code " + ((ScriptExitException)ex.getCause()).getExitCode());
                }
                this.out.println("Script threw exception");
                ex.printStackTrace(this.out);
            }
            long end = System.currentTimeMillis();
            this.out.println("--------------------------------------------------------");
            this.out.println("Command " + script.name + " completed in " + (end - now) + "ms");
        }
    }

    private int callPluginOrGrailsScript(String scriptName) {
        Gant gant;
        Closure doNothingClosure;
        block24: {
            GantBinding binding;
            List<File> potentialScripts;
            URLClassLoader classLoader;
            File scriptCacheDir = new File(this.settings.getGrailsWorkDir(), "scriptCache");
            try {
                HashSet<String> existingJars = new HashSet<String>();
                for (URL url : this.settings.getRootLoader().getURLs()) {
                    existingJars.add(url.getFile());
                }
                boolean skipPlugins = "UninstallPlugin".equals(scriptName) || "InstallPlugin".equals(scriptName);
                URL[] urls = GrailsScriptRunner.getClassLoaderUrls(this.settings, scriptCacheDir, existingJars, skipPlugins);
                GrailsScriptRunner.addUrlsToRootLoader(this.settings.getRootLoader(), urls);
                urls = new URL[]{this.settings.getClassesDir().toURI().toURL()};
                classLoader = new URLClassLoader(urls, (ClassLoader)this.settings.getRootLoader());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Invalid classpath URL", ex);
            }
            if (this.scriptCache.get(scriptName) != null) {
                CachedScript cachedScript = this.scriptCache.get(scriptName);
                potentialScripts = cachedScript.potentialScripts;
                binding = cachedScript.binding;
            } else {
                binding = new GantBinding();
                AntBuilder antBuilder = (AntBuilder)binding.getVariable("ant");
                Project p = antBuilder.getAntProject();
                try {
                    p.setDefaultInputStream(System.in);
                }
                catch (NoSuchMethodError nsme) {
                    for (Method m : p.getClass().getMethods()) {
                        if (!"setDefaultInputStream".equals(m.getName()) || m.getParameterTypes().length != 1 || !InputStream.class.equals(m.getParameterTypes()[0])) continue;
                        try {
                            m.invoke((Object)p, System.in);
                            break;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                List<File> list = GrailsScriptRunner.getAvailableScripts(this.settings);
                potentialScripts = new ArrayList();
                for (File scriptPath : list) {
                    String scriptFileName = scriptPath.getName().substring(0, scriptPath.getName().length() - 7);
                    if (scriptFileName.endsWith("_")) {
                        this.scriptsAllowedOutsideOfProject.add(scriptPath);
                        scriptFileName = scriptFileName.substring(0, scriptFileName.length() - 1);
                    }
                    if (!scriptFileName.equals(scriptName)) continue;
                    potentialScripts.add(scriptPath);
                }
                if (!potentialScripts.isEmpty()) {
                    CachedScript cachedScript = new CachedScript();
                    cachedScript.binding = binding;
                    cachedScript.potentialScripts = potentialScripts;
                    this.scriptCache.put("scriptName", cachedScript);
                }
            }
            this.initBinding((Binding)binding);
            doNothingClosure = new Closure(this){
                private static final long serialVersionUID = 1L;

                public Object call(Object arguments) {
                    return null;
                }

                public Object call() {
                    return null;
                }

                public Object call(Object[] args) {
                    return null;
                }
            };
            binding.setVariable("scriptName", (Object)scriptName);
            if (potentialScripts.size() > 0) {
                if ((potentialScripts = (List)DefaultGroovyMethods.unique(potentialScripts)).size() == 1) {
                    File scriptFile = (File)potentialScripts.get(0);
                    if (!this.isGrailsProject() && !this.isExternalScript(scriptFile)) {
                        this.out.println(this.settings.getBaseDir().getPath() + " does not appear to be part of a Grails application.");
                        this.out.println("The following commands are supported outside of a project:");
                        Collections.sort(this.scriptsAllowedOutsideOfProject);
                        for (File file : this.scriptsAllowedOutsideOfProject) {
                            this.out.println("\t" + GrailsNameUtils.getScriptName(file.getName()));
                        }
                        this.out.println("Run 'grails help' for a complete list of available scripts.");
                        return -1;
                    }
                    this.out.println("Running script " + scriptFile.getAbsolutePath());
                    Gant gant2 = new Gant(binding, (ClassLoader)classLoader);
                    gant2.setUseCache(true);
                    gant2.setCacheDirectory(scriptCacheDir);
                    gant2.loadScript(scriptFile);
                    return this.executeWithGantInstance(gant2, doNothingClosure);
                }
                if (!this.isInteractive) {
                    this.out.println("More than one script with the given name is available - cannot continue in non-interactive mode.");
                    return 1;
                }
                this.out.println("Multiple options please select:");
                String[] validArgs = new String[potentialScripts.size()];
                for (int i = 0; i < validArgs.length; ++i) {
                    this.out.println("[" + (i + 1) + "] " + potentialScripts.get(i));
                    validArgs[i] = String.valueOf(i + 1);
                }
                String enteredValue = this.helper.userInput("Enter #", validArgs);
                if (enteredValue == null) {
                    return 1;
                }
                int number = Integer.parseInt(enteredValue);
                this.out.println("Running script " + ((File)potentialScripts.get(number - 1)).getAbsolutePath());
                Gant gant3 = new Gant(binding, (ClassLoader)classLoader);
                gant3.loadScript((File)potentialScripts.get(number - 1));
                return this.executeWithGantInstance(gant3, doNothingClosure);
            }
            this.out.println("Running pre-compiled script");
            gant = new Gant(binding, (ClassLoader)classLoader);
            try {
                gant.loadScriptClass(scriptName + "_");
            }
            catch (Exception e) {
                try {
                    gant.loadScriptClass(scriptName);
                }
                catch (Exception ex) {
                    if (!(ex instanceof ClassNotFoundException) || ex.getMessage() == null || !ex.getMessage().contains(scriptName)) break block24;
                    throw new ScriptNotFoundException(scriptName);
                }
            }
        }
        return this.executeWithGantInstance(gant, doNothingClosure);
    }

    private int executeWithGantInstance(Gant gant, Closure doNothingClosure) {
        gant.prepareTargets();
        gant.setAllPerTargetPostHooks(doNothingClosure);
        gant.setAllPerTargetPreHooks(doNothingClosure);
        return gant.executeTargets();
    }

    private boolean isGrailsProject() {
        return new File(this.settings.getBaseDir(), "grails-app").exists();
    }

    private boolean isExternalScript(File scriptFile) {
        return this.scriptsAllowedOutsideOfProject.contains(scriptFile);
    }

    private void initBinding(Binding binding) {
        Closure c = this.settings.getGrailsScriptClosure();
        c.setDelegate((Object)binding);
        binding.setVariable("grailsScript", (Object)c);
        binding.setVariable("grailsSettings", (Object)this.settings);
        File basedir = this.settings.getBaseDir();
        String baseDirPath = basedir.getPath();
        binding.setVariable("basedir", (Object)baseDirPath);
        binding.setVariable("scaffoldDir", (Object)(baseDirPath + "/web-app/WEB-INF/templates/scaffolding"));
        binding.setVariable("baseFile", (Object)basedir);
        binding.setVariable("baseName", (Object)basedir.getName());
        binding.setVariable("grailsHome", this.settings.getGrailsHome() != null ? this.settings.getGrailsHome().getPath() : null);
        binding.setVariable("grailsVersion", (Object)this.settings.getGrailsVersion());
        binding.setVariable("userHome", (Object)this.settings.getUserHome());
        binding.setVariable("grailsEnv", (Object)this.settings.getGrailsEnv());
        binding.setVariable("defaultEnv", (Object)this.settings.getDefaultEnv());
        binding.setVariable("buildConfig", (Object)this.settings.getConfig());
        binding.setVariable("rootLoader", (Object)this.settings.getRootLoader());
        binding.setVariable("configFile", (Object)new File(baseDirPath + "/grails-app/conf/Config.groovy"));
        String grailsWork = this.settings.getGrailsWorkDir().getPath();
        binding.setVariable("grailsWorkDir", (Object)grailsWork);
        binding.setVariable("projectWorkDir", (Object)this.settings.getProjectWorkDir().getPath());
        binding.setVariable("projectTargetDir", (Object)this.settings.getProjectTargetDir());
        binding.setVariable("classesDir", (Object)this.settings.getClassesDir());
        binding.setVariable("pluginClassesDir", (Object)this.settings.getPluginClassesDir());
        binding.setVariable("grailsTmp", (Object)(grailsWork + "/tmp"));
        binding.setVariable("classesDirPath", (Object)this.settings.getClassesDir().getPath());
        binding.setVariable("pluginClassesDirPath", (Object)this.settings.getPluginClassesDir().getPath());
        binding.setVariable("testDirPath", (Object)this.settings.getTestClassesDir().getPath());
        String resourcesDir = this.settings.getResourcesDir().getPath();
        binding.setVariable("resourcesDirPath", (Object)resourcesDir);
        binding.setVariable("webXmlFile", (Object)this.settings.getWebXmlLocation());
        binding.setVariable("pluginsDirPath", (Object)this.settings.getProjectPluginsDir().getPath());
        binding.setVariable("globalPluginsDirPath", (Object)this.settings.getGlobalPluginsDir().getPath());
        binding.setVariable("Ant", binding.getVariable("ant"));
        try {
            ArrayList<File> descriptors = new ArrayList<File>();
            File desc = GrailsScriptRunner.getPluginDescriptor(basedir);
            if (desc != null) {
                descriptors.add(desc);
            }
            for (File dir : GrailsScriptRunner.listKnownPluginDirs(this.settings)) {
                File pluginDescriptor = GrailsScriptRunner.getPluginDescriptor(dir);
                if (pluginDescriptor == null) continue;
                descriptors.add(pluginDescriptor);
            }
            for (File file : descriptors) {
                Matcher matcher = pluginDescriptorPattern.matcher(file.getName());
                matcher.find();
                String pluginName = GrailsNameUtils.getPropertyName(matcher.group(1));
                binding.setVariable(pluginName + "PluginDir", (Object)file.getParentFile());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static List<File> getAvailableScripts(BuildSettings settings) {
        ArrayList<File> scripts = new ArrayList<File>();
        if (settings.getGrailsHome() != null) {
            GrailsScriptRunner.addCommandScripts(new File(settings.getGrailsHome(), "scripts"), scripts);
        }
        GrailsScriptRunner.addCommandScripts(new File(settings.getBaseDir(), "scripts"), scripts);
        GrailsScriptRunner.addCommandScripts(new File(settings.getUserHome(), ".grails/scripts"), scripts);
        for (File dir : GrailsScriptRunner.listKnownPluginDirs(settings)) {
            GrailsScriptRunner.addPluginScripts(dir, scripts);
        }
        return scripts;
    }

    private static void addPluginScripts(File pluginDir, List<File> scripts) {
        if (!pluginDir.exists()) {
            return;
        }
        File scriptDir = new File(pluginDir, "scripts");
        if (scriptDir.exists()) {
            GrailsScriptRunner.addCommandScripts(scriptDir, scripts);
        }
    }

    private static void addCommandScripts(File dir, List<File> scripts) {
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                if (!scriptFilePattern.matcher(file.getName()).matches()) continue;
                scripts.add(file);
            }
        }
    }

    private static URL[] getClassLoaderUrls(BuildSettings settings, File cacheDir, Set<String> excludes, boolean skipPlugins) throws MalformedURLException {
        boolean dependenciesExternallyConfigured;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (settings.getGrailsHome() != null) {
            urls.add(cacheDir.toURI().toURL());
        }
        if (settings.getResourcesDir() != null && settings.getResourcesDir().exists()) {
            urls.add(settings.getResourcesDir().toURI().toURL());
        }
        if (!(dependenciesExternallyConfigured = settings.isDependenciesExternallyConfigured())) {
            System.out.println("Resolving dependencies...");
        }
        long now = System.currentTimeMillis();
        List<File> buildDependencies = settings.getBuildDependencies();
        if (!dependenciesExternallyConfigured && buildDependencies.isEmpty()) {
            GrailsScriptRunner.exitWithError("Required Grails build dependencies were not found. Either GRAILS_HOME is not set or your dependencies are misconfigured in grails-app/conf/BuildConfig.groovy");
        }
        GrailsScriptRunner.addDependenciesToURLs(excludes, urls, buildDependencies);
        GrailsScriptRunner.addDependenciesToURLs(excludes, urls, settings.getProvidedDependencies());
        GrailsScriptRunner.addDependenciesToURLs(excludes, urls, settings.getTestDependencies());
        if (!dependenciesExternallyConfigured) {
            System.out.println("Dependencies resolved in " + (System.currentTimeMillis() - now) + "ms.");
        }
        if (!skipPlugins) {
            for (File dir : GrailsScriptRunner.listKnownPluginDirs(settings)) {
                GrailsScriptRunner.addPluginLibs(dir, urls, settings);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addDependenciesToURLs(Set<String> excludes, List<URL> urls, List<File> runtimeDeps) throws MalformedURLException {
        if (runtimeDeps == null) {
            return;
        }
        for (File file : runtimeDeps) {
            if (file == null || urls.contains(file) || excludes == null || excludes.contains(file.getName())) continue;
            urls.add(file.toURI().toURL());
            excludes.add(file.getName());
        }
    }

    private static List<File> listKnownPluginDirs(BuildSettings settings) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.addAll(Arrays.asList(GrailsScriptRunner.listPluginDirs(settings.getGlobalPluginsDir())));
        dirs.addAll(Arrays.asList(GrailsScriptRunner.listPluginDirs(settings.getProjectPluginsDir())));
        Map buildConfig = settings.getConfig().flatten();
        for (Map.Entry entry : buildConfig.entrySet()) {
            if (!((String)entry.getKey()).startsWith("grails.plugin.location.")) continue;
            dirs.add(new File(entry.getValue().toString()));
        }
        return dirs;
    }

    private static void addPluginLibs(File pluginDir, List<URL> urls, BuildSettings settings) throws MalformedURLException {
        if (!pluginDir.exists()) {
            return;
        }
        File libDir = new File(pluginDir, "lib");
        if (libDir.exists()) {
            String pluginName;
            IvyDependencyManager dependencyManager = settings.getDependencyManager();
            Set<String> excludes = dependencyManager.getPluginExcludes(pluginName = GrailsScriptRunner.getPluginName(pluginDir));
            GrailsScriptRunner.addLibs(libDir, urls, excludes != null ? excludes : Collections.emptyList());
        }
    }

    private static void addLibs(File dir, List<URL> urls, Collection<?> excludes) throws MalformedURLException {
        if (!dir.exists()) {
            return;
        }
        for (File file : dir.listFiles()) {
            boolean include = true;
            for (Object me : excludes) {
                String exclude = me.toString();
                if (!file.getName().contains(exclude)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            urls.add(file.toURI().toURL());
        }
    }

    private static File[] listPluginDirs(File dir) {
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isDirectory() && !path.getName().startsWith(".") && path.getName().indexOf(45) > -1;
            }
        });
        return dirs == null ? new File[]{} : dirs;
    }

    private static File getPluginDescriptor(File dir) {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return s.endsWith("GrailsPlugin.groovy");
            }
        });
        return files.length > 0 ? files[0] : null;
    }

    private static void sanitizeStacktrace(Throwable t) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass("grails.util.GrailsUtil");
            Method method = clazz.getMethod("deepSanitize", Throwable.class);
            method.invoke(null, t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void addUrlsToRootLoader(URLClassLoader loader, URL[] urls) {
        try {
            Class<?> loaderClass = loader.getClass();
            Method method = loaderClass.getMethod("addURL", URL.class);
            for (URL url : urls) {
                method.invoke((Object)loader, url);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot dynamically add URLs to GrailsScriptRunner's class loader - make sure that it is loaded by Groovy's RootLoader or a sub-class.");
        }
    }

    private static String getPluginName(File pluginDir) {
        File desc = GrailsScriptRunner.getPluginDescriptor(pluginDir);
        if (desc == null) {
            throw new RuntimeException("Cannot find plugin descriptor in plugin directory '" + pluginDir + "'.");
        }
        return GrailsNameUtils.getPluginName(desc.getName());
    }

    static {
        ENV_ARGS.put("dev", Environment.DEVELOPMENT.getName());
        ENV_ARGS.put("prod", Environment.PRODUCTION.getName());
        ENV_ARGS.put("test", Environment.TEST.getName());
        DEFAULT_ENVS.put("War", Environment.PRODUCTION.getName());
        DEFAULT_ENVS.put("TestApp", Environment.TEST.getName());
        DEFAULT_ENVS.put("RunWebtest", Environment.TEST.getName());
        ExpandoMetaClass.enableGlobally();
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        scriptFilePattern = Pattern.compile("^[^_]\\w+\\.groovy$");
        pluginDescriptorPattern = Pattern.compile("^(\\S+)GrailsPlugin.groovy$");
    }

    private static class ScriptAndArgs {
        public String name;
        public String env;
        public String args;

        private ScriptAndArgs() {
        }
    }
}

