/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli;

import gant.Gant;
import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.gant.GantBinding;
import org.codehaus.groovy.grails.cli.CachedScript;
import org.codehaus.groovy.grails.cli.ScriptNotFoundException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsScriptRunner {
    private static Map ENV_ARGS = new HashMap();
    private static Map DEFAULT_ENVS = new HashMap();
    private static final Pattern scriptFilePattern;
    private static final Pattern pluginDescriptorPattern;
    private BuildSettings settings;
    private PrintStream out = System.out;
    private boolean isInteractive = true;
    private final Map scriptCache = new HashMap();
    private final List scriptsAllowedOutsideOfProject = new ArrayList();

    public static void main(String[] args) throws MalformedURLException {
        String allArgs = args.length > 0 ? args[0].trim() : "";
        ScriptAndArgs script = GrailsScriptRunner.processArgumentsAndReturnScriptName(allArgs);
        String grailsHome = System.getProperty("grails.home");
        BuildSettings build = new BuildSettings(new File(grailsHome));
        File grailsHomeInSettings = build.getGrailsHome();
        if (grailsHomeInSettings == null || !grailsHomeInSettings.exists()) {
            GrailsScriptRunner.exitWithError("Grails' installation directory not found: " + build.getGrailsHome());
        }
        System.out.println("Welcome to Grails " + build.getGrailsVersion() + " - http://grails.org/" + '\n' + "Licensed under Apache Standard License 2.0" + '\n' + "Grails home is " + (grailsHome == null ? "not set" : "set to: " + grailsHome) + '\n');
        if (script.name == null) {
            System.out.println("No script name specified. Use 'grails help' for more info or 'grails interactive' to enter interactive mode");
            System.exit(0);
        }
        System.out.println("Base Directory: " + build.getBaseDir().getPath());
        try {
            GrailsScriptRunner runner = new GrailsScriptRunner(build);
            int exitCode = runner.executeCommand(script.name, script.args, script.env);
            System.exit(exitCode);
        }
        catch (ScriptNotFoundException ex) {
            System.out.println("Script not found: " + ex.getScriptName());
        }
        catch (Throwable t) {
            String msg = "Error executing script " + script.name + ": " + t.getMessage();
            System.out.println(msg);
            GrailsScriptRunner.sanitizeStacktrace(t);
            t.printStackTrace(System.out);
            System.out.println(msg);
            System.exit(1);
        }
    }

    private static void exitWithError(String error) {
        System.out.println(error);
        System.exit(1);
    }

    private static ScriptAndArgs processArgumentsAndReturnScriptName(String allArgs) {
        String paramName;
        ScriptAndArgs info = new ScriptAndArgs();
        if (allArgs == null || allArgs.length() == 0) {
            return info;
        }
        String[] splitArgs = GrailsScriptRunner.processSystemArguments(allArgs).trim().split(" ");
        int currentParamIndex = 0;
        if (Environment.isSystemSet()) {
            info.env = Environment.getCurrent().getName();
        } else if (GrailsScriptRunner.isEnvironmentArgs(splitArgs[currentParamIndex])) {
            String env = splitArgs[currentParamIndex++];
            info.env = (String)ENV_ARGS.get(env);
        }
        if (currentParamIndex >= splitArgs.length) {
            System.out.println("You should specify a script to run. Run 'grails help' for a complete list of available scripts.");
            System.exit(0);
        }
        if ((paramName = splitArgs[currentParamIndex++]).charAt(0) == '-') {
            paramName = paramName.substring(1);
        }
        info.name = GrailsNameUtils.getNameFromScript(paramName);
        if (currentParamIndex < splitArgs.length) {
            StringBuilder b = new StringBuilder(splitArgs[currentParamIndex]);
            for (int i = currentParamIndex + 1; i < splitArgs.length; ++i) {
                b.append(' ').append(splitArgs[i]);
            }
            info.args = b.toString();
        }
        return info;
    }

    private static String processSystemArguments(String allArgs) {
        String lastMatch = null;
        Pattern sysPropPattern = Pattern.compile("-D(.+?)=(.+?)\\s+?");
        Matcher m = sysPropPattern.matcher(allArgs);
        while (m.find()) {
            System.setProperty(m.group(1).trim(), m.group(2).trim());
            lastMatch = m.group();
        }
        if (lastMatch != null) {
            int i = allArgs.lastIndexOf(lastMatch) + lastMatch.length();
            allArgs = allArgs.substring(i);
        }
        return allArgs;
    }

    private static boolean isEnvironmentArgs(String env) {
        return ENV_ARGS.containsKey(env);
    }

    public GrailsScriptRunner() {
        this(new BuildSettings());
    }

    public GrailsScriptRunner(String grailsHome) {
        this(new BuildSettings(new File(grailsHome)));
    }

    public GrailsScriptRunner(BuildSettings settings) {
        this.settings = settings;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream outputStream) {
        this.out = outputStream;
    }

    public int executeCommand(String scriptName, String args) {
        return this.executeCommand(scriptName, args, null);
    }

    public int executeCommand(String scriptName, String args, String env) {
        boolean useDefaultEnv;
        if (this.settings.getRootLoader() == null) {
            this.settings.setRootLoader((URLClassLoader)GrailsScriptRunner.class.getClassLoader());
        }
        boolean bl = useDefaultEnv = env == null;
        if (useDefaultEnv) {
            env = (String)DEFAULT_ENVS.get(scriptName);
            env = env != null ? env : Environment.DEVELOPMENT.getName();
        }
        System.setProperty("base.dir", this.settings.getBaseDir().getPath());
        System.setProperty(Environment.KEY, env);
        System.setProperty("grails.env.default", "true");
        if (args != null) {
            String[] argArray = args.split("\\s+");
            Pattern pattern = Pattern.compile("^(?:-)?-non-interactive$");
            for (String arg : argArray) {
                if (!pattern.matcher(arg).matches()) continue;
                this.isInteractive = false;
                break;
            }
            System.setProperty("grails.cli.args", args.replace(' ', '\n'));
        } else {
            System.setProperty("grails.cli.args", "");
        }
        try {
            this.settings.loadConfig();
        }
        catch (Exception e) {
            System.err.println("WARNING: There was an error loading the BuildConfig: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        this.settings.setGrailsEnv(env);
        this.settings.setDefaultEnv(useDefaultEnv);
        BuildSettingsHolder.setSettings(this.settings);
        if (scriptName.equalsIgnoreCase("interactive")) {
            if (!this.isInteractive) {
                this.out.println("You cannot use '--non-interactive' with interactive mode.");
                return 1;
            }
            this.runInteractive();
            return 0;
        }
        return this.callPluginOrGrailsScript(scriptName);
    }

    private void runInteractive() {
        String message = "Interactive mode ready, type your command name in to continue (hit ENTER to run the last command):\n";
        System.setProperty("grails.interactive.mode", "true");
        boolean messageNumber = false;
        ScriptAndArgs script = new ScriptAndArgs();
        while (true) {
            this.out.println("--------------------------------------------------------");
            String enteredName = this.userInput(message);
            if (enteredName != null && enteredName.trim().length() > 0) {
                script = GrailsScriptRunner.processArgumentsAndReturnScriptName(enteredName);
            }
            if (script.name == null) {
                this.out.println("You must enter a command.\n");
                continue;
            }
            long now = System.currentTimeMillis();
            this.callPluginOrGrailsScript(script.name);
            long end = System.currentTimeMillis();
            this.out.println("--------------------------------------------------------");
            this.out.println("Command [" + script.name + " completed in " + (end - now) + "ms");
        }
    }

    private int callPluginOrGrailsScript(String scriptName) {
        Gant gant;
        block19: {
            GantBinding binding;
            List<File> potentialScripts;
            URLClassLoader classLoader;
            File scriptCacheDir = new File(this.settings.getGrailsWorkDir(), "scriptCache");
            try {
                HashSet<String> existingJars = new HashSet<String>();
                for (URL url : this.settings.getRootLoader().getURLs()) {
                    existingJars.add(url.getFile());
                }
                boolean skipPlugins = "UninstallPlugin".equals(scriptName) || "InstallPlugin".equals(scriptName);
                URL[] urls = GrailsScriptRunner.getClassLoaderUrls(this.settings, scriptCacheDir, existingJars, skipPlugins);
                GrailsScriptRunner.addUrlsToRootLoader(this.settings.getRootLoader(), urls);
                urls = new URL[]{this.settings.getClassesDir().toURI().toURL()};
                classLoader = new URLClassLoader(urls, (ClassLoader)this.settings.getRootLoader());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Invalid classpath URL", ex);
            }
            if (this.scriptCache.get(scriptName) != null) {
                CachedScript cachedScript = (CachedScript)this.scriptCache.get(scriptName);
                potentialScripts = cachedScript.potentialScripts;
                binding = cachedScript.binding;
            } else {
                binding = new GantBinding();
                List list = GrailsScriptRunner.getAvailableScripts(this.settings);
                potentialScripts = new ArrayList();
                for (File scriptPath : list) {
                    String scriptFileName = scriptPath.getName().substring(0, scriptPath.getName().length() - 7);
                    if (scriptFileName.endsWith("_")) {
                        this.scriptsAllowedOutsideOfProject.add(scriptPath);
                        scriptFileName = scriptFileName.substring(0, scriptFileName.length() - 1);
                    }
                    if (!scriptFileName.equals(scriptName)) continue;
                    potentialScripts.add(scriptPath);
                }
                if (!potentialScripts.isEmpty()) {
                    CachedScript cachedScript = new CachedScript();
                    cachedScript.binding = binding;
                    cachedScript.potentialScripts = potentialScripts;
                    this.scriptCache.put("scriptName", cachedScript);
                }
            }
            this.initBinding((Binding)binding);
            if (potentialScripts.size() > 0) {
                if ((potentialScripts = (List)DefaultGroovyMethods.unique(potentialScripts)).size() == 1) {
                    File scriptFile = (File)potentialScripts.get(0);
                    if (!this.isGrailsProject() && !this.isExternalScript(scriptFile)) {
                        this.out.println(this.settings.getBaseDir().getPath() + " does not appear to be part of a Grails application.");
                        this.out.println("The following commands are supported outside of a project:");
                        Collections.sort(this.scriptsAllowedOutsideOfProject);
                        for (File file : this.scriptsAllowedOutsideOfProject) {
                            this.out.println("\t" + GrailsNameUtils.getScriptName(file.getName()));
                        }
                        this.out.println("Run 'grails help' for a complete list of available scripts.");
                        return -1;
                    }
                    this.out.println("Running script " + scriptFile.getAbsolutePath());
                    Gant gant2 = new Gant(binding, (ClassLoader)classLoader);
                    gant2.setUseCache(true);
                    gant2.setCacheDirectory(scriptCacheDir);
                    gant2.loadScript(scriptFile);
                    return gant2.processTargets();
                }
                if (!this.isInteractive) {
                    this.out.println("More than one script with the given name is available - cannot continue in non-interactive mode.");
                    return 1;
                }
                this.out.println("Multiple options please select:");
                String[] validArgs = new String[potentialScripts.size()];
                for (int i = 0; i < validArgs.length; ++i) {
                    this.out.println("[" + (i + 1) + "] " + potentialScripts.get(i));
                    validArgs[i] = String.valueOf(i + 1);
                }
                String enteredValue = this.userInput("Enter #", validArgs);
                if (enteredValue == null) {
                    return 1;
                }
                int number = Integer.valueOf(enteredValue);
                this.out.println("Running script " + ((File)potentialScripts.get(number - 1)).getAbsolutePath());
                Gant gant3 = new Gant(binding, (ClassLoader)classLoader);
                gant3.loadScript((File)potentialScripts.get(number - 1));
                return gant3.processTargets();
            }
            this.out.println("Running pre-compiled script");
            gant = new Gant(binding, (ClassLoader)classLoader);
            try {
                gant.loadScriptClass(scriptName + "_");
            }
            catch (Exception e) {
                try {
                    gant.loadScriptClass(scriptName);
                }
                catch (Exception ex) {
                    if (!(ex instanceof ClassNotFoundException) || ex.getMessage() == null || !ex.getMessage().contains(scriptName)) break block19;
                    throw new ScriptNotFoundException(scriptName);
                }
            }
        }
        return gant.processTargets();
    }

    private boolean isGrailsProject() {
        return new File(this.settings.getBaseDir(), "grails-app").exists();
    }

    private boolean isExternalScript(File scriptFile) {
        return this.scriptsAllowedOutsideOfProject.contains(scriptFile);
    }

    private void initBinding(Binding binding) {
        Closure c = this.settings.getGrailsScriptClosure();
        c.setDelegate((Object)binding);
        binding.setVariable("grailsScript", (Object)c);
        binding.setVariable("grailsSettings", (Object)this.settings);
        File basedir = this.settings.getBaseDir();
        String baseDirPath = basedir.getPath();
        binding.setVariable("basedir", (Object)baseDirPath);
        binding.setVariable("scaffoldDir", (Object)(baseDirPath + "/web-app/WEB-INF/templates/scaffolding"));
        binding.setVariable("baseFile", (Object)basedir);
        binding.setVariable("baseName", (Object)basedir.getName());
        binding.setVariable("grailsHome", this.settings.getGrailsHome() != null ? this.settings.getGrailsHome().getPath() : null);
        binding.setVariable("grailsVersion", (Object)this.settings.getGrailsVersion());
        binding.setVariable("userHome", (Object)this.settings.getUserHome());
        binding.setVariable("grailsEnv", (Object)this.settings.getGrailsEnv());
        binding.setVariable("defaultEnv", (Object)this.settings.getDefaultEnv());
        binding.setVariable("buildConfig", (Object)this.settings.getConfig());
        binding.setVariable("rootLoader", (Object)this.settings.getRootLoader());
        binding.setVariable("configFile", (Object)new File(baseDirPath + "/grails-app/conf/Config.groovy"));
        String grailsWork = this.settings.getGrailsWorkDir().getPath();
        binding.setVariable("grailsWorkDir", (Object)grailsWork);
        binding.setVariable("projectWorkDir", (Object)this.settings.getProjectWorkDir().getPath());
        binding.setVariable("projectTargetDir", (Object)this.settings.getProjectTargetDir());
        binding.setVariable("classesDir", (Object)this.settings.getClassesDir());
        binding.setVariable("grailsTmp", (Object)(grailsWork + "/tmp"));
        binding.setVariable("classesDirPath", (Object)this.settings.getClassesDir().getPath());
        binding.setVariable("testDirPath", (Object)this.settings.getTestClassesDir().getPath());
        String resourcesDir = this.settings.getResourcesDir().getPath();
        binding.setVariable("resourcesDirPath", (Object)resourcesDir);
        binding.setVariable("webXmlFile", (Object)this.settings.getWebXmlLocation());
        binding.setVariable("pluginsDirPath", (Object)this.settings.getProjectPluginsDir().getPath());
        binding.setVariable("globalPluginsDirPath", (Object)this.settings.getGlobalPluginsDir().getPath());
        binding.setVariable("Ant", binding.getVariable("ant"));
        try {
            ArrayList<File> descriptors = new ArrayList<File>();
            File desc = GrailsScriptRunner.getPluginDescriptor(basedir);
            if (desc != null) {
                descriptors.add(desc);
            }
            for (File dir : GrailsScriptRunner.listKnownPluginDirs(this.settings)) {
                File pluginDescriptor = GrailsScriptRunner.getPluginDescriptor(dir);
                if (pluginDescriptor == null) continue;
                descriptors.add(pluginDescriptor);
            }
            int n = descriptors.size();
            for (int i = 0; i < n; ++i) {
                desc = (File)descriptors.get(i);
                Matcher matcher = pluginDescriptorPattern.matcher(desc.getName());
                matcher.find();
                String pluginName = GrailsNameUtils.getPropertyName(matcher.group(1));
                binding.setVariable(pluginName + "PluginDir", (Object)desc.getParentFile());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static List getAvailableScripts(BuildSettings settings) {
        ArrayList scripts = new ArrayList();
        if (settings.getGrailsHome() != null) {
            GrailsScriptRunner.addCommandScripts(new File(settings.getGrailsHome(), "scripts"), scripts);
        }
        GrailsScriptRunner.addCommandScripts(new File(settings.getBaseDir(), "scripts"), scripts);
        GrailsScriptRunner.addCommandScripts(new File(settings.getUserHome(), ".grails/scripts"), scripts);
        for (File dir : GrailsScriptRunner.listKnownPluginDirs(settings)) {
            GrailsScriptRunner.addPluginScripts(dir, scripts);
        }
        return scripts;
    }

    private static void addPluginScripts(File pluginDir, List scripts) {
        if (!pluginDir.exists()) {
            return;
        }
        File scriptDir = new File(pluginDir, "scripts");
        if (scriptDir.exists()) {
            GrailsScriptRunner.addCommandScripts(scriptDir, scripts);
        }
    }

    private static void addCommandScripts(File dir, List scripts) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!scriptFilePattern.matcher(files[i].getName()).matches()) continue;
                scripts.add(files[i]);
            }
        }
    }

    private static URL[] getClassLoaderUrls(BuildSettings settings, File cacheDir, Set excludes, boolean skipPlugins) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (settings.getGrailsHome() != null) {
            urls.add(cacheDir.toURI().toURL());
        }
        if (settings.getResourcesDir() != null && settings.getResourcesDir().exists()) {
            urls.add(settings.getResourcesDir().toURI().toURL());
        }
        System.out.println("Resolving dependencies...");
        long now = System.currentTimeMillis();
        List<File> buildDependencies = settings.getBuildDependencies();
        if (!settings.isDependenciesExternallyConfigured() && buildDependencies.isEmpty()) {
            GrailsScriptRunner.exitWithError("Required Grails build dependencies were not found. Either GRAILS_HOME is not set or your dependencies are misconfigured in grails-app/conf/BuildConfig.groovy");
        }
        GrailsScriptRunner.addDependenciesToURLs(excludes, urls, buildDependencies);
        GrailsScriptRunner.addDependenciesToURLs(excludes, urls, settings.getProvidedDependencies());
        GrailsScriptRunner.addDependenciesToURLs(excludes, urls, settings.getTestDependencies());
        System.out.println("Dependencies resolved in " + (System.currentTimeMillis() - now) + "ms.");
        if (!skipPlugins) {
            for (File dir : GrailsScriptRunner.listKnownPluginDirs(settings)) {
                GrailsScriptRunner.addPluginLibs(dir, urls);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addDependenciesToURLs(Set excludes, List<URL> urls, List<File> runtimeDeps) throws MalformedURLException {
        if (runtimeDeps != null) {
            for (File file : runtimeDeps) {
                if (file == null || urls.contains(file) || excludes == null || excludes.contains(file.getName())) continue;
                urls.add(file.toURI().toURL());
                excludes.add(file.getName());
            }
        }
    }

    private static List<File> listKnownPluginDirs(BuildSettings settings) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.addAll(Arrays.asList(GrailsScriptRunner.listPluginDirs(settings.getGlobalPluginsDir())));
        dirs.addAll(Arrays.asList(GrailsScriptRunner.listPluginDirs(settings.getProjectPluginsDir())));
        Map buildConfig = settings.getConfig().flatten();
        for (Map.Entry entry : buildConfig.entrySet()) {
            if (!((String)entry.getKey()).startsWith("grails.plugin.location.")) continue;
            dirs.add(new File(entry.getValue().toString()));
        }
        return dirs;
    }

    private static void addPluginLibs(File pluginDir, List urls) throws MalformedURLException {
        if (!pluginDir.exists()) {
            return;
        }
        File dependencyDefinition = new File(pluginDir, "dependencies.groovy");
        if (dependencyDefinition.exists()) {
            return;
        }
        File libDir = new File(pluginDir, "lib");
        if (libDir.exists()) {
            GrailsScriptRunner.addLibs(libDir, urls, Collections.EMPTY_SET);
        }
    }

    private static void addLibs(File dir, List urls, Set excludes) throws MalformedURLException {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.getName().matches("^.*\\.jar$") || excludes.contains(file.getName()) || file.getName().matches("^(standard|jstl)-\\d.*$")) continue;
                urls.add(file.toURI().toURL());
            }
        }
    }

    private static File[] listPluginDirs(File dir) {
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isDirectory() && !path.getName().startsWith(".") && path.getName().indexOf(45) > -1;
            }
        });
        return dirs == null ? new File[]{} : dirs;
    }

    private static File getPluginDescriptor(File dir) {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return s.endsWith("GrailsPlugin.groovy");
            }
        });
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    private static void sanitizeStacktrace(Throwable t) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass("grails.util.GrailsUtil");
            Method method = clazz.getMethod("deepSanitize", Throwable.class);
            method.invoke(null, t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addUrlsToRootLoader(URLClassLoader loader, URL[] urls) {
        try {
            Class<?> loaderClass = loader.getClass();
            Method method = loaderClass.getMethod("addURL", URL.class);
            for (URL url : urls) {
                method.invoke((Object)loader, url);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot dynamically add URLs to GrailsScriptRunner's class loader - make sure that it is loaded by Groovy's RootLoader or a sub-class.");
        }
    }

    private String userInput(String message) {
        return this.userInput(message, null);
    }

    private String userInput(String message, String[] validResponses) {
        String responsesString = null;
        if (validResponses != null) {
            responsesString = DefaultGroovyMethods.join((Object[])validResponses, (String)",");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        for (int it = 0; it < 3; ++it) {
            this.out.print(message);
            if (responsesString != null) {
                this.out.print(" [");
                this.out.print(responsesString);
                this.out.print("] ");
            }
            try {
                String line = reader.readLine();
                if (validResponses == null) {
                    return line;
                }
                for (String validResponse : validResponses) {
                    if (line == null || !line.equals(validResponse)) continue;
                    return line;
                }
                this.out.println();
                this.out.println("Invalid option '" + line + "' - must be one of: [" + responsesString + "]");
                this.out.println();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        this.out.println("No valid response entered - giving up asking.");
        return null;
    }

    static {
        ENV_ARGS.put("dev", Environment.DEVELOPMENT.getName());
        ENV_ARGS.put("prod", Environment.PRODUCTION.getName());
        ENV_ARGS.put("test", Environment.TEST.getName());
        DEFAULT_ENVS.put("War", Environment.PRODUCTION.getName());
        DEFAULT_ENVS.put("TestApp", Environment.TEST.getName());
        DEFAULT_ENVS.put("RunWebtest", Environment.TEST.getName());
        ExpandoMetaClass.enableGlobally();
        scriptFilePattern = Pattern.compile("^[^_]\\w+\\.groovy$");
        pluginDescriptorPattern = Pattern.compile("^(\\S+)GrailsPlugin.groovy$");
    }

    private static class ScriptAndArgs {
        public String name;
        public String env;
        public String args;

        private ScriptAndArgs() {
        }
    }
}

