/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradlex.javamodule.moduleinfo.AutomaticModuleName;
import org.gradlex.javamodule.moduleinfo.FilePathToModuleCoordinates;
import org.gradlex.javamodule.moduleinfo.ModuleInfo;
import org.gradlex.javamodule.moduleinfo.ModuleNameUtil;
import org.gradlex.javamodule.moduleinfo.ModuleSpec;
import org.gradlex.javamodule.moduleinfo.PublishedMetadata;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

@CacheableRule
@NonNullApi
public abstract class ExtraJavaModuleInfoTransform
implements TransformAction<Parameter> {
    private static final Pattern MODULE_INFO_CLASS_MRJAR_PATH = Pattern.compile("META-INF/versions/\\d+/module-info.class");
    private static final Pattern MRJAR_VERSIONS_PATH = Pattern.compile("META-INF/versions/\\d+/(.*)/.*");
    private static final Pattern JAR_SIGNATURE_PATH = Pattern.compile("^META-INF/[^/]+\\.(SF|RSA|DSA|sf|rsa|dsa)$");
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();

    @InputArtifact
    protected abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        Parameter parameters = (Parameter)this.getParameters();
        Map moduleSpecs = (Map)parameters.getModuleSpecs().get();
        File originalJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        ModuleSpec moduleSpec = this.findModuleSpec(originalJar);
        if (this.willBeMerged(originalJar, moduleSpecs.values())) {
            return;
        }
        boolean realModule = this.isModule(originalJar);
        if (moduleSpec instanceof ModuleInfo) {
            if (realModule && !((ModuleInfo)moduleSpec).patchRealModule) {
                throw new RuntimeException("Patching of real modules must be explicitly enabled with 'patchRealModule()'");
            }
            String definedName = moduleSpec.getModuleName();
            String expectedName = this.autoModuleName(originalJar);
            if (expectedName != null && !definedName.equals(expectedName) && !moduleSpec.overrideModuleName) {
                throw new RuntimeException("The name '" + definedName + "' is different than the Automatic-Module-Name '" + expectedName + "'; explicitly allow override via 'overrideName()'");
            }
            this.addModuleDescriptor(originalJar, this.getModuleJar(outputs, originalJar), (ModuleInfo)moduleSpec);
        } else if (moduleSpec instanceof AutomaticModuleName) {
            if (realModule) {
                throw new RuntimeException("Patching of real modules must be explicitly enabled with 'patchRealModule()' and can only be done with 'module()'");
            }
            String definedName = moduleSpec.getModuleName();
            String expectedName = this.autoModuleName(originalJar);
            if (!(expectedName == null || !moduleSpec.getMergedJars().isEmpty() && definedName.equals(expectedName) || moduleSpec.overrideModuleName)) {
                throw new RuntimeException("'" + definedName + "' already has the Automatic-Module-Name '" + expectedName + "'; explicitly allow override via 'overrideName()'");
            }
            if (((Boolean)parameters.getFailOnAutomaticModules().get()).booleanValue()) {
                throw new RuntimeException("Use of 'automaticModule()' is prohibited. Use 'module()' instead: " + originalJar.getName());
            }
            this.addAutomaticModuleName(originalJar, this.getModuleJar(outputs, originalJar), (AutomaticModuleName)moduleSpec);
        } else if (realModule) {
            outputs.file((Object)originalJar);
        } else if (this.autoModuleName(originalJar) != null) {
            if (((Boolean)parameters.getFailOnAutomaticModules().get()).booleanValue()) {
                throw new RuntimeException("Found an automatic module: " + this.autoModuleName(originalJar) + " (" + originalJar.getName() + ")");
            }
            outputs.file((Object)originalJar);
        } else if (((Boolean)parameters.getDeriveAutomaticModuleNamesFromFileNames().get()).booleanValue()) {
            String automaticName = ModuleNameUtil.automaticModulNameFromFileName(originalJar);
            this.addAutomaticModuleName(originalJar, this.getModuleJar(outputs, originalJar), new AutomaticModuleName(originalJar.getName(), automaticName));
        } else {
            if (((Boolean)parameters.getFailOnMissingModuleInfo().get()).booleanValue()) {
                throw new RuntimeException("Not a module and no mapping defined: " + originalJar.getName());
            }
            outputs.file((Object)originalJar);
        }
    }

    @Nullable
    private ModuleSpec findModuleSpec(File originalJar) {
        Map moduleSpecs = (Map)((Parameter)this.getParameters()).getModuleSpecs().get();
        Optional<String> gaCoordinates = moduleSpecs.keySet().stream().filter(ga -> FilePathToModuleCoordinates.gaCoordinatesFromFilePathMatch(originalJar.toPath(), ga)).findFirst();
        if (gaCoordinates.isPresent()) {
            return (ModuleSpec)moduleSpecs.get(gaCoordinates.get());
        }
        String originalJarName = originalJar.getName();
        if (moduleSpecs.containsKey(originalJarName)) {
            return (ModuleSpec)moduleSpecs.get(originalJarName);
        }
        return null;
    }

    private boolean willBeMerged(File originalJar, Collection<ModuleSpec> modules) {
        return modules.stream().anyMatch(module -> module.getMergedJars().stream().anyMatch(toMerge -> FilePathToModuleCoordinates.gaCoordinatesFromFilePathMatch(originalJar.toPath(), toMerge) || toMerge.equals(originalJar.getName())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModule(File jar) {
        if (!jar.isFile()) {
            return true;
        }
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(jar.toPath(), new OpenOption[0]));){
            boolean isMultiReleaseJar = this.containsMultiReleaseJarEntry(inputStream);
            ZipEntry next = inputStream.getNextEntry();
            while (next != null) {
                if ("module-info.class".equals(next.getName())) {
                    boolean bl = true;
                    return bl;
                }
                if (isMultiReleaseJar && MODULE_INFO_CLASS_MRJAR_PATH.matcher(next.getName()).matches()) {
                    boolean bl = true;
                    return bl;
                }
                next = inputStream.getNextEntry();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsMultiReleaseJarEntry(JarInputStream jarStream) {
        Manifest manifest = jarStream.getManifest();
        return manifest != null && Boolean.parseBoolean(manifest.getMainAttributes().getValue("Multi-Release"));
    }

    @Nullable
    private String autoModuleName(File jar) {
        String string;
        JarInputStream inputStream = new JarInputStream(Files.newInputStream(jar.toPath(), new OpenOption[0]));
        try {
            Manifest manifest = inputStream.getManifest();
            string = manifest != null ? manifest.getMainAttributes().getValue("Automatic-Module-Name") : null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return string;
    }

    private File getModuleJar(TransformOutputs outputs, File originalJar) {
        return outputs.file((Object)(originalJar.getName().substring(0, originalJar.getName().lastIndexOf(46)) + "-module.jar"));
    }

    private void addAutomaticModuleName(File originalJar, File moduleJar, AutomaticModuleName automaticModule) {
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(originalJar.toPath(), new OpenOption[0]));){
            Manifest manifest = inputStream.getManifest();
            if (manifest == null) {
                manifest = new Manifest();
                manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
            }
            manifest.getMainAttributes().putValue("Automatic-Module-Name", automaticModule.getModuleName());
            try (JarOutputStream outputStream = this.newJarOutputStream(Files.newOutputStream(moduleJar.toPath(), new OpenOption[0]), manifest);){
                LinkedHashMap<String, List<String>> providers = new LinkedHashMap<String, List<String>>();
                TreeSet<String> packages = new TreeSet<String>();
                this.copyAndExtractProviders(inputStream, outputStream, !automaticModule.getMergedJars().isEmpty(), providers, packages);
                this.mergeJars(automaticModule, outputStream, providers, packages);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addModuleDescriptor(File originalJar, File moduleJar, ModuleInfo moduleInfo) {
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(originalJar.toPath(), new OpenOption[0]));
             JarOutputStream outputStream = this.newJarOutputStream(Files.newOutputStream(moduleJar.toPath(), new OpenOption[0]), inputStream.getManifest());){
            LinkedHashMap<String, List<String>> providers = new LinkedHashMap<String, List<String>>();
            TreeSet<String> packages = new TreeSet<String>();
            this.copyAndExtractProviders(inputStream, outputStream, !moduleInfo.getMergedJars().isEmpty(), providers, packages);
            this.mergeJars(moduleInfo, outputStream, providers, packages);
            outputStream.putNextEntry(this.newReproducibleEntry("module-info.class"));
            outputStream.write(this.addModuleInfo(moduleInfo, providers, FilePathToModuleCoordinates.versionFromFilePath(originalJar.toPath()), moduleInfo.exportAllPackages ? packages : Collections.emptySet()));
            outputStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JarOutputStream newJarOutputStream(OutputStream out, @Nullable Manifest manifest) throws IOException {
        JarOutputStream jar = new JarOutputStream(out);
        if (manifest != null) {
            JarEntry e = this.newReproducibleEntry("META-INF/MANIFEST.MF");
            jar.putNextEntry(e);
            manifest.write(new BufferedOutputStream(jar));
            jar.closeEntry();
        }
        return jar;
    }

    private void copyAndExtractProviders(JarInputStream inputStream, JarOutputStream outputStream, boolean willMergeJars, Map<String, List<String>> providers, Set<String> packages) throws IOException {
        JarEntry jarEntry = inputStream.getNextJarEntry();
        while (jarEntry != null) {
            boolean isFileInServicesFolder;
            byte[] content = this.readAllBytes(inputStream);
            String entryName = jarEntry.getName();
            boolean bl = isFileInServicesFolder = entryName.startsWith(SERVICES_PREFIX) && !entryName.equals(SERVICES_PREFIX) && !entryName.substring(SERVICES_PREFIX.length()).contains("/");
            if (isFileInServicesFolder) {
                String key = entryName.substring(SERVICES_PREFIX.length());
                if (!providers.containsKey(key)) {
                    providers.put(key, new ArrayList());
                }
                providers.get(key).addAll(this.extractImplementations(content));
            }
            if (!(JAR_SIGNATURE_PATH.matcher(entryName).matches() || "META-INF/MANIFEST.MF".equals(entryName) || ExtraJavaModuleInfoTransform.isModuleInfoClass(entryName) || willMergeJars && isFileInServicesFolder)) {
                int i;
                block9: {
                    jarEntry.setCompressedSize(-1L);
                    try {
                        outputStream.putNextEntry(jarEntry);
                        outputStream.write(content);
                        outputStream.closeEntry();
                    }
                    catch (ZipException e) {
                        if (e.getMessage().startsWith("duplicate entry:")) break block9;
                        throw new RuntimeException(e);
                    }
                }
                if (entryName.endsWith(".class") && (i = entryName.lastIndexOf("/")) > 0) {
                    Matcher mrJarMatcher = MRJAR_VERSIONS_PATH.matcher(entryName);
                    if (mrJarMatcher.matches()) {
                        packages.add(mrJarMatcher.group(1));
                    } else {
                        packages.add(entryName.substring(0, i));
                    }
                }
            }
            jarEntry = inputStream.getNextJarEntry();
        }
    }

    private List<String> extractImplementations(byte[] content) {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content), StandardCharsets.UTF_8)).lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).distinct().collect(Collectors.toList());
    }

    private byte[] addModuleInfo(ModuleInfo moduleInfo, Map<String, List<String>> providers, @Nullable String version, Set<String> autoExportedPackages) {
        Set modules;
        Iterator<String> packageName;
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(53, 32768, "module-info", null, null, null);
        int openModule = moduleInfo.openModule ? 32 : 0;
        String moduleVersion = moduleInfo.getModuleVersion() == null ? version : moduleInfo.getModuleVersion();
        ModuleVisitor moduleVisitor = classWriter.visitModule(moduleInfo.getModuleName(), openModule, moduleVersion);
        for (String string : autoExportedPackages) {
            moduleVisitor.visitExport(string, 0, new String[0]);
        }
        for (Map.Entry entry : moduleInfo.exports.entrySet()) {
            packageName = (String)entry.getKey();
            modules = (Set)entry.getValue();
            moduleVisitor.visitExport(((String)((Object)packageName)).replace('.', '/'), 0, modules.toArray(new String[0]));
        }
        for (Map.Entry entry : moduleInfo.opens.entrySet()) {
            packageName = (String)entry.getKey();
            modules = (Set)entry.getValue();
            moduleVisitor.visitOpen(((String)((Object)packageName)).replace('.', '/'), 0, modules.toArray(new String[0]));
        }
        moduleVisitor.visitRequire("java.base", 0, null);
        if (moduleInfo.requireAllDefinedDependencies) {
            String depModuleName;
            String fullIdentifier = moduleInfo.getIdentifier() + ":" + version;
            PublishedMetadata publishedMetadata = (PublishedMetadata)((Map)((Parameter)this.getParameters()).getRequiresFromMetadata().get()).get(fullIdentifier);
            if (publishedMetadata == null) {
                throw new RuntimeException("[requires directives from metadata] Cannot find dependencies for '" + moduleInfo.getModuleName() + "'. Are '" + moduleInfo.getIdentifier() + "' the correct component coordinates?");
            }
            for (String ga : publishedMetadata.getRequires()) {
                depModuleName = this.gaToModuleName(ga);
                moduleVisitor.visitRequire(depModuleName, 0, null);
            }
            for (String ga : publishedMetadata.getRequiresTransitive()) {
                depModuleName = this.gaToModuleName(ga);
                moduleVisitor.visitRequire(depModuleName, 32, null);
            }
            for (String ga : publishedMetadata.getRequiresStaticTransitive()) {
                depModuleName = this.gaToModuleName(ga);
                moduleVisitor.visitRequire(depModuleName, 96, null);
            }
        }
        for (String string : moduleInfo.requires) {
            moduleVisitor.visitRequire(string, 0, null);
        }
        for (String string : moduleInfo.requiresTransitive) {
            moduleVisitor.visitRequire(string, 32, null);
        }
        for (String string : moduleInfo.requiresStatic) {
            moduleVisitor.visitRequire(string, 64, null);
        }
        for (String string : moduleInfo.uses) {
            moduleVisitor.visitUse(string.replace('.', '/'));
        }
        for (Map.Entry entry : providers.entrySet()) {
            String name = (String)entry.getKey();
            List implementations = (List)entry.getValue();
            if (moduleInfo.ignoreServiceProviders.contains(name)) continue;
            moduleVisitor.visitProvide(name.replace('.', '/'), (String[])implementations.stream().map(impl -> impl.replace('.', '/')).toArray(String[]::new));
        }
        moduleVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private void mergeJars(ModuleSpec moduleSpec, JarOutputStream outputStream, Map<String, List<String>> providers, Set<String> packages) throws IOException {
        if (moduleSpec.getMergedJars().isEmpty()) {
            return;
        }
        RegularFile mergeJarFile = null;
        for (String identifier : moduleSpec.getMergedJars()) {
            List ids = (List)((Parameter)this.getParameters()).getMergeJarIds().get();
            List jarFiles = (List)((Parameter)this.getParameters()).getMergeJars().get();
            for (int i = 0; i < ids.size(); ++i) {
                if (((String)ids.get(i)).equals(identifier)) {
                    mergeJarFile = (RegularFile)jarFiles.get(i);
                    break;
                }
                if (!((RegularFile)jarFiles.get(i)).getAsFile().getName().equals(identifier)) continue;
                mergeJarFile = (RegularFile)jarFiles.get(i);
                break;
            }
            if (mergeJarFile != null) {
                JarInputStream toMergeInputStream = new JarInputStream(Files.newInputStream(mergeJarFile.getAsFile().toPath(), new OpenOption[0]));
                try {
                    this.copyAndExtractProviders(toMergeInputStream, outputStream, true, providers, packages);
                    continue;
                }
                finally {
                    toMergeInputStream.close();
                    continue;
                }
            }
            throw new RuntimeException("Jar not found: " + identifier);
        }
        this.mergeServiceProviderFiles(outputStream, providers);
    }

    private void mergeServiceProviderFiles(JarOutputStream outputStream, Map<String, List<String>> providers) throws IOException {
        for (Map.Entry<String, List<String>> provider : providers.entrySet()) {
            outputStream.putNextEntry(this.newReproducibleEntry(SERVICES_PREFIX + provider.getKey()));
            for (String implementation : provider.getValue()) {
                outputStream.write(implementation.getBytes());
                outputStream.write("\n".getBytes());
            }
            outputStream.closeEntry();
        }
    }

    private JarEntry newReproducibleEntry(String name) {
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(CONSTANT_TIME_FOR_ZIP_ENTRIES);
        return jarEntry;
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int readLen;
            while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                outputStream.write(buf, 0, readLen);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private String gaToModuleName(String ga) {
        ModuleSpec moduleSpec = (ModuleSpec)((Map)((Parameter)this.getParameters()).getModuleSpecs().get()).get(ga);
        if (moduleSpec != null) {
            return moduleSpec.getModuleName();
        }
        String moduleNameFromSharedMapping = this.moduleNameFromSharedMapping(ga);
        if (moduleNameFromSharedMapping != null) {
            return moduleNameFromSharedMapping;
        }
        throw new RuntimeException("[requires directives from metadata] The module name of the following component is not known: " + ga + "\n - If it is already a module, make the module name known using 'knownModule(\"" + ga + "\", \"<module name>\")'\n - If it is not a module, patch it using 'module()' or 'automaticModule()'");
    }

    @Nullable
    private String moduleNameFromSharedMapping(String ga) {
        Optional<String> foundInCustom = ((Map)((Parameter)this.getParameters()).getAdditionalKnownModules().get()).entrySet().stream().filter(e -> ((String)e.getValue()).equals(ga)).map(Map.Entry::getKey).findFirst();
        if (foundInCustom.isPresent()) {
            return foundInCustom.get();
        }
        try {
            Class<?> sharedMappings = Class.forName("org.gradlex.javamodule.dependencies.SharedMappings");
            Map mappings = (Map)sharedMappings.getDeclaredField("mappings").get(null);
            Optional<String> found = mappings.entrySet().stream().filter(e -> ((String)e.getValue()).equals(ga)).map(Map.Entry::getKey).findFirst();
            return found.orElse(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    private static boolean isModuleInfoClass(String jarEntryName) {
        return "module-info.class".equals(jarEntryName) || MODULE_INFO_CLASS_MRJAR_PATH.matcher(jarEntryName).matches();
    }

    public static interface Parameter
    extends TransformParameters {
        @Input
        public MapProperty<String, ModuleSpec> getModuleSpecs();

        @Input
        public Property<Boolean> getFailOnMissingModuleInfo();

        @Input
        public Property<Boolean> getFailOnAutomaticModules();

        @Input
        public Property<Boolean> getDeriveAutomaticModuleNamesFromFileNames();

        @Input
        public ListProperty<String> getMergeJarIds();

        @InputFiles
        public ListProperty<RegularFile> getMergeJars();

        @Input
        public MapProperty<String, PublishedMetadata> getRequiresFromMetadata();

        @Input
        public MapProperty<String, String> getAdditionalKnownModules();
    }
}

