/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradlex.javamodule.moduleinfo.AutomaticModuleName;
import org.gradlex.javamodule.moduleinfo.FilePathToModuleCoordinates;
import org.gradlex.javamodule.moduleinfo.ModuleInfo;
import org.gradlex.javamodule.moduleinfo.ModuleNameUtil;
import org.gradlex.javamodule.moduleinfo.ModuleSpec;
import org.gradlex.javamodule.moduleinfo.PublishedMetadata;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

@CacheableTransform
public abstract class ExtraJavaModuleInfoTransform
implements TransformAction<Parameter> {
    private static final Pattern MODULE_INFO_CLASS_MRJAR_PATH = Pattern.compile("META-INF/versions/\\d+/module-info.class");
    private static final Pattern MRJAR_VERSIONS_PATH = Pattern.compile("META-INF/versions/\\d+/(.*)/.*");
    private static final Pattern JAR_SIGNATURE_PATH = Pattern.compile("^META-INF/[^/]+\\.(SF|RSA|DSA|sf|rsa|dsa)$");
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();

    @InputArtifact
    @Classpath
    protected abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        Parameter parameters = (Parameter)this.getParameters();
        Map moduleSpecs = (Map)parameters.getModuleSpecs().get();
        File originalJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        ModuleSpec moduleSpec = this.findModuleSpec(originalJar);
        if (this.willBeMerged(originalJar, moduleSpecs.values())) {
            return;
        }
        this.checkInputExists(originalJar);
        if (!(moduleSpec != null || ((Boolean)((Parameter)this.getParameters()).getFailOnAutomaticModules().get()).booleanValue() || ((Boolean)((Parameter)this.getParameters()).getFailOnMissingModuleInfo().get()).booleanValue() || ((Boolean)((Parameter)this.getParameters()).getDeriveAutomaticModuleNamesFromFileNames().get()).booleanValue())) {
            outputs.file((Object)originalJar);
            return;
        }
        boolean realModule = this.isModule(originalJar);
        if (moduleSpec instanceof ModuleInfo) {
            String expectedAutomaticNameFromFileName;
            if (realModule && !((ModuleInfo)moduleSpec).patchRealModule) {
                throw new RuntimeException("Patching of real modules must be explicitly enabled with 'patchRealModule()' or 'preserveExisting()'");
            }
            String definedName = moduleSpec.getModuleName();
            String expectedName = this.autoModuleName(originalJar);
            if (expectedName != null && !definedName.equals(expectedName) && !moduleSpec.overrideModuleName) {
                throw new RuntimeException("The name '" + definedName + "' is different than the Automatic-Module-Name '" + expectedName + "'; explicitly allow override via 'overrideModuleName()'");
            }
            if (((Boolean)parameters.getFailOnModifiedDerivedModuleNames().get()).booleanValue() && !realModule && expectedName == null && !moduleSpec.overrideModuleName && !definedName.equals(expectedAutomaticNameFromFileName = ModuleNameUtil.automaticModulNameFromFileName(originalJar))) {
                throw new RuntimeException("The name '" + definedName + "' is different than the name derived from the Jar file name '" + expectedAutomaticNameFromFileName + "'; turn off 'failOnModifiedDerivedModuleNames' or explicitly allow override via 'overrideModuleName()'");
            }
            this.addModuleDescriptor(originalJar, this.getModuleJar(outputs, originalJar), (ModuleInfo)moduleSpec);
        } else if (moduleSpec instanceof AutomaticModuleName) {
            if (realModule) {
                throw new RuntimeException("Patching of real modules must be explicitly enabled with 'patchRealModule()' and can only be done with 'module()'");
            }
            String definedName = moduleSpec.getModuleName();
            String expectedName = this.autoModuleName(originalJar);
            if (!(expectedName == null || !moduleSpec.getMergedJars().isEmpty() && definedName.equals(expectedName) || moduleSpec.overrideModuleName)) {
                throw new RuntimeException("'" + definedName + "' already has the Automatic-Module-Name '" + expectedName + "'; explicitly allow override via 'overrideModuleName()'");
            }
            if (((Boolean)parameters.getFailOnAutomaticModules().get()).booleanValue()) {
                throw new RuntimeException("Use of 'automaticModule()' is prohibited. Use 'module()' instead: " + originalJar.getName());
            }
            this.addAutomaticModuleName(originalJar, this.getModuleJar(outputs, originalJar), (AutomaticModuleName)moduleSpec);
        } else if (realModule) {
            outputs.file((Object)originalJar);
        } else if (this.autoModuleName(originalJar) != null) {
            if (((Boolean)parameters.getFailOnAutomaticModules().get()).booleanValue()) {
                throw new RuntimeException("Found an automatic module: " + this.autoModuleName(originalJar) + " (" + originalJar.getName() + ")");
            }
            outputs.file((Object)originalJar);
        } else if (((Boolean)parameters.getDeriveAutomaticModuleNamesFromFileNames().get()).booleanValue()) {
            String automaticName = ModuleNameUtil.automaticModulNameFromFileName(originalJar);
            this.addAutomaticModuleName(originalJar, this.getModuleJar(outputs, originalJar), new AutomaticModuleName(originalJar.getName(), automaticName));
        } else {
            if (((Boolean)parameters.getFailOnMissingModuleInfo().get()).booleanValue()) {
                throw new RuntimeException("Not a module and no mapping defined: " + originalJar.getName());
            }
            outputs.file((Object)originalJar);
        }
    }

    private void checkInputExists(File jar) {
        if (!jar.isFile()) {
            throw new RuntimeException("File does not exist: " + jar + "\n  This is likely because a tool or another plugin performs early dependency resolution.\n  You can prevent this error by setting 'skipLocalJars = true'.");
        }
    }

    @Nullable
    private ModuleSpec findModuleSpec(File originalJar) {
        Map moduleSpecs = (Map)((Parameter)this.getParameters()).getModuleSpecs().get();
        Optional<ModuleSpec> moduleSpec = moduleSpecs.values().stream().filter(spec -> FilePathToModuleCoordinates.gaCoordinatesFromFilePathMatch(originalJar.toPath(), spec.getIdentifier())).findFirst();
        if (moduleSpec.isPresent()) {
            String ga = moduleSpec.get().getIdentifier();
            if (moduleSpecs.containsKey(ga)) {
                return (ModuleSpec)moduleSpecs.get(ga);
            }
            Stream<String> idsWithClassifier = moduleSpecs.keySet().stream().filter(id -> id.startsWith(ga + "|"));
            for (String idWithClassifier : idsWithClassifier.collect(Collectors.toList())) {
                if (!this.nameHasClassifier(originalJar, (ModuleSpec)moduleSpecs.get(idWithClassifier))) continue;
                return (ModuleSpec)moduleSpecs.get(idWithClassifier);
            }
            return null;
        }
        String originalJarName = originalJar.getName();
        if (moduleSpecs.containsKey(originalJarName)) {
            return (ModuleSpec)moduleSpecs.get(originalJarName);
        }
        return null;
    }

    private boolean willBeMerged(File originalJar, Collection<ModuleSpec> modules) {
        return modules.stream().anyMatch(module -> module.getMergedJars().stream().anyMatch(toMerge -> FilePathToModuleCoordinates.gaCoordinatesFromFilePathMatch(originalJar.toPath(), toMerge) || toMerge.equals(originalJar.getName())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModule(File jar) {
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(jar.toPath(), new OpenOption[0]));){
            boolean isMultiReleaseJar = this.containsMultiReleaseJarEntry(inputStream);
            ZipEntry next = inputStream.getNextEntry();
            while (next != null) {
                if ("module-info.class".equals(next.getName())) {
                    boolean bl = true;
                    return bl;
                }
                if (isMultiReleaseJar && MODULE_INFO_CLASS_MRJAR_PATH.matcher(next.getName()).matches()) {
                    boolean bl = true;
                    return bl;
                }
                next = inputStream.getNextEntry();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsMultiReleaseJarEntry(JarInputStream jarStream) {
        Manifest manifest = jarStream.getManifest();
        return manifest != null && Boolean.parseBoolean(manifest.getMainAttributes().getValue("Multi-Release"));
    }

    @Nullable
    private String autoModuleName(File jar) {
        String string;
        JarInputStream inputStream = new JarInputStream(Files.newInputStream(jar.toPath(), new OpenOption[0]));
        try {
            Manifest manifest = inputStream.getManifest();
            string = manifest != null ? manifest.getMainAttributes().getValue("Automatic-Module-Name") : null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return string;
    }

    private File getModuleJar(TransformOutputs outputs, File originalJar) {
        return outputs.file((Object)(originalJar.getName().substring(0, originalJar.getName().lastIndexOf(46)) + "-module.jar"));
    }

    private void addAutomaticModuleName(File originalJar, File moduleJar, AutomaticModuleName automaticModule) {
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(originalJar.toPath(), new OpenOption[0]));){
            Manifest manifest = inputStream.getManifest();
            if (manifest == null) {
                manifest = new Manifest();
                manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
            }
            manifest.getMainAttributes().putValue("Automatic-Module-Name", automaticModule.getModuleName());
            try (JarOutputStream outputStream = this.newJarOutputStream(Files.newOutputStream(moduleJar.toPath(), new OpenOption[0]), manifest);){
                LinkedHashMap<String, List<String>> providers = new LinkedHashMap<String, List<String>>();
                TreeSet<String> packages = new TreeSet<String>();
                this.copyAndExtractProviders(inputStream, outputStream, automaticModule.getRemovedPackages(), !automaticModule.getMergedJars().isEmpty(), providers, packages);
                this.mergeJars(automaticModule, outputStream, providers, packages);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addModuleDescriptor(File originalJar, File moduleJar, ModuleInfo moduleInfo) {
        try (JarInputStream inputStream = new JarInputStream(Files.newInputStream(originalJar.toPath(), new OpenOption[0]));
             JarOutputStream outputStream = this.newJarOutputStream(Files.newOutputStream(moduleJar.toPath(), new OpenOption[0]), inputStream.getManifest());){
            LinkedHashMap<String, List<String>> providers = new LinkedHashMap<String, List<String>>();
            TreeSet<String> packages = new TreeSet<String>();
            byte[] existingModuleInfo = this.copyAndExtractProviders(inputStream, outputStream, moduleInfo.getRemovedPackages(), !moduleInfo.getMergedJars().isEmpty(), providers, packages);
            this.mergeJars(moduleInfo, outputStream, providers, packages);
            outputStream.putNextEntry(this.newReproducibleEntry("module-info.class"));
            outputStream.write(this.addModuleInfo(moduleInfo, providers, FilePathToModuleCoordinates.versionFromFilePath(originalJar.toPath()), moduleInfo.exportAllPackages ? packages : Collections.emptySet(), existingModuleInfo));
            outputStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JarOutputStream newJarOutputStream(OutputStream out, @Nullable Manifest manifest) throws IOException {
        JarOutputStream jar = new JarOutputStream(out);
        if (manifest != null) {
            JarEntry e = this.newReproducibleEntry("META-INF/MANIFEST.MF");
            jar.putNextEntry(e);
            manifest.write(new BufferedOutputStream(jar));
            jar.closeEntry();
        }
        return jar;
    }

    @Nullable
    private byte[] copyAndExtractProviders(JarInputStream inputStream, JarOutputStream outputStream, List<String> removedPackages, boolean willMergeJars, Map<String, List<String>> providers, Set<String> packages) throws IOException {
        JarEntry jarEntry = inputStream.getNextJarEntry();
        byte[] existingModuleInfo = null;
        while (jarEntry != null) {
            block10: {
                boolean isFileInServicesFolder;
                byte[] content = this.readAllBytes(inputStream);
                String entryName = jarEntry.getName();
                boolean bl = isFileInServicesFolder = entryName.startsWith(SERVICES_PREFIX) && !entryName.equals(SERVICES_PREFIX) && !entryName.substring(SERVICES_PREFIX.length()).contains("/");
                if (isFileInServicesFolder) {
                    String key = entryName.substring(SERVICES_PREFIX.length());
                    if (!providers.containsKey(key)) {
                        providers.put(key, new ArrayList());
                    }
                    providers.get(key).addAll(this.extractImplementations(content));
                }
                if (ExtraJavaModuleInfoTransform.isModuleInfoClass(entryName)) {
                    existingModuleInfo = content;
                } else if (!(JAR_SIGNATURE_PATH.matcher(entryName).matches() || "META-INF/MANIFEST.MF".equals(entryName) || willMergeJars && isFileInServicesFolder)) {
                    String packagePath;
                    Matcher mrJarMatcher = MRJAR_VERSIONS_PATH.matcher(entryName);
                    int i = entryName.lastIndexOf("/");
                    String string = i > 0 ? (mrJarMatcher.matches() ? mrJarMatcher.group(1) : entryName.substring(0, i)) : (packagePath = "");
                    if (!removedPackages.contains(packagePath.replace('/', '.'))) {
                        if (entryName.endsWith(".class") && !packagePath.isEmpty()) {
                            packages.add(packagePath);
                        }
                        try {
                            jarEntry.setCompressedSize(-1L);
                            outputStream.putNextEntry(jarEntry);
                            outputStream.write(content);
                            outputStream.closeEntry();
                        }
                        catch (ZipException e) {
                            if (e.getMessage().startsWith("duplicate entry:")) break block10;
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            jarEntry = inputStream.getNextJarEntry();
        }
        return existingModuleInfo;
    }

    private List<String> extractImplementations(byte[] content) {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content), StandardCharsets.UTF_8)).lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).distinct().collect(Collectors.toList());
    }

    private byte[] addModuleInfo(final ModuleInfo moduleInfo, Map<String, List<String>> providers, @Nullable String version, final Set<String> autoExportedPackages, @Nullable byte[] existingModuleInfo) {
        String moduleVersion;
        ClassReader classReader = moduleInfo.preserveExisting && existingModuleInfo != null ? new ClassReader(existingModuleInfo) : null;
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        int openModule = moduleInfo.openModule ? 32 : 0;
        String string = moduleVersion = moduleInfo.getModuleVersion() == null ? version : moduleInfo.getModuleVersion();
        if (classReader == null) {
            classWriter.visit(53, 32768, "module-info", null, null, null);
            ModuleVisitor moduleVisitor = classWriter.visitModule(moduleInfo.getModuleName(), openModule, moduleVersion);
            moduleVisitor.visitRequire("java.base", 0, null);
            this.addModuleInfoEntires(moduleInfo, providers, autoExportedPackages, moduleVisitor);
            moduleVisitor.visitEnd();
            classWriter.visitEnd();
        } else {
            ClassVisitor classVisitor = new ClassVisitor(589824, (ClassVisitor)classWriter){

                public ModuleVisitor visitModule(String name, int access, String version) {
                    ModuleVisitor moduleVisitor = super.visitModule(name, access, version);
                    return new ModuleVisitor(589824, moduleVisitor){

                        public void visitEnd() {
                            ExtraJavaModuleInfoTransform.this.addModuleInfoEntires(moduleInfo, Collections.emptyMap(), autoExportedPackages, this);
                            super.visitEnd();
                        }
                    };
                }
            };
            classReader.accept(classVisitor, 0);
        }
        return classWriter.toByteArray();
    }

    private void addModuleInfoEntires(ModuleInfo moduleInfo, Map<String, List<String>> providers, Set<String> autoExportedPackages, ModuleVisitor moduleVisitor) {
        Set modules;
        Iterator<String> packageName;
        for (String string : autoExportedPackages) {
            moduleVisitor.visitExport(string, 0, new String[0]);
        }
        for (Map.Entry entry : moduleInfo.exports.entrySet()) {
            packageName = (String)entry.getKey();
            modules = (Set)entry.getValue();
            moduleVisitor.visitExport(((String)((Object)packageName)).replace('.', '/'), 0, modules.toArray(new String[0]));
        }
        for (Map.Entry entry : moduleInfo.opens.entrySet()) {
            packageName = (String)entry.getKey();
            modules = (Set)entry.getValue();
            moduleVisitor.visitOpen(((String)((Object)packageName)).replace('.', '/'), 0, modules.toArray(new String[0]));
        }
        if (moduleInfo.requireAllDefinedDependencies) {
            String depModuleName;
            String identifier = moduleInfo.getIdentifier();
            PublishedMetadata publishedMetadata = (PublishedMetadata)((Map)((Parameter)this.getParameters()).getRequiresFromMetadata().get()).get(identifier);
            if (publishedMetadata == null) {
                throw new RuntimeException("[requires directives from metadata] Cannot find dependencies for '" + moduleInfo.getModuleName() + "'. Are '" + moduleInfo.getIdentifier() + "' the correct component coordinates?");
            }
            if (publishedMetadata.getErrorMessage() != null) {
                throw new RuntimeException("[requires directives from metadata] Cannot read metadata for '" + moduleInfo.getModuleName() + "': " + publishedMetadata.getErrorMessage());
            }
            for (String ga : publishedMetadata.getRequires()) {
                depModuleName = this.gaToModuleName(ga);
                moduleVisitor.visitRequire(depModuleName, 0, null);
            }
            for (String ga : publishedMetadata.getRequiresTransitive()) {
                depModuleName = this.gaToModuleName(ga);
                moduleVisitor.visitRequire(depModuleName, 32, null);
            }
            for (String ga : publishedMetadata.getRequiresStaticTransitive()) {
                depModuleName = this.gaToModuleName(ga);
                moduleVisitor.visitRequire(depModuleName, 96, null);
            }
        }
        for (String string : moduleInfo.requires) {
            moduleVisitor.visitRequire(string, 0, null);
        }
        for (String string : moduleInfo.requiresTransitive) {
            moduleVisitor.visitRequire(string, 32, null);
        }
        for (String string : moduleInfo.requiresStatic) {
            moduleVisitor.visitRequire(string, 64, null);
        }
        for (String string : moduleInfo.requiresStaticTransitive) {
            moduleVisitor.visitRequire(string, 96, null);
        }
        for (String string : moduleInfo.uses) {
            moduleVisitor.visitUse(string.replace('.', '/'));
        }
        for (Map.Entry entry : providers.entrySet()) {
            String name = (String)entry.getKey();
            Set<String> skipSet = moduleInfo.ignoreServiceProviders.get(name);
            LinkedHashSet implementations = new LinkedHashSet((Collection)entry.getValue());
            if (skipSet != null) {
                if (skipSet.isEmpty()) {
                    implementations.clear();
                } else {
                    implementations.removeAll(skipSet);
                }
            }
            if (implementations.isEmpty()) continue;
            moduleVisitor.visitProvide(name.replace('.', '/'), (String[])implementations.stream().map(impl -> impl.replace('.', '/')).toArray(String[]::new));
        }
    }

    private void mergeJars(ModuleSpec moduleSpec, JarOutputStream outputStream, Map<String, List<String>> providers, Set<String> packages) throws IOException {
        if (moduleSpec.getMergedJars().isEmpty()) {
            return;
        }
        RegularFile mergeJarFile = null;
        for (String identifier : moduleSpec.getMergedJars()) {
            List ids = (List)((Parameter)this.getParameters()).getMergeJarIds().get();
            List jarFiles = (List)((Parameter)this.getParameters()).getMergeJars().get();
            for (int i = 0; i < ids.size(); ++i) {
                if (((String)ids.get(i)).equals(identifier)) {
                    mergeJarFile = (RegularFile)jarFiles.get(i);
                    break;
                }
                if (!((RegularFile)jarFiles.get(i)).getAsFile().getName().equals(identifier)) continue;
                mergeJarFile = (RegularFile)jarFiles.get(i);
                break;
            }
            if (mergeJarFile != null) {
                JarInputStream toMergeInputStream = new JarInputStream(Files.newInputStream(mergeJarFile.getAsFile().toPath(), new OpenOption[0]));
                try {
                    this.copyAndExtractProviders(toMergeInputStream, outputStream, moduleSpec.getRemovedPackages(), true, providers, packages);
                    continue;
                }
                finally {
                    toMergeInputStream.close();
                    continue;
                }
            }
            throw new RuntimeException("Jar not found: " + identifier);
        }
        this.mergeServiceProviderFiles(outputStream, providers);
    }

    private void mergeServiceProviderFiles(JarOutputStream outputStream, Map<String, List<String>> providers) throws IOException {
        for (Map.Entry<String, List<String>> provider : providers.entrySet()) {
            outputStream.putNextEntry(this.newReproducibleEntry(SERVICES_PREFIX + provider.getKey()));
            for (String implementation : provider.getValue()) {
                outputStream.write(implementation.getBytes());
                outputStream.write("\n".getBytes());
            }
            outputStream.closeEntry();
        }
    }

    private JarEntry newReproducibleEntry(String name) {
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(CONSTANT_TIME_FOR_ZIP_ENTRIES);
        return jarEntry;
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int readLen;
            while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                outputStream.write(buf, 0, readLen);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private String gaToModuleName(String ga) {
        ModuleSpec moduleSpec = (ModuleSpec)((Map)((Parameter)this.getParameters()).getModuleSpecs().get()).get(ga);
        if (moduleSpec != null) {
            return moduleSpec.getModuleName();
        }
        String moduleNameFromSharedMapping = this.moduleNameFromSharedMapping(ga);
        if (moduleNameFromSharedMapping != null) {
            return moduleNameFromSharedMapping;
        }
        throw new RuntimeException("[requires directives from metadata] The module name of the following component is not known: " + ga + "\n - If it is already a module, make the module name known using 'knownModule(\"" + ga + "\", \"<module name>\")'\n - If it is not a module, patch it using 'module()' or 'automaticModule()'");
    }

    @Nullable
    private String moduleNameFromSharedMapping(String ga) {
        Optional<String> foundInCustom = ((Map)((Parameter)this.getParameters()).getAdditionalKnownModules().get()).entrySet().stream().filter(e -> ((String)e.getValue()).equals(ga)).map(Map.Entry::getKey).findFirst();
        if (foundInCustom.isPresent()) {
            return foundInCustom.get();
        }
        try {
            Class<?> sharedMappings = Class.forName("org.gradlex.javamodule.dependencies.SharedMappings");
            Map mappings = (Map)sharedMappings.getDeclaredField("mappings").get(null);
            Optional<String> found = mappings.entrySet().stream().filter(e -> ((String)e.getValue()).equals(ga)).map(Map.Entry::getKey).findFirst();
            return found.orElse(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    private boolean nameHasClassifier(File jar, ModuleSpec spec) {
        return jar.getName().endsWith("-" + spec.getClassifier() + ".jar");
    }

    private static boolean isModuleInfoClass(String jarEntryName) {
        return "module-info.class".equals(jarEntryName) || MODULE_INFO_CLASS_MRJAR_PATH.matcher(jarEntryName).matches();
    }

    public static interface Parameter
    extends TransformParameters {
        @Input
        public MapProperty<String, ModuleSpec> getModuleSpecs();

        @Input
        public Property<Boolean> getFailOnMissingModuleInfo();

        @Input
        public Property<Boolean> getFailOnAutomaticModules();

        @Input
        public Property<Boolean> getFailOnModifiedDerivedModuleNames();

        @Input
        public Property<Boolean> getDeriveAutomaticModuleNamesFromFileNames();

        @Input
        public ListProperty<String> getMergeJarIds();

        @InputFiles
        @Classpath
        public ListProperty<RegularFile> getMergeJars();

        @Input
        public MapProperty<String, PublishedMetadata> getRequiresFromMetadata();

        @Input
        public MapProperty<String, String> getAdditionalKnownModules();
    }
}

