/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.shadow.com.fasterxml.jackson.module.kotlin;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.shadow.com.fasterxml.jackson.core.JsonParser;
import org.gradle.shadow.com.fasterxml.jackson.core.JsonToken;
import org.gradle.shadow.com.fasterxml.jackson.core.exc.InputCoercionException;
import org.gradle.shadow.com.fasterxml.jackson.databind.DeserializationContext;
import org.gradle.shadow.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.gradle.shadow.com.fasterxml.jackson.module.kotlin.UnsignedNumbersKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006\u000b"}, d2={"Lorg/gradle/shadow/com/fasterxml/jackson/module/kotlin/ULongDeserializer;", "Lorg/gradle/shadow/com/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lkotlin/ULong;", "()V", "deserialize", "p", "Lorg/gradle/shadow/com/fasterxml/jackson/core/JsonParser;", "ctxt", "Lorg/gradle/shadow/com/fasterxml/jackson/databind/DeserializationContext;", "deserialize-s-VKNKU", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)J", "jackson-module-kotlin"})
public final class ULongDeserializer
extends StdDeserializer<ULong> {
    @NotNull
    public static final ULongDeserializer INSTANCE;

    public long deserialize-s-VKNKU(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        BigInteger bigInteger = p.getBigIntegerValue();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"p.bigIntegerValue");
        ULong uLong = UnsignedNumbersKt.asULong(bigInteger);
        if (uLong == null) {
            throw (Throwable)new InputCoercionException(p, "Numeric value (" + p.getText() + ") out of range of ULong (0 - " + ULong.toString-impl((long)-1L) + ").", JsonToken.VALUE_NUMBER_INT, ULong.class);
        }
        return uLong.unbox-impl();
    }

    private ULongDeserializer() {
        super(ULong.class);
    }

    static {
        ULongDeserializer uLongDeserializer;
        INSTANCE = uLongDeserializer = new ULongDeserializer();
    }
}

