/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.shadow.com.fasterxml.jackson.module.kotlin;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.gradle.shadow.com.fasterxml.jackson.core.JsonParser;
import org.gradle.shadow.com.fasterxml.jackson.databind.DeserializationContext;
import org.gradle.shadow.com.fasterxml.jackson.databind.JsonNode;
import org.gradle.shadow.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.gradle.shadow.com.fasterxml.jackson.module.kotlin.RegexDeserializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/gradle/shadow/com/fasterxml/jackson/module/kotlin/RegexDeserializer;", "Lorg/gradle/shadow/com/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lkotlin/text/Regex;", "()V", "deserialize", "p", "Lorg/gradle/shadow/com/fasterxml/jackson/core/JsonParser;", "ctxt", "Lorg/gradle/shadow/com/fasterxml/jackson/databind/DeserializationContext;", "jackson-module-kotlin"})
public final class RegexDeserializer
extends StdDeserializer<Regex> {
    @NotNull
    public static final RegexDeserializer INSTANCE;

    @Override
    @NotNull
    public Regex deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        JsonNode node;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode jsonNode = node = ctxt.readTree(p);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"node");
        if (jsonNode.isTextual()) {
            String string = node.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.asText()");
            return new Regex(string);
        }
        if (node.isObject()) {
            Set set;
            String pattern = node.get("pattern").asText();
            if (node.has("options")) {
                JsonNode optionsNode;
                JsonNode jsonNode2 = optionsNode = node.get("options");
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"optionsNode");
                if (!jsonNode2.isArray()) {
                    throw (Throwable)new IllegalStateException("Expected an array of strings for RegexOptions, but type was " + (Object)((Object)node.getNodeType()));
                }
                Iterator<JsonNode> iterator = optionsNode.elements();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"optionsNode.elements()");
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence(iterator), (Function1)deserialize.options.1.INSTANCE));
            } else {
                set = SetsKt.emptySet();
            }
            Set options2 = set;
            String string = pattern;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern");
            return new Regex(string, options2);
        }
        throw (Throwable)new IllegalStateException("Expected a string or an object to deserialize a Regex, but type was " + (Object)((Object)node.getNodeType()));
    }

    private RegexDeserializer() {
        super(Regex.class);
    }

    static {
        RegexDeserializer regexDeserializer;
        INSTANCE = regexDeserializer = new RegexDeserializer();
    }
}

