/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.libgraal.processor;

import com.oracle.truffle.libgraal.processor.BaseProcessor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal", "com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraalRepeated"})
public class TruffleFromLibGraalProcessor
extends BaseProcessor {
    private final Set<ExecutableElement> processed = new HashSet<ExecutableElement>();

    protected boolean accept(ExecutableElement annotatedElement) {
        return true;
    }

    static TypeElement topDeclaringType(Element element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing == null || enclosing.getKind() == ElementKind.PACKAGE) {
            assert (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE);
            return (TypeElement)element;
        }
        return TruffleFromLibGraalProcessor.topDeclaringType(enclosing);
    }

    private void processElement(ExecutableElement hsCall, DeclaredType annotationType, Map<Element, CallsInfo> calls) {
        if (this.processed.contains(hsCall) || !this.accept(hsCall)) {
            return;
        }
        TypeElement topDeclaringType = TruffleFromLibGraalProcessor.topDeclaringType(hsCall);
        if (topDeclaringType.asType().toString().contains("truffle.runtime")) {
            return;
        }
        CallsInfo info = calls.get(topDeclaringType);
        if (info == null) {
            info = new CallsInfo(topDeclaringType);
            calls.put(topDeclaringType, info);
        }
        this.processed.add(hsCall);
        info.originatingElements.add(hsCall);
        AnnotationMirror annotation = this.getAnnotation(hsCall, annotationType);
        List<AnnotationMirror> annotations = this.isRepeatedAnnotation(annotationType) ? TruffleFromLibGraalProcessor.getAnnotationValueList(annotation, "value", AnnotationMirror.class) : Collections.singletonList(annotation);
        TypeMirror signatureAnnotationType = this.getType("com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal.Signature");
        for (AnnotationMirror a : annotations) {
            VariableElement annotationValue = TruffleFromLibGraalProcessor.getAnnotationValue(a, "value", VariableElement.class);
            String idName = annotationValue.getSimpleName().toString();
            AnnotationMirror signatureAnnotation = this.getAnnotation(annotationValue, signatureAnnotationType);
            List<TypeMirror> signature = TruffleFromLibGraalProcessor.getAnnotationValueList(signatureAnnotation, "value", TypeMirror.class);
            Id id = new Id(idName, signature);
            info.ids.add(id);
        }
    }

    private boolean isRepeatedAnnotation(DeclaredType annotationType) {
        Name valueName = this.processingEnv.getElementUtils().getName("value");
        for (ExecutableElement method : ElementFilter.methodsIn(annotationType.asElement().getEnclosedElements())) {
            if (!valueName.equals(method.getSimpleName())) continue;
            return method.getReturnType().getKind() == TypeKind.ARRAY;
        }
        return false;
    }

    private void createFiles(CallsInfo info) {
        String pkg = ((PackageElement)info.topDeclaringType.getEnclosingElement()).getQualifiedName().toString();
        Name topDeclaringClass = info.topDeclaringType.getSimpleName();
        Element[] originatingElements = info.originatingElements.toArray(new Element[info.originatingElements.size()]);
        this.createGenSource(info, pkg, topDeclaringClass, originatingElements);
    }

    private static String uppercaseFirst(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String toJNIType(TypeMirror t, boolean uppercasePrimitive) {
        if (TruffleFromLibGraalProcessor.isPrimitiveOrVoid(t)) {
            if (!uppercasePrimitive) {
                return t.toString();
            }
            return TruffleFromLibGraalProcessor.uppercaseFirst(t.toString());
        }
        return "JObject";
    }

    private void createGenSource(CallsInfo info, String pkg, Name topDeclaringClass, Element[] originatingElements) {
        String genClassName = String.valueOf(topDeclaringClass) + "Gen";
        Filer filer = this.processingEnv.getFiler();
        try (PrintWriter out = TruffleFromLibGraalProcessor.createSourceFile(pkg, genClassName, filer, originatingElements);){
            out.println("// CheckStyle: stop header check");
            out.println("// CheckStyle: stop line length check");
            out.println("// GENERATED CONTENT - DO NOT EDIT");
            out.printf("// Source: %s.java%n", topDeclaringClass);
            out.printf("// Generated-by: %s%n", this.getClass().getName());
            out.println("package " + pkg + ";");
            out.println("");
            boolean usesJObject = false;
            for (Id id : info.ids) {
                out.printf("import static com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal.Id.%s;%n", id.name);
                TypeMirror returnType = id.returnType;
                if (!TruffleFromLibGraalProcessor.isPrimitiveOrVoid(returnType)) {
                    usesJObject = true;
                }
                for (TypeMirror t : id.parameterTypes) {
                    if (TruffleFromLibGraalProcessor.isPrimitiveOrVoid(t)) continue;
                    usesJObject = true;
                }
            }
            out.println("");
            out.println("import org.graalvm.nativeimage.StackValue;");
            out.println("import org.graalvm.jniutils.JNI.JNIEnv;");
            out.println("import org.graalvm.jniutils.JNI.JValue;");
            if (usesJObject) {
                out.println("import org.graalvm.jniutils.JNI.JObject;");
            }
            out.println("");
            out.printf("final class %s {%n", genClassName);
            for (Id id : info.ids) {
                int p = 0;
                String idName = id.name;
                TypeMirror rt = id.returnType;
                out.println("");
                if (!TruffleFromLibGraalProcessor.isPrimitiveOrVoid(rt)) {
                    out.println("    @SuppressWarnings(\"unchecked\")");
                    out.printf("    static <T extends JObject> T call%s(TruffleFromLibGraalCalls calls, JNIEnv env", idName);
                } else {
                    out.printf("    static %s call%s(TruffleFromLibGraalCalls calls, JNIEnv env", TruffleFromLibGraalProcessor.toJNIType(rt, false), idName);
                }
                List<TypeMirror> parameterTypes = id.parameterTypes;
                for (TypeMirror t : parameterTypes) {
                    out.printf(", %s p%d", TruffleFromLibGraalProcessor.isPrimitiveOrVoid(t) ? t.toString() : "JObject", p);
                    ++p;
                }
                out.println(") {");
                out.printf("        JValue args = StackValue.get(%d, JValue.class);%n", parameterTypes.size());
                p = 0;
                for (TypeMirror t : parameterTypes) {
                    out.printf("        args.addressOf(%d).set%s(p%d);%n", p, TruffleFromLibGraalProcessor.toJNIType(t, true), p);
                    ++p;
                }
                String returnPrefix = !TruffleFromLibGraalProcessor.isPrimitiveOrVoid(rt) ? "return (T) " : (rt.getKind() == TypeKind.VOID ? "" : "return ");
                out.printf("        %scalls.call%s(env, %s, args);%n", returnPrefix, TruffleFromLibGraalProcessor.toJNIType(rt, true), idName);
                out.println("    }");
            }
            out.println("}");
        }
    }

    private static boolean isPrimitiveOrVoid(TypeMirror returnType) {
        return returnType.getKind() == TypeKind.VOID || returnType instanceof PrimitiveType;
    }

    @Override
    public final boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        HashMap<Element, CallsInfo> calls = new HashMap<Element, CallsInfo>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.processElement((ExecutableElement)element, (DeclaredType)typeElement.asType(), calls);
            }
        }
        for (CallsInfo callsInfo : calls.values()) {
            this.createFiles(callsInfo);
        }
        return true;
    }

    static class CallsInfo {
        final Element topDeclaringType;
        final List<Id> ids = new ArrayList<Id>();
        final Set<Element> originatingElements = new HashSet<Element>();

        CallsInfo(Element topDeclaringType) {
            this.topDeclaringType = topDeclaringType;
        }
    }

    static class Id {
        final String name;
        final List<TypeMirror> parameterTypes;
        final TypeMirror returnType;

        Id(String name, List<TypeMirror> signatureTypes) {
            this.name = name;
            this.returnType = signatureTypes.get(0);
            this.parameterTypes = signatureTypes.subList(1, signatureTypes.size());
        }
    }
}

