/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.DynamicOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import java.util.List;
import javax.lang.model.type.DeclaredType;

public class BytecodeDSLBuiltins {
    private static final String GENERATE_BYTECODE = "com.oracle.truffle.api.bytecode.GenerateBytecode";

    public static void addBuiltins(BytecodeDSLModel m, TruffleTypes types, ProcessorContext context) {
        m.popInstruction = m.instruction(InstructionModel.InstructionKind.POP, "pop", m.signature(Void.TYPE, Object.class));
        m.dupInstruction = m.instruction(InstructionModel.InstructionKind.DUP, "dup", m.signature(Void.TYPE, new Class[0]));
        m.returnInstruction = m.instruction(InstructionModel.InstructionKind.RETURN, "return", m.signature(Void.TYPE, Object.class));
        m.branchInstruction = m.instruction(InstructionModel.InstructionKind.BRANCH, "branch", m.signature(Void.TYPE, new Class[0])).addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target");
        m.branchBackwardInstruction = m.instruction(InstructionModel.InstructionKind.BRANCH_BACKWARD, "branch.backward", m.signature(Void.TYPE, new Class[0])).addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target").addImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE, "loop_header_branch_profile");
        m.branchFalseInstruction = m.instruction(InstructionModel.InstructionKind.BRANCH_FALSE, "branch.false", m.signature(Void.TYPE, Object.class)).addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, "branch_target").addImmediate(InstructionModel.ImmediateKind.BRANCH_PROFILE, "branch_profile");
        m.throwInstruction = m.instruction(InstructionModel.InstructionKind.THROW, "throw", m.signature(Void.TYPE, Object.class));
        m.loadConstantInstruction = m.instruction(InstructionModel.InstructionKind.LOAD_CONSTANT, "load.constant", m.signature(Object.class, new Class[0])).addImmediate(InstructionModel.ImmediateKind.CONSTANT, "constant");
        m.loadNullInstruction = m.instruction(InstructionModel.InstructionKind.LOAD_NULL, "load.null", m.signature(Object.class, new Class[0]));
        m.blockOperation = m.operation(OperationModel.OperationKind.BLOCK, "Block", "Block is a grouping operation that executes each child in its body sequentially, producing the result of the last child (if any).\nThis operation can be used to group multiple operations together in a single operation.\nThe result of a Block is the result produced by the last child (or void, if no value is produced).\n").setTransparent(true).setVariadic(true).setDynamicOperands(BytecodeDSLBuiltins.transparentOperationChild());
        m.rootOperation = m.operation(OperationModel.OperationKind.ROOT, "Root", BytecodeDSLBuiltins.rootOperationJavadoc(m)).setTransparent(true).setVariadic(true).setDynamicOperands(BytecodeDSLBuiltins.transparentOperationChild());
        m.ifThenOperation = m.operation(OperationModel.OperationKind.IF_THEN, "IfThen", "IfThen implements an if-then statement. It evaluates {@code condition}, which must produce a boolean. If the value is {@code true}, it executes {@code thens}.\nThis is a void operation; {@code thens} can also be void.\n").setVoid(true).setDynamicOperands(BytecodeDSLBuiltins.child("condition"), BytecodeDSLBuiltins.voidableChild("thens"));
        m.ifThenElseOperation = m.operation(OperationModel.OperationKind.IF_THEN_ELSE, "IfThenElse", "IfThenElse implements an if-then-else statement. It evaluates {@code condition}, which must produce a boolean. If the value is {@code true}, it executes {@code thens}; otherwise, it executes {@code elses}.\nThis is a void operation; both {@code thens} and {@code elses} can also be void.\n").setVoid(true).setDynamicOperands(BytecodeDSLBuiltins.child("condition"), BytecodeDSLBuiltins.voidableChild("thens"), BytecodeDSLBuiltins.voidableChild("elses"));
        m.conditionalOperation = m.operation(OperationModel.OperationKind.CONDITIONAL, "Conditional", "Conditional implements a conditional expression (e.g., {@code condition ? thens : elses} in Java). It has the same semantics as IfThenElse, except it produces the value of the conditionally-executed child.\n").setDynamicOperands(BytecodeDSLBuiltins.child("condition"), BytecodeDSLBuiltins.child("thens"), BytecodeDSLBuiltins.child("elses"));
        m.whileOperation = m.operation(OperationModel.OperationKind.WHILE, "While", "While implements a while loop. It evaluates {@code condition}, which must produce a boolean. If the value is {@code true}, it executes {@code body} and repeats.\nThis is a void operation; {@code body} can also be void.\n").setVoid(true).setDynamicOperands(BytecodeDSLBuiltins.child("condition"), BytecodeDSLBuiltins.voidableChild("body"));
        m.tryCatchOperation = m.operation(OperationModel.OperationKind.TRY_CATCH, "TryCatch", "TryCatch implements an exception handler. It executes {@code try}, and if a Truffle exception is thrown, it executes {@code catch}.\nThe exception can be accessed within the {@code catch} operation using LoadException.\nUnlike a Java try-catch, this operation does not filter the exception based on type.\nThis is a void operation; both {@code try} and {@code catch} can also be void.\n").setVoid(true).setDynamicOperands(BytecodeDSLBuiltins.voidableChild("try"), BytecodeDSLBuiltins.voidableChild("catch"));
        DeclaredType finallyGeneratorType = context.getDeclaredType(Runnable.class);
        m.tryFinallyOperation = m.operation(OperationModel.OperationKind.TRY_FINALLY, "TryFinally", "TryFinally implements a finally handler. It executes {@code try}, and after execution finishes it always executes {@code finally}.\nIf {@code try} finishes normally, {@code finally} executes and control continues after the TryFinally operation.\nIf {@code try} finishes exceptionally, {@code finally} executes and then rethrows the exception.\nIf {@code try} finishes with a control flow operation, {@code finally} executes and then the control flow operation continues (i.e., a Branch will branch, a Return will return).\n<p>\nUnlike other child operations, {@code finally} is emitted multiple times in the bytecode (once for each regular, exceptional, and early control flow exit).\nTo facilitate this, the {@code finally} operation is specified by a {@code finallyGenerator} that can be invoked multiple times. It should be repeatable and not have side effects.\n<p>\nThis is a void operation; either of {@code try} or {@code finally} can be void.\n").setVoid(true).setOperationBeginArguments(new OperationModel.OperationArgument(finallyGeneratorType, OperationModel.OperationArgument.Encoding.FINALLY_GENERATOR, "finallyGenerator", "an idempotent Runnable that generates the {@code finally} operation using builder calls")).setDynamicOperands(BytecodeDSLBuiltins.voidableChild("try"));
        m.tryCatchOtherwiseOperation = m.operation(OperationModel.OperationKind.TRY_CATCH_OTHERWISE, "TryCatchOtherwise", "TryCatchOtherwise implements a try block with different handling for regular and exceptional behaviour. It executes {@code try} and then one of the handlers.\nIf {@code try} finishes normally, {@code otherwise} executes and control continues after the TryCatchOtherwise operation.\nIf {@code try} finishes exceptionally, {@code catch} executes. The exception can be accessed using LoadException. Control continues after the TryCatchOtherwise operation.\nIf {@code try} finishes with a control flow operation, {@code otherwise} executes and then the control flow operation continues (i.e., a Branch will branch, a Return will return).\n<p>\nUnlike other child operations, {@code otherwise} is emitted multiple times in the bytecode (once for each regular and early control flow exit).\nTo facilitate this, the {@code otherwise} operation is specified by an {@code otherwiseGenerator} that can be invoked multiple times. It should be repeatable and not have side effects.\n<p>\nThis operation is effectively a TryFinally operation with a specialized handler for the exception case.\nIt does <strong>not</strong> implement try-catch-finally semantics: if an exception is thrown {@code catch} executes and {@code otherwise} does not.\nIn pseudocode, it implements:\n<pre>\ntry {\n    tryOperation\n} finally {\n    if (exceptionThrown) {\n        catchOperation\n    } else {\n        otherwiseOperation\n    }\n}\n</pre>\n<p>\nThis is a void operation; any of {@code try}, {@code catch}, or {@code otherwise} can be void.\n").setVoid(true).setOperationBeginArguments(new OperationModel.OperationArgument(finallyGeneratorType, OperationModel.OperationArgument.Encoding.FINALLY_GENERATOR, "otherwiseGenerator", "an idempotent Runnable that generates the {@code otherwise} operation using builder calls")).setDynamicOperands(BytecodeDSLBuiltins.voidableChild("try"), BytecodeDSLBuiltins.voidableChild("catch"));
        m.finallyHandlerOperation = m.operation(OperationModel.OperationKind.FINALLY_HANDLER, "FinallyHandler", "FinallyHandler is an internal operation that has no stack effect. All finally generators execute within a FinallyHandler operation.\nExecuting the generator emits new operations, but these operations should not affect the outer operation's child count/value validation.\nTo accomplish this, FinallyHandler \"hides\" these operations by popping any produced values and omitting calls to beforeChild/afterChild.\nWhen walking the operation stack, we skip over operations above finallyOperationSp since they do not logically enclose the handler.\n").setVoid(true).setVariadic(true).setDynamicOperands(BytecodeDSLBuiltins.transparentOperationChild()).setOperationBeginArguments(new OperationModel.OperationArgument(context.getType(Short.TYPE), OperationModel.OperationArgument.Encoding.SHORT, "finallyOperationSp", "the operation stack pointer for the finally operation that created the FinallyHandler")).setInternal();
        m.operation(OperationModel.OperationKind.LABEL, "Label", "Label assigns {@code label} the current location in the bytecode (so that it can be used as the target of a Branch).\nThis is a void operation.\n<p>\nEach {@link BytecodeLabel} must be defined exactly once. It should be defined directly inside the same operation in which it is created (using {@link #createLabel}).\n").setVoid(true).setOperationBeginArguments(new OperationModel.OperationArgument(types.BytecodeLabel, OperationModel.OperationArgument.Encoding.LABEL, "label", "the label to define"));
        m.operation(OperationModel.OperationKind.BRANCH, "Branch", "Branch performs a branch to {@code label}.\nThis operation only supports unconditional forward branches; use IfThen and While to perform other kinds of branches.\n").setVoid(true).setOperationBeginArguments(new OperationModel.OperationArgument(types.BytecodeLabel, OperationModel.OperationArgument.Encoding.LABEL, "label", "the label to branch to")).setInstruction(m.branchInstruction);
        m.loadConstantOperation = m.operation(OperationModel.OperationKind.LOAD_CONSTANT, "LoadConstant", "LoadConstant produces {@code constant}. The constant should be immutable, since it may be shared across multiple LoadConstant operations.\n").setOperationBeginArguments(new OperationModel.OperationArgument(context.getType(Object.class), OperationModel.OperationArgument.Encoding.OBJECT, "constant", "the constant value to load")).setInstruction(m.loadConstantInstruction);
        m.loadNullOperation = m.operation(OperationModel.OperationKind.LOAD_NULL, "LoadNull", "LoadNull produces a {@code null} value.\n").setInstruction(m.loadNullInstruction);
        m.operation(OperationModel.OperationKind.LOAD_ARGUMENT, "LoadArgument", "LoadArgument reads the argument at {@code index} from the frame.\nThrows {@link IndexOutOfBoundsException} if the index is out of bounds.\n").setOperationBeginArguments(new OperationModel.OperationArgument(context.getType(Integer.TYPE), OperationModel.OperationArgument.Encoding.INTEGER, "index", "the index of the argument to load (must fit into a short)")).setInstruction(m.instruction(InstructionModel.InstructionKind.LOAD_ARGUMENT, "load.argument", m.signature(Object.class, new Class[0])).addImmediate(InstructionModel.ImmediateKind.SHORT, "index"));
        m.operation(OperationModel.OperationKind.LOAD_EXCEPTION, "LoadException", "LoadException reads the current exception from the frame.\nThis operation is only permitted inside the {@code catch} operation of TryCatch and TryCatchOtherwise operations.\n").setInstruction(m.instruction(InstructionModel.InstructionKind.LOAD_EXCEPTION, "load.exception", m.signature(Object.class, new Class[0])).addImmediate(InstructionModel.ImmediateKind.STACK_POINTER, "exception_sp"));
        m.loadLocalOperation = m.operation(OperationModel.OperationKind.LOAD_LOCAL, "LoadLocal", String.format("LoadLocal reads {@code local} from the current frame.\nIf a value has not been written to the local, LoadLocal %s.\n", BytecodeDSLBuiltins.loadLocalUndefinedBehaviour(m))).setOperationBeginArguments(new OperationModel.OperationArgument(types.BytecodeLocal, OperationModel.OperationArgument.Encoding.LOCAL, "local", "the local to load")).setInstruction(m.instruction(InstructionModel.InstructionKind.LOAD_LOCAL, "load.local", m.signature(Object.class, new Class[0])).addImmediate(InstructionModel.ImmediateKind.FRAME_INDEX, "frame_index"));
        m.storeLocalInstruction = m.instruction(InstructionModel.InstructionKind.STORE_LOCAL, "store.local", m.signature(Void.TYPE, Object.class)).addImmediate(InstructionModel.ImmediateKind.FRAME_INDEX, "frame_index");
        m.storeLocalOperation = m.operation(OperationModel.OperationKind.STORE_LOCAL, "StoreLocal", "StoreLocal writes the value produced by {@code value} into the {@code local} in the current frame.\n").setVoid(true).setOperationBeginArguments(new OperationModel.OperationArgument(types.BytecodeLocal, OperationModel.OperationArgument.Encoding.LOCAL, "local", "the local to store to")).setDynamicOperands(BytecodeDSLBuiltins.child("value")).setInstruction(m.storeLocalInstruction);
        if (m.enableMaterializedLocalAccesses) {
            m.loadLocalMaterializedOperation = m.operation(OperationModel.OperationKind.LOAD_LOCAL_MATERIALIZED, "LoadLocalMaterialized", String.format("LoadLocalMaterialized reads {@code local} from the materialized frame produced by {@code frame}.\nThis operation can be used to read a local defined by the current root or an enclosing root.\nThe local must belong to the materialized frame. It should also be in scope, otherwise the operation may produce unexpected values.\nThe interpreter will validate the scope if the interpreter is configured to {@link %s#storeBytecodeIndexInFrame store the bytecode index in the frame}.\n", GENERATE_BYTECODE)).setOperationBeginArguments(new OperationModel.OperationArgument(types.BytecodeLocal, OperationModel.OperationArgument.Encoding.LOCAL, "local", "the local to load")).setDynamicOperands(BytecodeDSLBuiltins.child("frame")).setInstruction(m.instruction(InstructionModel.InstructionKind.LOAD_LOCAL_MATERIALIZED, "load.local.mat", m.signature(Object.class, Object.class)).addImmediate(InstructionModel.ImmediateKind.FRAME_INDEX, "frame_index").addImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT, "root_index"));
            m.storeLocalMaterializedOperation = m.operation(OperationModel.OperationKind.STORE_LOCAL_MATERIALIZED, "StoreLocalMaterialized", String.format("StoreLocalMaterialized writes the value produced by {@code value} into {@code local} in the materialized frame produced by {@code frame}.\nThis operation can be used to store locals defined by the current root or an enclosing root.\nThe local must belong to the materialized frame. It should also be in scope, otherwise the operation may produce unexpected values.\nThe interpreter will validate the scope if the interpreter is configured to {@link %s#storeBytecodeIndexInFrame store the bytecode index in the frame}.\n", GENERATE_BYTECODE)).setVoid(true).setOperationBeginArguments(new OperationModel.OperationArgument(types.BytecodeLocal, OperationModel.OperationArgument.Encoding.LOCAL, "local", "the local to store to")).setDynamicOperands(BytecodeDSLBuiltins.child("frame"), BytecodeDSLBuiltins.child("value")).setInstruction(m.instruction(InstructionModel.InstructionKind.STORE_LOCAL_MATERIALIZED, "store.local.mat", m.signature(Void.TYPE, Object.class, Object.class)).addImmediate(InstructionModel.ImmediateKind.FRAME_INDEX, "frame_index").addImmediate(InstructionModel.ImmediateKind.LOCAL_ROOT, "root_index"));
        }
        m.returnOperation = m.operation(OperationModel.OperationKind.RETURN, "Return", "Return returns the value produced by {@code result}.").setVoid(true).setDynamicOperands(BytecodeDSLBuiltins.child("result")).setInstruction(m.returnInstruction);
        if (m.enableYield) {
            m.yieldInstruction = m.instruction(InstructionModel.InstructionKind.YIELD, "yield", m.signature(Void.TYPE, Object.class)).addImmediate(InstructionModel.ImmediateKind.CONSTANT, "location");
            m.operation(OperationModel.OperationKind.YIELD, "Yield", "Yield executes {@code value} and suspends execution at the given location, returning a {@link com.oracle.truffle.api.bytecode.ContinuationResult} containing the result.\nThe caller can resume the continuation, which continues execution after the Yield. When resuming, the caller passes a value that becomes the value produced by the Yield.\n").setDynamicOperands(BytecodeDSLBuiltins.child("value")).setInstruction(m.yieldInstruction);
        }
        m.sourceOperation = m.operation(OperationModel.OperationKind.SOURCE, "Source", "Source associates the children in its {@code body} with {@code source}. Together with SourceSection, it encodes source locations for operations in the program.\n").setTransparent(true).setVariadic(true).setOperationBeginArguments(new OperationModel.OperationArgument(types.Source, OperationModel.OperationArgument.Encoding.OBJECT, "source", "the source object to associate with the enclosed operations")).setDynamicOperands(BytecodeDSLBuiltins.transparentOperationChild());
        m.sourceSectionOperation = m.operation(OperationModel.OperationKind.SOURCE_SECTION, "SourceSection", "SourceSection associates the children in its {@code body} with the source section with the given character {@code index} and {@code length}.\nTo specify an {@link Source#createUnavailableSection() unavailable source section}, provide {@code -1} for both arguments.\nThis operation must be (directly or indirectly) enclosed within a Source operation.\n").setTransparent(true).setVariadic(true).setOperationBeginArguments(new OperationModel.OperationArgument(context.getType(Integer.TYPE), OperationModel.OperationArgument.Encoding.INTEGER, "index", "the starting character index of the source section, or -1 if the section is unavailable"), new OperationModel.OperationArgument(context.getType(Integer.TYPE), OperationModel.OperationArgument.Encoding.INTEGER, "length", "the length (in characters) of the source section, or -1 if the section is unavailable")).setDynamicOperands(BytecodeDSLBuiltins.transparentOperationChild());
        if (m.enableTagInstrumentation) {
            m.tagEnterInstruction = m.instruction(InstructionModel.InstructionKind.TAG_ENTER, "tag.enter", m.signature(Void.TYPE, new Class[0]));
            m.tagEnterInstruction.addImmediate(InstructionModel.ImmediateKind.TAG_NODE, "tag");
            m.tagLeaveValueInstruction = m.instruction(InstructionModel.InstructionKind.TAG_LEAVE, "tag.leave", m.signature(Object.class, Object.class));
            m.tagLeaveValueInstruction.addImmediate(InstructionModel.ImmediateKind.TAG_NODE, "tag");
            m.tagLeaveVoidInstruction = m.instruction(InstructionModel.InstructionKind.TAG_LEAVE_VOID, "tag.leaveVoid", m.signature(Object.class, new Class[0]));
            m.tagLeaveVoidInstruction.addImmediate(InstructionModel.ImmediateKind.TAG_NODE, "tag");
            m.tagOperation = m.operation(OperationModel.OperationKind.TAG, "Tag", "Tag associates {@code tagged} with the given tags.\nWhen the {@link BytecodeConfig} includes one or more of the given tags, the interpreter will automatically invoke instrumentation probes when entering/leaving {@code tagged}.\n").setTransparent(true).setOperationBeginArgumentVarArgs(true).setOperationBeginArguments(new OperationModel.OperationArgument(new CodeTypeMirror.ArrayCodeTypeMirror(context.getDeclaredType(Class.class)), OperationModel.OperationArgument.Encoding.TAGS, "newTags", "the tags to associate with the enclosed operations")).setDynamicOperands(BytecodeDSLBuiltins.voidableChild("tagged")).setOperationEndArguments(new OperationModel.OperationArgument(new CodeTypeMirror.ArrayCodeTypeMirror(context.getDeclaredType(Class.class)), OperationModel.OperationArgument.Encoding.TAGS, "newTags", "the tags to associate with the enclosed operations")).setInstruction(m.tagLeaveValueInstruction);
            if (m.enableYield) {
                m.tagYieldInstruction = m.instruction(InstructionModel.InstructionKind.TAG_YIELD, "tag.yield", m.signature(Object.class, Object.class));
                m.tagYieldInstruction.addImmediate(InstructionModel.ImmediateKind.TAG_NODE, "tag");
                m.tagResumeInstruction = m.instruction(InstructionModel.InstructionKind.TAG_RESUME, "tag.resume", m.signature(Void.TYPE, new Class[0]));
                m.tagResumeInstruction.addImmediate(InstructionModel.ImmediateKind.TAG_NODE, "tag");
            }
        }
        m.loadVariadicInstruction = new InstructionModel[9];
        for (int i = 0; i <= 8; ++i) {
            m.loadVariadicInstruction[i] = m.instruction(InstructionModel.InstructionKind.LOAD_VARIADIC, "load.variadic_" + i, m.signature(Void.TYPE, Object.class));
            m.loadVariadicInstruction[i].variadicPopCount = i;
        }
        m.mergeVariadicInstruction = m.instruction(InstructionModel.InstructionKind.MERGE_VARIADIC, "merge.variadic", m.signature(Object.class, Object.class));
        m.storeNullInstruction = m.instruction(InstructionModel.InstructionKind.STORE_NULL, "constant_null", m.signature(Object.class, new Class[0]));
        m.clearLocalInstruction = m.instruction(InstructionModel.InstructionKind.CLEAR_LOCAL, "clear.local", m.signature(Void.TYPE, new Class[0]));
        m.clearLocalInstruction.addImmediate(InstructionModel.ImmediateKind.FRAME_INDEX, "frame_index");
        m.sortInstructionsByKind();
    }

    private static String rootOperationJavadoc(BytecodeDSLModel m) {
        String rootClass = m.templateType.getSimpleName().toString();
        String innerRootBehaviour = m.enableMaterializedLocalAccesses ? "but the inner root <i>can</i> manipulate the outer root's locals\nusing materialized local accesses if the outer frame is provided to it" : String.format("and it does not have access to the outer root's locals (if it needs\naccess to outer locals, consider {@link %s#enableMaterializedLocalAccesses enabling materialized local accesses})", GENERATE_BYTECODE);
        return String.format("Each Root operation defines one function (i.e., a {@link %s}).\nIt takes one or more children, which define the body of the function that executes when it is invoked.\nIf control falls through to the end of the body without returning, instructions are inserted to implicitly return {@code null}.\n<p>\nA root operation is typically the outermost one. That is, a {@link BytecodeParser} should invoke {@link #beginRoot} first before using other builder methods to generate bytecode.\nThe parser should invoke {@link #endRoot} to finish generating the {@link %s}.\n<p>\nA parser *can* nest this operation in Source and SourceSection operations in order to provide a {@link Node#getSourceSection source location} for the entire root node.\nThe result of {@link Node#getSourceSection} on the generated root is undefined if there is no enclosing SourceSection operation.\n<p>\nThis method can also be called inside of another root operation. Bytecode generation for the outer root node suspends until generation for the inner root node finishes.\nThe inner root node is not lexically nested in the outer (you can invoke the inner root node independently), %s.\nMultiple root nodes can be obtained from the {@link BytecodeNodes} object in the order of their {@link #beginRoot} calls.\n", rootClass, rootClass, innerRootBehaviour);
    }

    private static String loadLocalUndefinedBehaviour(BytecodeDSLModel m) {
        if (m.defaultLocalValue == null || m.defaultLocalValue.isEmpty()) {
            return "throws a {@link com.oracle.truffle.api.frame.FrameSlotTypeException}";
        }
        return String.format("produces the default local value (%s)", m.defaultLocalValue);
    }

    private static DynamicOperandModel child(String name) {
        return new DynamicOperandModel(List.of(name), false, false);
    }

    private static DynamicOperandModel voidableChild(String name) {
        return new DynamicOperandModel(List.of(name), true, false);
    }

    private static DynamicOperandModel transparentOperationChild() {
        return new DynamicOperandModel(List.of("body"), true, true);
    }
}

