/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImpl;
import java.util.List;

public class DwarfFrameSectionImplX86_64
extends DwarfFrameSectionImpl {
    private static final int CFA_RSP_IDX = 7;
    private static final int CFA_RIP_IDX = 16;

    public DwarfFrameSectionImplX86_64(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public int getReturnPCIdx() {
        return 16;
    }

    @Override
    public int getSPIdx() {
        return 7;
    }

    @Override
    public int writeInitialInstructions(byte[] buffer, int p) {
        int pos = p;
        pos = this.writeDefCFA(7, 8, buffer, pos);
        pos = this.writeOffset(16, 1, buffer, pos);
        return pos;
    }

    @Override
    protected int writeFDEs(int frameSize, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, byte[] buffer, int p) {
        int pos = p;
        int currentOffset = 0;
        for (DebugInfoProvider.DebugFrameSizeChange debugFrameSizeInfo : frameSizeInfos) {
            int advance = debugFrameSizeInfo.getOffset() - currentOffset;
            currentOffset += advance;
            pos = this.writeAdvanceLoc(advance, buffer, pos);
            if (debugFrameSizeInfo.getType() == DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND) {
                pos = this.writeDefCFAOffset(frameSize, buffer, pos);
                continue;
            }
            pos = this.writeDefCFAOffset(8, buffer, pos);
        }
        return pos;
    }
}

