/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.ResolvedJavaType;

public class ArrayTypeEntry
extends StructureTypeEntry {
    private TypeEntry elementType;
    private int baseSize;
    private int lengthOffset;

    public ArrayTypeEntry(String typeName, int size) {
        super(typeName, size);
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ARRAY;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        super.addDebugInfo(debugInfoBase, debugTypeInfo, debugContext);
        DebugInfoProvider.DebugArrayTypeInfo debugArrayTypeInfo = (DebugInfoProvider.DebugArrayTypeInfo)debugTypeInfo;
        ResolvedJavaType eltType = debugArrayTypeInfo.elementType();
        this.elementType = debugInfoBase.lookupTypeEntry(eltType);
        this.baseSize = debugArrayTypeInfo.baseSize();
        this.lengthOffset = debugArrayTypeInfo.lengthOffset();
        debugArrayTypeInfo.fieldInfoProvider().forEach(debugFieldInfo -> this.processField((DebugInfoProvider.DebugFieldInfo)debugFieldInfo, debugInfoBase, debugContext));
        if (debugContext.isLogEnabled()) {
            debugContext.log("typename %s element type %s base size %d length offset %d%n", (Object)this.typeName, (Object)this.elementType.getTypeName(), (Object)this.baseSize, (Object)this.lengthOffset);
        }
    }

    public TypeEntry getElementType() {
        return this.elementType;
    }

    public String getLoaderId() {
        TypeEntry type = this.elementType;
        while (type.isArray()) {
            type = ((ArrayTypeEntry)type).elementType;
        }
        if (type.isClass()) {
            return ((ClassEntry)type).getLoaderId();
        }
        return "";
    }
}

