/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.common.option;

import com.oracle.svm.common.option.CommonOptions;
import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.common.option.UnsupportedOptionClassException;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.StringUtil;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import jdk.graal.compiler.options.EnumMultiOptionKey;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsParser;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public class CommonOptionParser {
    public static final String HOSTED_OPTION_PREFIX = "-H:";
    public static final String RUNTIME_OPTION_PREFIX = "-R:";
    public static final int PRINT_OPTION_INDENTATION = 2;
    public static final int PRINT_OPTION_WIDTH = 45;
    public static final int PRINT_OPTION_WRAP_WIDTH = 120;

    public static void collectOptions(ServiceLoader<OptionDescriptors> optionDescriptors, Consumer<OptionDescriptor> optionDescriptorConsumer) {
        for (OptionDescriptors optionDescriptor : optionDescriptors) {
            for (OptionDescriptor descriptor : optionDescriptor) {
                optionDescriptorConsumer.accept(descriptor);
            }
        }
    }

    public static OptionParseResult parseOption(EconomicMap<String, OptionDescriptor> options, Predicate<OptionKey<?>> isHosted, String option, EconomicMap<OptionKey<?>, Object> valuesMap, String optionPrefix, BooleanOptionFormat booleanOptionFormat) throws UnsupportedOptionClassException {
        boolean hostedOption;
        OptionKey optionKey;
        LocatableOption current;
        String optionName;
        Object value;
        block25: {
            Class<?> optionType;
            if (option.length() == 0) {
                return OptionParseResult.error("Option name must be specified");
            }
            value = null;
            String valueString = null;
            char first = option.charAt(0);
            int eqIndex = option.indexOf(61);
            if (first == '+' || first == '-') {
                if (eqIndex != -1) {
                    return OptionParseResult.error("Cannot mix +/- with <name>=<value> format: '" + optionPrefix + option + "'");
                }
                optionName = option.substring(1);
                if (booleanOptionFormat == BooleanOptionFormat.NAME_VALUE) {
                    return OptionParseResult.error("Option " + String.valueOf(LocatableOption.from(optionName)) + " must use <name>=<value> format, not +/- prefix");
                }
                value = first == '+';
            } else if (eqIndex == -1) {
                optionName = option;
                valueString = null;
            } else {
                optionName = option.substring(0, eqIndex);
                valueString = option.substring(eqIndex + 1);
            }
            current = LocatableOption.from(optionName);
            OptionDescriptor desc = (OptionDescriptor)options.get((Object)current.name);
            if (desc == null && value != null && eqIndex != -1) {
                optionName = option.substring(1, eqIndex);
                current = LocatableOption.from(optionName);
                desc = (OptionDescriptor)options.get((Object)current.name);
            }
            optionName = current.name;
            if (desc == null) {
                ArrayList matches = new ArrayList();
                OptionsParser.collectFuzzyMatches((Iterable)options.getValues(), (String)optionName, matches);
                StringBuilder msg = new StringBuilder("Could not find option ").append(current);
                if (!matches.isEmpty()) {
                    msg.append(". Did you mean one of these:");
                    for (OptionDescriptor match : matches) {
                        msg.append(' ').append(match.getName());
                    }
                }
                msg.append(". Use ").append(optionPrefix).append(CommonOptions.PrintFlags.getName()).append("= to list all available options.");
                return OptionParseResult.optionUnrecognizedError(msg.toString());
            }
            optionKey = desc.getOptionKey();
            hostedOption = isHosted.test(optionKey);
            Class<?> optionValueType = CommonOptionParser.getMultiOptionValueElementType(optionKey);
            Class<?> clazz = optionType = hostedOption && optionValueType != null ? optionValueType : desc.getOptionValueType();
            if (value == null) {
                if (optionType == Boolean.class && booleanOptionFormat == BooleanOptionFormat.PLUS_MINUS) {
                    return OptionParseResult.error("Boolean option " + String.valueOf(current) + " must have +/- prefix");
                }
                if (valueString == null) {
                    return OptionParseResult.error("Missing value for option " + String.valueOf(current));
                }
                try {
                    value = CommonOptionParser.parseValue(optionType, optionKey, current, valueString);
                    if (value instanceof OptionParseResult) {
                        return (OptionParseResult)value;
                    }
                    break block25;
                }
                catch (NumberFormatException ex) {
                    return OptionParseResult.error("Invalid value for option " + String.valueOf(current) + ": '" + valueString + "' is not a valid number");
                }
            }
            if (optionType != Boolean.class) {
                return OptionParseResult.error("Non-boolean option " + String.valueOf(current) + " can not use +/- prefix. Use '" + current.name + "=<value>' format");
            }
        }
        optionKey.update(valuesMap, hostedOption ? LocatableOption.value(value, current.origin) : value);
        if (CommonOptions.PrintFlags.getName().equals(optionName)) {
            EnumSet<OptionType> selectedOptionTypes;
            String optionValue = (String)value;
            if (optionValue.isEmpty()) {
                selectedOptionTypes = EnumSet.allOf(OptionType.class);
            } else {
                selectedOptionTypes = EnumSet.noneOf(OptionType.class);
                String enumString = null;
                try {
                    String[] enumStrings;
                    String[] stringArray = enumStrings = StringUtil.split(optionValue, ",");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string;
                        enumString = string = stringArray[i];
                        selectedOptionTypes.add(OptionType.valueOf((String)enumString));
                    }
                }
                catch (IllegalArgumentException e) {
                    String possibleValues = StringUtil.joinSingleQuoted(OptionType.values());
                    return OptionParseResult.error("Invalid value for option " + String.valueOf(current) + ". '" + enumString + "' is not one of " + possibleValues + ".");
                }
            }
            return OptionParseResult.printFlags(selectedOptionTypes);
        }
        if (CommonOptions.PrintFlagsWithExtraHelp.getName().equals(optionName)) {
            String optionValue = (String)value;
            String[] optionNames = StringUtil.split(optionValue, ",");
            HashSet<String> selectedOptionNames = new HashSet<String>(Arrays.asList(optionNames));
            return OptionParseResult.printFlagsWithExtraHelp(selectedOptionNames);
        }
        return OptionParseResult.correct(optionKey);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object parseValue(Class<?> optionType, OptionKey<?> optionKey, LocatableOption option, String valueString) throws NumberFormatException, UnsupportedOptionClassException {
        void var4_17;
        if (optionType == Integer.class) {
            long longValue = CommonOptionParser.parseLong(valueString);
            if ((long)((int)longValue) != longValue) {
                return OptionParseResult.error("Wrong value for option " + String.valueOf(option) + ": '" + valueString + "' is not a valid number");
            }
            Integer n = (int)longValue;
            return var4_17;
        } else if (optionType == Long.class) {
            Long l = CommonOptionParser.parseLong(valueString);
            return var4_17;
        } else if (optionType == Double.class) {
            Double d = CommonOptionParser.parseDouble(valueString);
            return var4_17;
        } else if (optionType == Boolean.class) {
            if (valueString.equals("true")) {
                Boolean bl = true;
                return var4_17;
            } else {
                if (!valueString.equals("false")) return OptionParseResult.error("Boolean option " + String.valueOf(option) + " must have value 'true' or 'false'");
                Boolean bl = false;
            }
            return var4_17;
        } else if (optionType == String.class || optionType == Path.class) {
            String[] valueStrings;
            Object defaultValue = optionKey.getDefaultValue();
            String delimiter = defaultValue instanceof MultiOptionValue ? ((MultiOptionValue)defaultValue).getDelimiter() : "";
            boolean multipleValues = !delimiter.isEmpty() && valueString.contains(delimiter);
            String[] stringArray = valueStrings = multipleValues ? StringUtil.split(valueString, delimiter) : null;
            if (optionType == String.class) {
                Object object = valueStrings != null ? valueStrings : valueString;
                return var4_17;
            } else {
                assert (optionType == Path.class);
                if (valueStrings != null) {
                    Path[] valuePaths = new Path[valueStrings.length];
                    for (int i = 0; i < valueStrings.length; ++i) {
                        valuePaths[i] = Path.of(valueStrings[i], new String[0]);
                    }
                    Path[] pathArray = valuePaths;
                    return var4_17;
                } else {
                    Path path = Path.of(valueString, new String[0]);
                }
            }
            return var4_17;
        } else if (optionType.isEnum()) {
            Enum enum_ = Enum.valueOf(optionType.asSubclass(Enum.class), valueString);
            return var4_17;
        } else {
            if (optionType != EconomicSet.class) throw new UnsupportedOptionClassException(String.valueOf(option) + " uses unsupported option value class: " + ClassUtil.getUnqualifiedName(optionType));
            Object object = ((EnumMultiOptionKey)optionKey).valueOf(valueString);
        }
        return var4_17;
    }

    private static Class<?> getMultiOptionValueElementType(OptionKey<?> optionKey) {
        Object defaultValue = optionKey.getDefaultValue();
        if (defaultValue instanceof MultiOptionValue) {
            return ((MultiOptionValue)defaultValue).getValueType();
        }
        return null;
    }

    public static long parseLong(String v) {
        String valueString = v.trim();
        long scale = 1L;
        if (valueString.endsWith("k") || valueString.endsWith("K")) {
            scale = 1024L;
        } else if (valueString.endsWith("m") || valueString.endsWith("M")) {
            scale = 0x100000L;
        } else if (valueString.endsWith("g") || valueString.endsWith("G")) {
            scale = 0x40000000L;
        } else if (valueString.endsWith("t") || valueString.endsWith("T")) {
            scale = 0x10000000000L;
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public static double parseDouble(String v) {
        String valueString = v.trim();
        int dotPos = valueString.indexOf(46);
        if (dotPos == -1) {
            return CommonOptionParser.parseLong(valueString);
        }
        String beforeDot = valueString.substring(0, dotPos);
        String afterDot = valueString.substring(dotPos + 1);
        double sign = 1.0;
        if (beforeDot.startsWith("-")) {
            sign = -1.0;
            beforeDot = beforeDot.substring(1);
        } else if (beforeDot.startsWith("+")) {
            beforeDot = beforeDot.substring(1);
        }
        if (beforeDot.startsWith("-") || beforeDot.startsWith("+") || afterDot.startsWith("-") || afterDot.startsWith("+") || beforeDot.length() == 0 && afterDot.length() == 0) {
            throw new NumberFormatException(v);
        }
        double integral = 0.0;
        if (beforeDot.length() > 0) {
            integral = Long.parseLong(beforeDot);
        }
        double fraction = 0.0;
        if (afterDot.length() > 0) {
            fraction = (double)Long.parseLong(afterDot) * Math.pow(10.0, -afterDot.length());
        }
        return sign * (integral + fraction);
    }

    private static String spaces(int length) {
        return CommonOptionParser.stringFilledWith(length, ' ');
    }

    private static String stringFilledWith(int length, char fillValue) {
        return new String(new char[length]).replace('\u0000', fillValue);
    }

    private static String wrap(String s, int width) {
        StringBuilder sb = new StringBuilder(s);
        int cursor = 0;
        while (cursor + width < sb.length()) {
            int i = sb.lastIndexOf(" ", cursor + width);
            if (i == -1 || i < cursor) {
                i = sb.indexOf(" ", cursor + width);
            }
            if (i == -1) break;
            sb.replace(i, i + 1, System.lineSeparator());
            cursor = i;
        }
        return sb.toString();
    }

    private static void printOption(PrintStream out, String option, String description, boolean verbose, int wrap) {
        CommonOptionParser.printOption(out::println, option, description, verbose, 2, 45, wrap);
    }

    public static void printOption(Consumer<String> println, String option, String description, boolean verbose, int indentation, int optionWidth, int wrapWidth) {
        Object descLinePrefix;
        String indent = CommonOptionParser.spaces(indentation);
        String desc = description != null ? description : "";
        desc = wrapWidth > 0 ? CommonOptionParser.wrap(desc, wrapWidth) : desc;
        String nl = System.lineSeparator();
        String[] descLines = StringUtil.split(desc, nl);
        if (verbose) {
            descLinePrefix = "";
            String border = CommonOptionParser.stringFilledWith(indentation + option.length() + indentation, '=');
            println.accept(border);
            println.accept(indent + option);
            println.accept(border);
            println.accept(descLines[0]);
        } else {
            descLinePrefix = indent + CommonOptionParser.spaces(optionWidth);
            if (option.length() >= optionWidth && description != null) {
                println.accept(indent + option + nl + (String)descLinePrefix + descLines[0]);
            } else {
                println.accept(indent + option + CommonOptionParser.spaces(optionWidth - option.length()) + descLines[0]);
            }
        }
        for (int i = 1; i < descLines.length; ++i) {
            println.accept((String)descLinePrefix + descLines[i]);
        }
        if (verbose) {
            println.accept("");
        }
    }

    public static void printFlags(Predicate<OptionDescriptor> filter, EconomicMap<String, OptionDescriptor> options, String prefix, PrintStream out, boolean verbose) {
        ArrayList<OptionDescriptor> sortedDescriptors = new ArrayList<OptionDescriptor>();
        for (OptionDescriptor option : options.getValues()) {
            if (!filter.test(option)) continue;
            sortedDescriptors.add(option);
        }
        sortedDescriptors.sort(Comparator.comparing(OptionDescriptor::getName));
        for (OptionDescriptor descriptor : sortedDescriptors) {
            int wrapWidth;
            Object helpMsg = descriptor.getHelp();
            int helpLen = ((String)helpMsg).length();
            if (helpLen > 0 && ((String)helpMsg).charAt(helpLen - 1) != '.') {
                helpMsg = (String)helpMsg + ".";
            }
            boolean stringifiedArrayValue = false;
            Object defaultValue = descriptor.getOptionKey().getDefaultValue();
            if (defaultValue != null && defaultValue.getClass().isArray()) {
                Object[] defaultValues = (Object[])defaultValue;
                if (defaultValues.length == 1) {
                    defaultValue = defaultValues[0];
                } else {
                    ArrayList<CallSite> stringList = new ArrayList<CallSite>();
                    String optionPrefix = prefix + descriptor.getName() + "=";
                    for (Object rawValue : defaultValues) {
                        Object value = rawValue instanceof String ? "\"" + String.valueOf(rawValue) + "\"" : String.valueOf(rawValue);
                        stringList.add((CallSite)((Object)(optionPrefix + (String)value)));
                    }
                    if (helpLen != 0) {
                        helpMsg = (String)helpMsg + " ";
                    }
                    helpMsg = (String)helpMsg + "Default: ";
                    helpMsg = stringList.isEmpty() ? (String)helpMsg + "None" : (String)helpMsg + String.join((CharSequence)" ", stringList);
                    stringifiedArrayValue = true;
                }
            }
            Object verboseHelp = "";
            if (!descriptor.getExtraHelp().isEmpty()) {
                verboseHelp = verbose ? System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), descriptor.getExtraHelp()) : " [Extra help available]";
            }
            int n = wrapWidth = verbose ? 0 : 120;
            if (descriptor.getOptionValueType() == Boolean.class) {
                Boolean val = (Boolean)defaultValue;
                if (helpLen != 0) {
                    helpMsg = (String)helpMsg + " ";
                }
                if (val != null) {
                    helpMsg = val != false ? (String)helpMsg + "Default: + (enabled)." : (String)helpMsg + "Default: - (disabled).";
                }
                CommonOptionParser.printOption(out, prefix + "\u00b1" + descriptor.getName(), (String)helpMsg + (String)verboseHelp, verbose, wrapWidth);
                continue;
            }
            if (defaultValue == null) {
                if (helpLen != 0) {
                    helpMsg = (String)helpMsg + " ";
                }
                helpMsg = (String)helpMsg + "Default: None";
            }
            helpMsg = (String)helpMsg + (String)verboseHelp;
            if (stringifiedArrayValue || defaultValue == null) {
                CommonOptionParser.printOption(out, prefix + descriptor.getName() + "=...", (String)helpMsg, verbose, wrapWidth);
                continue;
            }
            if (defaultValue instanceof String) {
                defaultValue = "\"" + String.valueOf(defaultValue) + "\"";
            }
            CommonOptionParser.printOption(out, prefix + descriptor.getName() + "=" + String.valueOf(defaultValue), (String)helpMsg, verbose, wrapWidth);
        }
    }

    public static final class OptionParseResult {
        private final EnumSet<OptionType> printFlags;
        private final Set<String> optionNameFilter;
        private final String error;
        private final OptionKey<?> optionKey;
        private final boolean optionUnrecognized;
        private static final String EXTRA_HELP_OPTIONS_WILDCARD = "*";

        OptionParseResult(EnumSet<OptionType> printFlags, String error, Set<String> optionNameFilter, OptionKey<?> optionKey, boolean optionUnrecognized) {
            this.printFlags = printFlags;
            this.error = error;
            this.optionNameFilter = optionNameFilter;
            this.optionKey = optionKey;
            this.optionUnrecognized = optionUnrecognized;
        }

        private OptionParseResult(EnumSet<OptionType> printFlags, String error, OptionKey<?> optionKey) {
            this(printFlags, error, new HashSet<String>(), optionKey, false);
        }

        static OptionParseResult error(String message) {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), message, null);
        }

        static OptionParseResult optionUnrecognizedError(String message) {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), message, new HashSet<String>(), null, true);
        }

        static OptionParseResult correct(OptionKey<?> optionKey) {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), null, optionKey);
        }

        static OptionParseResult printFlags(EnumSet<OptionType> selectedOptionTypes) {
            return new OptionParseResult(selectedOptionTypes, null, null);
        }

        static OptionParseResult printFlagsWithExtraHelp(Set<String> optionNameFilter) {
            Set<String> optionNames = optionNameFilter;
            if (optionNames.contains(EXTRA_HELP_OPTIONS_WILDCARD)) {
                optionNames = new HashSet<String>();
                optionNames.add(EXTRA_HELP_OPTIONS_WILDCARD);
            }
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), null, optionNames, null, false);
        }

        public boolean printFlags() {
            return !this.printFlags.isEmpty();
        }

        public boolean printFlagsWithExtraHelp() {
            return !this.optionNameFilter.isEmpty();
        }

        public boolean isValid() {
            boolean result;
            boolean bl = result = this.optionKey != null;
            assert (result == (this.printFlags.isEmpty() && this.optionNameFilter.isEmpty() && this.error == null));
            return result;
        }

        public boolean optionUnrecognized() {
            return this.optionUnrecognized;
        }

        public String getError() {
            return this.error;
        }

        public OptionKey<?> getOptionKey() {
            return this.optionKey;
        }

        public boolean matchesFlags(OptionDescriptor d, boolean svmOption) {
            if (!this.printFlags.isEmpty()) {
                boolean showAll = this.printFlags.equals(EnumSet.allOf(OptionType.class));
                return showAll || svmOption && this.printFlags.contains(d.getOptionType());
            }
            if (!this.optionNameFilter.isEmpty()) {
                if (this.optionNameFilter.contains(EXTRA_HELP_OPTIONS_WILDCARD) && !d.getExtraHelp().isEmpty()) {
                    return true;
                }
                return this.optionNameFilter.contains(d.getName());
            }
            return false;
        }
    }

    public static enum BooleanOptionFormat {
        NAME_VALUE("<name>=<value>"),
        PLUS_MINUS("+/-<name>");

        private final String help;

        private BooleanOptionFormat(String help) {
            this.help = help;
        }

        public String toString() {
            return this.help;
        }
    }
}

