/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ClassUtil {
    public static final Path CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES_ROOT = Paths.get("/", new String[0]);
    public static final Set<Path> CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES = ClassUtil.getClassModulePathExcludeDirectories();

    private static Set<Path> getClassModulePathExcludeDirectories() {
        return Stream.of("dev", "sys", "proc", "etc", "var", "tmp", "boot", "lost+found").map(CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES_ROOT::resolve).collect(Collectors.toUnmodifiableSet());
    }

    public static String getUnqualifiedName(Class<?> clazz) {
        String name = clazz.getTypeName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static boolean isSameOrParentLoader(ClassLoader parent, ClassLoader child) {
        if (parent == null) {
            return true;
        }
        for (ClassLoader c = child; c != null; c = c.getParent()) {
            if (c != parent) continue;
            return true;
        }
        return false;
    }

    private ClassUtil() {
    }
}

