/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.utils.FileUtils;
import org.gitlab4j.api.utils.JacksonJson;
import org.gitlab4j.api.utils.JacksonJsonEnumHelper;

public class CommitAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Action action;
    private String filePath;
    private String previousPath;
    private String content;
    private Constants.Encoding encoding;
    private String lastCommitId;
    private Boolean executeFilemode;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public CommitAction withAction(Action action) {
        this.action = action;
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public CommitAction withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public String getPreviousPath() {
        return this.previousPath;
    }

    public void setPreviousPath(String previousPath) {
        this.previousPath = previousPath;
    }

    public CommitAction withPreviousPath(String previousPath) {
        this.previousPath = previousPath;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public CommitAction withContent(String content) {
        this.content = content;
        return this;
    }

    public Constants.Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Constants.Encoding encoding) {
        this.encoding = encoding;
    }

    public CommitAction withEncoding(Constants.Encoding encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getLastCommitId() {
        return this.lastCommitId;
    }

    public void setLastCommitId(String lastCommitId) {
        this.lastCommitId = lastCommitId;
    }

    public CommitAction withLastCommitId(String lastCommitId) {
        this.lastCommitId = lastCommitId;
        return this;
    }

    public Boolean getExecuteFilemode() {
        return this.executeFilemode;
    }

    public void setExecuteFilemode(Boolean executeFilemode) {
        this.executeFilemode = executeFilemode;
    }

    public CommitAction withExecuteFilemode(Boolean executeFilemode) {
        this.executeFilemode = executeFilemode;
        return this;
    }

    public CommitAction withFileContent(String filePath, Constants.Encoding encoding) throws GitLabApiException {
        File file = new File(filePath);
        return this.withFileContent(file, filePath, encoding);
    }

    public CommitAction withFileContent(File file, String filePath, Constants.Encoding encoding) throws GitLabApiException {
        this.encoding = encoding != null ? encoding : Constants.Encoding.TEXT;
        this.filePath = filePath;
        try {
            this.content = FileUtils.getFileContentAsString(file, this.encoding);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return this;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }

    public static enum Action {
        CREATE,
        DELETE,
        MOVE,
        UPDATE,
        CHMOD;

        private static JacksonJsonEnumHelper<Action> enumHelper;

        @JsonCreator
        public static Action forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<Action>(Action.class);
        }
    }
}

