/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Snippet;
import org.gitlab4j.api.models.Visibility;

public class SnippetsApi
extends AbstractApi {
    public SnippetsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Snippet> getSnippets(boolean downloadContent) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "snippets");
        List snippets = (List)response.readEntity((GenericType)new GenericType<List<Snippet>>(){});
        if (downloadContent) {
            for (Snippet snippet : snippets) {
                snippet.setContent(this.getSnippetContent(snippet.getId()));
            }
        }
        return snippets;
    }

    public List<Snippet> getSnippets() throws GitLabApiException {
        return this.getSnippets(this.getDefaultPerPage()).all();
    }

    public Pager<Snippet> getSnippets(int itemsPerPage) throws GitLabApiException {
        return new Pager<Snippet>(this, Snippet.class, itemsPerPage, null, "snippets");
    }

    public Stream<Snippet> getSnippetsStream() throws GitLabApiException {
        return this.getSnippets(this.getDefaultPerPage()).stream();
    }

    public String getSnippetContent(Long snippetId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "snippets", snippetId, "raw");
        return (String)response.readEntity(String.class);
    }

    public Snippet getSnippet(Long snippetId, boolean downloadContent) throws GitLabApiException {
        if (snippetId == null) {
            throw new RuntimeException("snippetId can't be null");
        }
        Response response = this.get(Response.Status.OK, null, "snippets", snippetId);
        Snippet snippet = (Snippet)response.readEntity(Snippet.class);
        if (downloadContent) {
            snippet.setContent(this.getSnippetContent(snippet.getId()));
        }
        return snippet;
    }

    public Snippet getSnippet(Long snippetId) throws GitLabApiException {
        return this.getSnippet(snippetId, false);
    }

    public Optional<Snippet> getOptionalSnippet(Long snippetId) {
        return this.getOptionalSnippet(snippetId, false);
    }

    public Optional<Snippet> getOptionalSnippet(Long snippetId, boolean downloadContent) {
        try {
            return Optional.ofNullable(this.getSnippet(snippetId, downloadContent));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Snippet createSnippet(String title, String fileName, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("file_name", fileName, true).withParam("content", content, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"snippets"});
        return (Snippet)response.readEntity(Snippet.class);
    }

    public Snippet createSnippet(String title, String fileName, String content, Visibility visibility, String description) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("file_name", fileName, true).withParam("content", content, true).withParam("visibility", (Object)visibility).withParam("description", description);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"snippets"});
        return (Snippet)response.readEntity(Snippet.class);
    }

    public void deleteSnippet(Long snippetId) throws GitLabApiException {
        if (snippetId == null) {
            throw new RuntimeException("snippetId can't be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "snippets", snippetId);
    }
}

