/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Duration;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.IssueFilter;
import org.gitlab4j.api.models.IssueLink;
import org.gitlab4j.api.models.IssuesStatistics;
import org.gitlab4j.api.models.IssuesStatisticsFilter;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Participant;
import org.gitlab4j.api.models.TimeStats;
import org.gitlab4j.api.utils.DurationUtils;

public class IssuesApi
extends AbstractApi
implements Constants {
    public IssuesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Issue> getIssues() throws GitLabApiException {
        return this.getIssues(this.getDefaultPerPage()).all();
    }

    public List<Issue> getIssues(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "issues");
    }

    public Stream<Issue> getIssuesStream() throws GitLabApiException {
        return this.getIssues(this.getDefaultPerPage()).stream();
    }

    public List<Issue> getIssues(Object projectIdOrPath) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Issue> getIssues(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
    }

    public Stream<Issue> getIssuesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getIssues(Object projectIdOrPath, IssueFilter filter) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, filter, this.getDefaultPerPage()).all();
    }

    public List<Issue> getIssues(Object projectIdOrPath, IssueFilter filter, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(Object projectIdOrPath, IssueFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
    }

    public Stream<Issue> getIssuesStream(Object projectIdOrPath, IssueFilter filter) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getIssues(IssueFilter filter) throws GitLabApiException {
        return this.getIssues(filter, this.getDefaultPerPage()).all();
    }

    public List<Issue> getIssues(IssueFilter filter, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(IssueFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "issues");
    }

    public Stream<Issue> getIssuesStream(IssueFilter filter) throws GitLabApiException {
        return this.getIssues(filter, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getGroupIssues(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, null, this.getDefaultPerPage()).all();
    }

    public Pager<Issue> getGroupIssues(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, null, itemsPerPage);
    }

    public Stream<Issue> getGroupIssuesStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, null, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getGroupIssues(Object groupIdOrPath, IssueFilter filter) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, filter, this.getDefaultPerPage()).all();
    }

    public Pager<Issue> getGroupIssues(Object groupIdOrPath, IssueFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter != null ? filter.getQueryParams() : new GitLabApiForm();
        return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "issues");
    }

    public Stream<Issue> getGroupIssuesStream(Object groupIdOrPath, IssueFilter filter) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public Issue getIssue(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid);
        return (Issue)response.readEntity(Issue.class);
    }

    public Optional<Issue> getOptionalIssue(Object projectIdOrPath, Long issueIid) {
        try {
            return Optional.ofNullable(this.getIssue(projectIdOrPath, issueIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Issue createIssue(Object projectIdOrPath, String title, String description) throws GitLabApiException {
        return this.createIssue(projectIdOrPath, title, description, null, null, null, null, null, null, null, null);
    }

    public Issue createIssue(Object projectIdOrPath, String title, String description, Boolean confidential, List<Long> assigneeIds, Long milestoneId, String labels, Date createdAt, Date dueDate, Long mergeRequestToResolveId, Long discussionToResolveId) throws GitLabApiException {
        return this.createIssue(projectIdOrPath, title, description, confidential, assigneeIds, milestoneId, labels, createdAt, dueDate, mergeRequestToResolveId, discussionToResolveId, null);
    }

    public Issue createIssue(Object projectIdOrPath, String title, String description, Boolean confidential, List<Long> assigneeIds, Long milestoneId, String labels, Date createdAt, Date dueDate, Long mergeRequestToResolveId, Long discussionToResolveId, String iterationTitle) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("confidential", confidential).withParam("assignee_ids", assigneeIds).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("created_at", createdAt).withParam("due_date", dueDate).withParam("merge_request_to_resolve_discussions_of", mergeRequestToResolveId).withParam("discussion_to_resolve", discussionToResolveId).withParam("iteration_title", iterationTitle);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues"});
        return (Issue)response.readEntity(Issue.class);
    }

    public Issue closeIssue(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.StateEvent.CLOSE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid});
        return (Issue)response.readEntity(Issue.class);
    }

    public Issue updateIssue(Object projectIdOrPath, Long issueIid, String title, String description, Boolean confidential, List<Long> assigneeIds, Long milestoneId, String labels, Constants.StateEvent stateEvent, Date updatedAt, Date dueDate) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("description", description).withParam("confidential", confidential).withParam("assignee_ids", assigneeIds).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("state_event", (Object)stateEvent).withParam("updated_at", updatedAt).withParam("due_date", dueDate);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid});
        return (Issue)response.readEntity(Issue.class);
    }

    public Issue assignIssue(Object projectIdOrPath, Long issueIid, Long assigneeId) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("assignee_ids", Collections.singletonList(assigneeId));
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid});
        return (Issue)response.readEntity(Issue.class);
    }

    public void deleteIssue(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid);
    }

    public TimeStats estimateTime(Object projectIdOrPath, Long issueIid, int duration) throws GitLabApiException {
        return this.estimateTime(projectIdOrPath, issueIid, new Duration(duration));
    }

    public TimeStats estimateTime(Object projectIdOrPath, Long issueIid, String duration) throws GitLabApiException {
        return this.estimateTime(projectIdOrPath, issueIid, new Duration(duration));
    }

    public TimeStats estimateTime(Object projectIdOrPath, Long issueIid, Duration duration) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        String durationString = duration != null ? DurationUtils.toString(duration.getSeconds(), false) : null;
        GitLabApiForm formData = new GitLabApiForm().withParam("duration", durationString, true);
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "time_estimate"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats resetEstimatedTime(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm().asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "reset_time_estimate"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats addSpentTime(Object projectIdOrPath, Long issueIid, int duration) throws GitLabApiException {
        return this.addSpentTime(projectIdOrPath, issueIid, new Duration(duration));
    }

    public TimeStats addSpentTime(Object projectIdOrPath, Long issueIid, String duration) throws GitLabApiException {
        return this.addSpentTime(projectIdOrPath, issueIid, new Duration(duration));
    }

    public TimeStats addSpentTime(Object projectIdOrPath, Long issueIid, Duration duration) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        String durationString = duration != null ? DurationUtils.toString(duration.getSeconds(), false) : null;
        GitLabApiForm formData = new GitLabApiForm().withParam("duration", durationString, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "add_spent_time"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats resetSpentTime(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm().asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "reset_spent_time"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats getTimeTrackingStats(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm().asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "time_stats");
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public Optional<TimeStats> getOptionalTimeTrackingStats(Object projectIdOrPath, Long issueIid) {
        try {
            return Optional.ofNullable(this.getTimeTrackingStats(projectIdOrPath, issueIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<MergeRequest> getClosedByMergeRequests(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getClosedByMergeRequests(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getClosedByMergeRequests(Object projectIdOrPath, Long issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "closed_by");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getClosedByMergeRequests(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "closed_by");
    }

    public Stream<MergeRequest> getClosedByMergeRequestsStream(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getClosedByMergeRequests(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getIssueLinks(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueLinks(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public Pager<Issue> getIssueLinks(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "links");
    }

    public Stream<Issue> getIssueLinksStream(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueLinks(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public IssueLink createIssueLink(Object projectIdOrPath, Long issueIid, Object targetProjectIdOrPath, Long targetIssueIid) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("target_project_id", this.getProjectIdOrPath(targetProjectIdOrPath), true).withParam("target_issue_iid", targetIssueIid, true);
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "links"});
        return (IssueLink)response.readEntity(IssueLink.class);
    }

    public IssueLink deleteIssueLink(Object projectIdOrPath, Long issueIid, Long issueLinkId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "links", issueLinkId);
        return (IssueLink)response.readEntity(IssueLink.class);
    }

    public List<Participant> getParticipants(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getParticipants(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public List<Participant> getParticipants(Object projectIdOrPath, Long issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "participants");
        return (List)response.readEntity((GenericType)new GenericType<List<Participant>>(){});
    }

    public Pager<Participant> getParticipants(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Participant>(this, Participant.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "participants");
    }

    public Stream<Participant> getParticipantsStream(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getParticipants(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public IssuesStatistics getIssuesStatistics(IssuesStatisticsFilter filter) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "issues_statistics");
        return (IssuesStatistics)response.readEntity(IssuesStatistics.class);
    }

    public IssuesStatistics getGroupIssuesStatistics(Object groupIdOrPath, IssuesStatisticsFilter filter) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "issues_statistics");
        return (IssuesStatistics)response.readEntity(IssuesStatistics.class);
    }

    public IssuesStatistics geProjectIssuesStatistics(Object projectIdOrPath, IssuesStatisticsFilter filter) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues_statistics");
        return (IssuesStatistics)response.readEntity(IssuesStatistics.class);
    }

    public Issue moveIssue(Object projectIdOrPath, Long issueIid, Object toProjectId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("to_project_id", toProjectId, true);
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "move"});
        return (Issue)response.readEntity(Issue.class);
    }
}

