/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Event;

public class EventsApi
extends AbstractApi {
    public EventsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, 1, this.getDefaultPerPage());
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "events");
    }

    public List<Event> getUserEvents(Integer userId, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getUserEvents(userId, action, targetType, before, after, sortOrder, 1, this.getDefaultPerPage());
    }

    public List<Event> getUserEvents(Integer userId, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("user ID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", userId, "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getUserEvents(Integer userId, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("user ID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users", userId, "events");
    }

    public List<Event> getProjectEvents(Integer projectId, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getProjectEvents(projectId, action, targetType, before, after, sortOrder, 1, this.getDefaultPerPage());
    }

    public List<Event> getProjectEvents(Integer projectId, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("project ID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getProjectEvents(Integer projectId, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("project ID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "events");
    }
}

