/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.ImpersonationToken;
import org.gitlab4j.api.models.SshKey;
import org.gitlab4j.api.models.User;

public class UserApi
extends AbstractApi {
    UserApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<User> getUsers() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> getUsers(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getUsers(int itemsPerPage) throws GitLabApiException {
        return new Pager<User>(this, User.class, itemsPerPage, null, "users");
    }

    public List<User> getActiveUsers() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("active", true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> getActiveUsers(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("active", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getActiveUsers(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("active", true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public void blockUser(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "block"});
    }

    public void unblockUser(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "unblock"});
    }

    public List<User> getBlockedUsers() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("blocked", true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> getblockedUsers(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("blocked", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> getBlockedUsers(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("blocked", true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public User getUser(int userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", userId);
        return (User)response.readEntity(User.class);
    }

    public Optional<User> getOptionalUser(int userId) {
        try {
            return Optional.ofNullable(this.getUser(userId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUser(String username) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("username", username, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        List users = (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
        return users.isEmpty() ? null : (User)users.get(0);
    }

    public Optional<User> getOptionalUser(String username) {
        try {
            return Optional.ofNullable(this.getUser(username));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<User> findUsers(String emailOrUsername) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", emailOrUsername, true).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> findUsers(String emailOrUsername, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", emailOrUsername, true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public Pager<User> findUsers(String emailOrUsername, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", emailOrUsername, true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public User createUser(User user, CharSequence password, Integer projectsLimit) throws GitLabApiException {
        Form formData = this.userToForm(user, projectsLimit, password, null, true);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"users"});
        return (User)response.readEntity(User.class);
    }

    public User createUser(User user, CharSequence password, boolean resetPassword) throws GitLabApiException {
        Form formData = this.userToForm(user, null, password, resetPassword, true);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"users"});
        return (User)response.readEntity(User.class);
    }

    public User updateUser(User user, CharSequence password) throws GitLabApiException {
        Form form = this.userToForm(user, null, password, false, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "users", user.getId());
        return (User)response.readEntity(User.class);
    }

    @Deprecated
    public User modifyUser(User user, CharSequence password, Integer projectsLimit) throws GitLabApiException {
        Form form = this.userToForm(user, projectsLimit, password, false, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "users", user.getId());
        return (User)response.readEntity(User.class);
    }

    public void deleteUser(Integer userId) throws GitLabApiException {
        this.deleteUser(userId, null);
    }

    public void deleteUser(Integer userId, Boolean hardDelete) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("hard_delete ", hardDelete);
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, (MultivaluedMap<String, String>)formData.asMap(), "users", userId);
    }

    public void deleteUser(User user) throws GitLabApiException {
        this.deleteUser(user.getId(), null);
    }

    public void deleteUser(User user, Boolean hardDelete) throws GitLabApiException {
        this.deleteUser(user.getId(), hardDelete);
    }

    public User getCurrentUser() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user");
        return (User)response.readEntity(User.class);
    }

    public List<SshKey> getSshKeys() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "user", "keys");
        return (List)response.readEntity((GenericType)new GenericType<List<SshKey>>(){});
    }

    public List<SshKey> getSshKeys(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "users", userId, "keys");
        List keys = (List)response.readEntity((GenericType)new GenericType<List<SshKey>>(){});
        if (keys == null) {
            return keys;
        }
        for (SshKey key : keys) {
            key.setUserId(userId);
        }
        return keys;
    }

    public SshKey getSshKey(Integer keyId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user", "keys", keyId);
        return (SshKey)response.readEntity(SshKey.class);
    }

    public Optional<SshKey> getOptionalSshKey(Integer keyId) {
        try {
            return Optional.ofNullable(this.getSshKey(keyId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public SshKey addSshKey(String title, String key) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("key", key);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", "keys"});
        return (SshKey)response.readEntity(SshKey.class);
    }

    public SshKey addSshKey(Integer userId, String title, String key) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("key", key);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", userId, "keys"});
        SshKey sshKey = (SshKey)response.readEntity(SshKey.class);
        if (sshKey != null) {
            sshKey.setUserId(userId);
        }
        return sshKey;
    }

    public void deleteSshKey(Integer keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "user", "keys", keyId);
    }

    public void deleteSshKey(Integer userId, Integer keyId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "users", userId, "keys", keyId);
    }

    public List<ImpersonationToken> getImpersonationTokens(Integer userId) throws GitLabApiException {
        return this.getImpersonationTokens(userId, null);
    }

    public List<ImpersonationToken> getImpersonationTokens(Integer userId, Constants.ImpersonationState state) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", userId, "impersonation_tokens");
        return (List)response.readEntity((GenericType)new GenericType<List<ImpersonationToken>>(){});
    }

    public ImpersonationToken getImpersonationToken(Integer userId, Integer tokenId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "users", userId, "impersonation_tokens", tokenId);
        return (ImpersonationToken)response.readEntity(ImpersonationToken.class);
    }

    public Optional<ImpersonationToken> getOptionalImpersonationToken(Integer userId, Integer tokenId) {
        try {
            return Optional.ofNullable(this.getImpersonationToken(userId, tokenId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public ImpersonationToken createImpersonationToken(Integer userId, String name, Date expiresAt, ImpersonationToken.Scope[] scopes) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        if (scopes == null || scopes.length == 0) {
            throw new RuntimeException("scopes cannot be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("expires_at", expiresAt);
        for (ImpersonationToken.Scope scope : scopes) {
            formData.withParam("scopes[]", scope.toString());
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", userId, "impersonation_tokens"});
        return (ImpersonationToken)response.readEntity(ImpersonationToken.class);
    }

    public void revokeImpersonationToken(Integer userId, Integer tokenId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "users", userId, "impersonation_tokens", tokenId);
    }

    Form userToForm(User user, Integer projectsLimit, CharSequence password, Boolean resetPassword, boolean create) {
        if (create && (password == null || password.toString().trim().isEmpty()) && !resetPassword.booleanValue()) {
            throw new IllegalArgumentException("either password or reset_password must be set");
        }
        projectsLimit = projectsLimit == null ? user.getProjectsLimit() : projectsLimit;
        return new GitLabApiForm().withParam("email", user.getEmail(), create).withParam("password", password, false).withParam("reset_password", resetPassword, false).withParam("username", user.getUsername(), create).withParam("name", user.getName(), create).withParam("skype", user.getSkype(), false).withParam("linkedin", user.getLinkedin(), false).withParam("twitter", user.getTwitter(), false).withParam("website_url", user.getWebsiteUrl(), false).withParam("organization", user.getOrganization(), false).withParam("projects_limit", projectsLimit, false).withParam("extern_uid", user.getExternUid(), false).withParam("provider", user.getProvider(), false).withParam("bio", user.getBio(), false).withParam("location", user.getLocation(), false).withParam("admin", user.getIsAdmin(), false).withParam("can_create_group", user.getCanCreateGroup(), false).withParam("skip_confirmation", user.getSkipConfirmation(), false).withParam("external", user.getExternal(), false).withParam("shared_runners_minutes_limit", user.getSharedRunnersMinutesLimit(), false);
    }
}

