/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.MergeRequest;

public class MergeRequestApi
extends AbstractApi {
    public MergeRequestApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<MergeRequest> getMergeRequests(Integer projectId) throws GitLabApiException {
        return this.getMergeRequests(projectId, 1, this.getDefaultPerPage());
    }

    public List<MergeRequest> getMergeRequests(Integer projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", projectId, "merge_requests");
    }

    public List<MergeRequest> getMergeRequests(Integer projectId, Constants.MergeRequestState state) throws GitLabApiException {
        return this.getMergeRequests(projectId, state, 1, this.getDefaultPerPage());
    }

    public List<MergeRequest> getMergeRequests(Integer projectId, Constants.MergeRequestState state, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Integer projectId, Constants.MergeRequestState state, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state);
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests");
    }

    public MergeRequest getMergeRequest(Integer projectId, Integer mergeRequestIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "merge_requests", mergeRequestIid);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public Optional<MergeRequest> getOptionalMergeRequest(Integer projectId, Integer mergeRequestIid) {
        try {
            return Optional.ofNullable(this.getMergeRequest(projectId, mergeRequestIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Commit> getCommits(int projectId, int mergeRequestIid) throws GitLabApiException {
        return this.getCommits(projectId, mergeRequestIid, 1, this.getDefaultPerPage());
    }

    public List<Commit> getCommits(int projectId, int mergeRequestIid, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("owned", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests", mergeRequestIid, "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public Pager<Commit> getCommits(int projectId, int mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Commit>(this, Commit.class, itemsPerPage, null, "projects", projectId, "merge_requests", mergeRequestIid, "commits");
    }

    public MergeRequest createMergeRequest(Integer projectId, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId, Integer targetProjectId, String[] labels, Integer milestoneId, Boolean removeSourceBranch) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Form formData = new Form();
        this.addFormParam(formData, "source_branch", sourceBranch, true);
        this.addFormParam(formData, "target_branch", targetBranch, true);
        this.addFormParam(formData, "title", title, true);
        this.addFormParam(formData, "description", description, false);
        this.addFormParam(formData, "assignee_id", assigneeId, false);
        this.addFormParam(formData, "target_project_id", targetProjectId, false);
        this.addFormParam(formData, "labels", labels == null ? null : String.join((CharSequence)",", labels), false);
        this.addFormParam(formData, "milestone_id", milestoneId, false);
        this.addFormParam(formData, "remove_source_branch", removeSourceBranch, false);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", projectId, "merge_requests"});
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest createMergeRequest(Integer projectId, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        return this.createMergeRequest(projectId, sourceBranch, targetBranch, title, description, assigneeId, null, null, null, null);
    }

    public MergeRequest updateMergeRequest(Integer projectId, Integer mergeRequestIid, String targetBranch, String title, Integer assigneeId, String description, Constants.StateEvent stateEvent, String labels, Integer milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("target_branch", targetBranch).withParam("title", title).withParam("assignee_id", assigneeId).withParam("description", description).withParam("state_event", (Object)stateEvent).withParam("labels", labels).withParam("milestone_id", milestoneId);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests", mergeRequestIid);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    @Deprecated
    public MergeRequest updateMergeRequest(Integer projectId, Integer mergeRequestIid, String sourceBranch, String targetBranch, String title, String description, Integer assigneeId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestId cannot be null");
        }
        Form formData = new Form();
        this.addFormParam(formData, "source_branch", sourceBranch, false);
        this.addFormParam(formData, "target_branch", targetBranch, false);
        this.addFormParam(formData, "title", title, false);
        this.addFormParam(formData, "description", description, false);
        this.addFormParam(formData, "assignee_id", assigneeId, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests", mergeRequestIid);
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public void deleteMergeRequest(Integer projectId, Integer mergeRequestIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", projectId, "merge_requests", mergeRequestIid);
    }

    public MergeRequest acceptMergeRequest(Integer projectId, Integer mergeRequestIid) throws GitLabApiException {
        return this.acceptMergeRequest(projectId, mergeRequestIid, null, null, null, null);
    }

    public MergeRequest acceptMergeRequest(Integer projectId, Integer mergeRequestIid, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds) throws GitLabApiException {
        return this.acceptMergeRequest(projectId, mergeRequestIid, mergeCommitMessage, shouldRemoveSourceBranch, mergeWhenPipelineSucceeds, null);
    }

    public MergeRequest acceptMergeRequest(Integer projectId, Integer mergeRequestIid, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds, String sha) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("merge_commit_message", mergeCommitMessage).withParam("should_remove_source_branch", shouldRemoveSourceBranch).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "merge_when_build_succeeds" : "merge_when_pipeline_succeeds", mergeWhenPipelineSucceeds).withParam("sha", sha);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "merge_requests", mergeRequestIid, "merge");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest cancelMergeRequest(Integer projectId, Integer mergeRequestIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.put(Response.Status.OK, null, "projects", projectId, "merge_requests", mergeRequestIid, "cancel_merge_when_pipeline_succeeds");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest getMergeRequestApprovals(Integer projectId, Integer mergeRequestIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "merge_requests", mergeRequestIid, "approvals");
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest approveMergeRequest(Integer projectId, Integer mergeRequestIid, String sha) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"projects", projectId, "merge_requests", mergeRequestIid, "approve"});
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }

    public MergeRequest unapproveMergeRequest(Integer projectId, Integer mergeRequestIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.post(Response.Status.OK, (Form)null, new Object[]{"projects", projectId, "merge_requests", mergeRequestIid, "unapprove"});
        return (MergeRequest)response.readEntity(MergeRequest.class);
    }
}

