/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Note;

public class NotesApi
extends AbstractApi {
    public NotesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Note> getNotes(Integer projectId, Integer issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectId, issueIid);
    }

    public List<Note> getNotes(Integer projectId, Integer issueIid, int page, int perPage) throws GitLabApiException {
        return this.getIssueNotes(projectId, issueIid, page, perPage);
    }

    public Pager<Note> getNotes(Integer projectId, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return this.getIssueNotes(projectId, issueIid, itemsPerPage);
    }

    public List<Note> getIssueNotes(Integer projectId, Integer issueIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "issues", issueIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public List<Note> getIssueNotes(Integer projectId, Integer issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "issues", issueIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public Pager<Note> getIssueNotes(Integer projectId, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Note>(this, Note.class, itemsPerPage, null, "projects", projectId, "issues", issueIid, "notes");
    }

    public Note getIssueNote(Integer projectId, Integer issueIid, Integer noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "issues", issueIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createIssueNote(Integer projectId, Integer issueIid, String body) throws GitLabApiException {
        return this.createIssueNote(projectId, issueIid, body, null);
    }

    public Note createIssueNote(Integer projectId, Integer issueIid, String body, Date createdAt) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", projectId, "issues", issueIid, "notes");
        return (Note)response.readEntity(Note.class);
    }

    public Note updateIssueNote(Integer projectId, Integer issueIid, String body) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "issues", issueIid, "notes");
        return (Note)response.readEntity(Note.class);
    }

    public void deleteIssueNote(Integer projectId, Integer issueIid, Integer noteId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issueIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, this.getDefaultPerPageParam(), "projects", projectId, "issues", issueIid, "notes", noteId);
    }
}

