/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import javax.ws.rs.core.Response;

public class Utils {
    public static File createUniqueFile(File directory, String filename) throws IOException {
        File uniqueFile = new File(directory, filename);
        if (uniqueFile.createNewFile()) {
            return uniqueFile;
        }
        String extension = "";
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex >= 0) {
            extension = filename.substring(dotIndex);
            filename = filename.substring(0, dotIndex);
        }
        int fileNumber = 0;
        while (!uniqueFile.createNewFile()) {
            String numberedFilename = String.format("%s-%d%s", filename, ++fileNumber, extension);
            uniqueFile = new File(directory, numberedFilename);
        }
        return uniqueFile;
    }

    public static String getFilenameFromContentDisposition(Response response) {
        String disposition = response.getHeaderString("Content-Disposition");
        if (disposition == null || disposition.trim().length() == 0) {
            return null;
        }
        return disposition.replaceFirst("(?i)^.*filename=\"([^\"]+)\".*$", "$1");
    }

    public static String readFileContents(File file) throws IOException {
        try (Scanner in = new Scanner(file);){
            in.useDelimiter("\\Z");
            String string = in.next();
            return string;
        }
    }
}

