/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggStreamIdentifier;

public class OggInfoTool {
    private File file;
    private OggFile ogg;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   OggInfoTool <file> [file] [file]");
            System.exit(1);
        }
        for (String f : args) {
            OggInfoTool info = new OggInfoTool(new File(f));
            info.printStreamInfo();
        }
    }

    public OggInfoTool(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        this.file = f;
        this.ogg = new OggFile((InputStream)new FileInputStream(f));
    }

    public void printStreamInfo() throws IOException {
        OggPacket p;
        OggPacketReader r = this.ogg.getPacketReader();
        System.out.println("Processing file \"" + this.file.toString() + "\"");
        int pc = 0;
        int streams = 0;
        int lastSid = -1;
        HashMap<Integer, String> streamTypes = new HashMap<Integer, String>();
        while ((p = r.getNextPacket()) != null) {
            if (p.isBeginningOfStream()) {
                lastSid = p.getSid();
                System.out.println("");
                System.out.println("New logical stream #" + ++streams + ", serial: " + Integer.toHexString(p.getSid()) + " (" + p.getSid() + ")");
                OggStreamIdentifier.OggStreamType type = OggStreamIdentifier.identifyType((OggPacket)p);
                streamTypes.put(lastSid, type.description);
                System.out.println("\t" + type.description + " detected (" + type.mimetype + ")");
                continue;
            }
            if (p.isEndOfStream()) {
                if (pc > 0) {
                    System.out.println("(" + pc + " mid-stream packets of " + Integer.toHexString(p.getSid()) + ")");
                }
                System.out.println("Stream " + Integer.toHexString(p.getSid()) + " of " + (String)streamTypes.get(p.getSid()) + " ended");
                pc = 0;
                continue;
            }
            if (p.getSid() != lastSid) {
                System.out.println("(" + pc + " packets of stream " + Integer.toHexString(p.getSid()) + ")");
                lastSid = p.getSid();
                pc = 0;
                continue;
            }
            ++pc;
        }
    }
}

