/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggStreamAudioData;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioStatistics;
import org.gagravarr.ogg.audio.OggAudioStream;

public abstract class OggAudioInfoTool {
    public static void handleMain(String[] args, OggAudioInfoTool tool) throws Exception {
        File file;
        if (args.length == 0) {
            OggAudioInfoTool.printHelp(tool);
        }
        boolean debugging = false;
        String filename = args[0];
        if (args.length > 1 && args[0].equals("-d")) {
            filename = args[1];
            debugging = true;
        }
        if (!(file = new File(filename)).exists()) {
            System.err.println("Error - file not found");
            System.err.println("   " + file);
            System.exit(2);
        }
        tool.process(file, debugging);
    }

    public abstract void process(File var1, boolean var2) throws IOException;

    public abstract String getToolName();

    public abstract String getDefaultExtension();

    public static void printHelp(OggAudioInfoTool tool) {
        System.err.println("Use:");
        System.err.println("   " + tool.getToolName() + " file." + tool.getDefaultExtension());
        System.exit(1);
    }

    public static void listTags(OggAudioHeaders oa) {
        Map comments = oa.getTags().getAllComments();
        for (String tag : comments.keySet()) {
            for (String value : (List)comments.get(tag)) {
                System.out.println("  " + tag + "=" + value);
            }
        }
    }

    protected static String format2(double d) {
        return String.format("%8.1f", d);
    }

    protected static String format1(double d) {
        return String.format("%.2f", d);
    }

    protected static String formatBitrate(double bitrate) {
        if (bitrate < 512.0) {
            return String.format("%.2f", bitrate) + " b/s";
        }
        if (bitrate < 786432.0) {
            return String.format("%.2f", bitrate / 1024.0) + " kb/s";
        }
        return String.format("%.2f", bitrate / 1024.0 / 1024.0) + " mb/s";
    }

    protected static class InfoPacketReader
    extends OggPacketReader {
        private boolean inProgress = false;
        private int lastSeqNum = 0;

        public InfoPacketReader(InputStream inp) {
            super(inp);
        }

        public int getLastSeqNum() {
            return this.lastSeqNum;
        }

        public OggPacket getNextPacket() throws IOException {
            if (this.inProgress) {
                this.inProgress = false;
                return super.getNextPacket();
            }
            this.inProgress = true;
            OggPacket p = super.getNextPacket();
            this.inProgress = false;
            if (p != null) {
                this.lastSeqNum = p.getSequenceNumber();
                if (p.isBeginningOfStream()) {
                    System.out.println("New logical stream " + Integer.toHexString(p.getSid()) + " (" + p.getSid() + ") found");
                }
                if (p.isEndOfStream()) {
                    System.out.println("Logical stream " + Integer.toHexString(p.getSid()) + " (" + p.getSid() + ") completed");
                }
            }
            return p;
        }

        public OggPacket getNextPacketWithSid(int sid) throws IOException {
            OggPacket p;
            while ((p = this.getNextPacket()) != null) {
                if (p.getSid() != sid) {
                    System.out.println("Ignoring packet from stream " + Integer.toHexString(p.getSid()));
                    continue;
                }
                return p;
            }
            return null;
        }
    }

    protected static class InfoAudioStats
    extends OggAudioStatistics {
        private boolean debugging;
        private int lastSeqNum;

        public InfoAudioStats(OggAudioHeaders headers, OggAudioStream audio, int lastSeqNum, boolean debugging) throws IOException {
            super(headers, audio);
            this.debugging = debugging;
            this.lastSeqNum = lastSeqNum;
        }

        protected void handleAudioData(OggStreamAudioData audioData) {
            super.handleAudioData(audioData);
            if (this.debugging) {
                System.out.println(this.lastSeqNum + " - " + audioData.getGranulePosition() + " - " + audioData.getData().length + " bytes");
            }
        }
    }
}

