/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.gagravarr.flac.FlacFirstOggPacket;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.vorbis.VorbisPacket;

public class OggInfoTool {
    private File file;
    private OggFile ogg;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   OggInfoTool <file> [file] [file]");
            System.exit(1);
        }
        for (String f : args) {
            OggInfoTool info = new OggInfoTool(new File(f));
            info.printStreamInfo();
        }
    }

    public OggInfoTool(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        this.file = f;
        this.ogg = new OggFile((InputStream)new FileInputStream(f));
    }

    public void printStreamInfo() throws IOException {
        OggPacket p;
        OggPacketReader r = this.ogg.getPacketReader();
        System.out.println("Processing file \"" + this.file.toString() + "\"");
        int pc = 0;
        int streams = 0;
        int lastSid = -1;
        while ((p = r.getNextPacket()) != null) {
            if (p.isBeginningOfStream()) {
                lastSid = p.getSid();
                System.out.println("");
                System.out.println("New logical stream #" + ++streams + ", serial: " + Integer.toHexString(p.getSid()) + " (" + p.getSid() + ")");
                if (p.getData() == null || p.getData().length <= 10) continue;
                if (VorbisPacket.isVorbisStream((OggPacket)p)) {
                    System.out.println("\tVorbis Info detected");
                }
                if (!FlacFirstOggPacket.isFlacStream((OggPacket)p)) continue;
                System.out.println("\tFLAC Info detected");
                continue;
            }
            if (p.isEndOfStream()) {
                System.out.println("Stream " + Integer.toHexString(p.getSid()) + " ended");
                continue;
            }
            if (p.getSid() != lastSid) {
                System.out.println("(" + pc + " packets of stream " + Integer.toHexString(p.getSid()) + ")");
                lastSid = p.getSid();
                pc = 0;
                continue;
            }
            ++pc;
        }
    }
}

