/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;

class CondVar
implements Condition,
Serializable {
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    if (nanos > 0L) {
                        long start = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        success = Utils.nanoTime() - start < nanos;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i = holdCount; i > 0; --i) {
            this.lock.lock();
        }
        return success;
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

