/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.ServiceBase;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportListener;

public class UdpTransport
extends ServiceBase
implements Transport {
    public static final SocketAddress ANY_ADDRESS = new SocketAddress(){

        public String toString() {
            return "*:*";
        }
    };
    protected URI remoteLocation;
    protected URI localLocation;
    protected TransportListener listener;
    protected ProtocolCodec codec;
    protected DatagramChannel channel;
    protected SocketState socketState = new DISCONNECTED();
    protected DispatchQueue dispatchQueue;
    private DispatchSource readSource;
    private DispatchSource writeSource;
    protected CustomDispatchSource<Integer, Integer> drainOutboundSource;
    protected CustomDispatchSource<Integer, Integer> yieldSource;
    protected boolean useLocalHost = true;
    int receiveBufferSize = 65536;
    int sendBufferSize = 65536;
    int trafficClass = 8;
    SocketAddress localAddress;
    SocketAddress remoteAddress = ANY_ADDRESS;
    Executor blockingExecutor;
    private final Task CANCEL_HANDLER = new Task(){

        public void run() {
            UdpTransport.this.socketState.onCanceled();
        }
    };
    Task onDispose;
    boolean rejectingOffers;
    boolean writeResumedForCodecFlush = false;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTING;

    protected void initializeCodec() throws Exception {
        this.codec.setTransport(this);
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
        if (this.readSource != null) {
            this.readSource.setTargetQueue(queue);
        }
        if (this.writeSource != null) {
            this.writeSource.setTargetQueue(queue);
        }
        if (this.drainOutboundSource != null) {
            this.drainOutboundSource.setTargetQueue(queue);
        }
        if (this.yieldSource != null) {
            this.yieldSource.setTargetQueue(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _start(Task onCompleted) {
        try {
            Class<?> clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTING;
            if (clazz == null) {
                clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTING = new CONNECTING[0].getClass().getComponentType();
            }
            if (this.socketState.is((Class<? extends SocketState>)clazz)) {
                this.blockingExecutor.execute(new Runnable(){
                    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTING;

                    public void run() {
                        SocketState socketState = UdpTransport.this.socketState;
                        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTING;
                        if (clazz == null) {
                            clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTING = new CONNECTING[0].getClass().getComponentType();
                        }
                        if (!socketState.is((Class<? extends SocketState>)clazz)) {
                            return;
                        }
                        try {
                            final InetSocketAddress localAddress = UdpTransport.this.localLocation != null ? new InetSocketAddress(InetAddress.getByName(UdpTransport.this.localLocation.getHost()), UdpTransport.this.localLocation.getPort()) : null;
                            String host = UdpTransport.this.resolveHostName(UdpTransport.this.remoteLocation.getHost());
                            final InetSocketAddress remoteAddress = new InetSocketAddress(host, UdpTransport.this.remoteLocation.getPort());
                            UdpTransport.this.dispatchQueue.execute(new Task(){

                                public void run() {
                                    try {
                                        if (localAddress != null) {
                                            UdpTransport.this.channel.socket().bind(localAddress);
                                        }
                                        UdpTransport.this.channel.connect(remoteAddress);
                                    }
                                    catch (IOException e) {
                                        try {
                                            UdpTransport.this.channel.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        UdpTransport.this.socketState = new CANCELED(true);
                                        UdpTransport.this.listener.onTransportFailure(e);
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            try {
                                UdpTransport.this.channel.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            UdpTransport.this.socketState = new CANCELED(true);
                            UdpTransport.this.listener.onTransportFailure(e);
                        }
                    }
                });
            } else {
                Class<?> clazz2 = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED;
                if (clazz2 == null) {
                    clazz2 = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
                }
                if (this.socketState.is((Class<? extends SocketState>)clazz2)) {
                    this.dispatchQueue.execute(new Task(){

                        public void run() {
                            try {
                                UdpTransport.this.trace("was connected.");
                                UdpTransport.this.onConnected();
                            }
                            catch (IOException e) {
                                UdpTransport.this.onTransportFailure(e);
                            }
                        }
                    });
                } else {
                    System.err.println("cannot be started.  socket state is: " + this.socketState);
                }
            }
        }
        finally {
            if (onCompleted != null) {
                onCompleted.run();
            }
        }
    }

    public void _stop(Task onCompleted) {
        this.trace("stopping.. at state: " + this.socketState);
        this.socketState.onStop(onCompleted);
    }

    protected String resolveHostName(String host) throws UnknownHostException {
        String localName = InetAddress.getLocalHost().getHostName();
        if (localName != null && this.isUseLocalHost() && localName.equals(host)) {
            return "localhost";
        }
        return host;
    }

    protected void onConnected() throws IOException {
        this.yieldSource = Dispatch.createSource(EventAggregators.INTEGER_ADD, this.dispatchQueue);
        this.yieldSource.setEventHandler(new Task(){

            public void run() {
                UdpTransport.this.drainInbound();
            }
        });
        this.yieldSource.resume();
        this.drainOutboundSource = Dispatch.createSource(EventAggregators.INTEGER_ADD, this.dispatchQueue);
        this.drainOutboundSource.setEventHandler(new Task(){

            public void run() {
                UdpTransport.this.flush();
            }
        });
        this.drainOutboundSource.resume();
        this.readSource = Dispatch.createSource(this.channel, 1, this.dispatchQueue);
        this.writeSource = Dispatch.createSource(this.channel, 4, this.dispatchQueue);
        this.readSource.setCancelHandler(this.CANCEL_HANDLER);
        this.writeSource.setCancelHandler(this.CANCEL_HANDLER);
        this.readSource.setEventHandler(new Task(){

            public void run() {
                UdpTransport.this.drainInbound();
            }
        });
        this.writeSource.setEventHandler(new Task(){

            public void run() {
                UdpTransport.this.flush();
            }
        });
        this.listener.onTransportConnected();
    }

    private void dispose() {
        if (this.readSource != null) {
            this.readSource.cancel();
            this.readSource = null;
        }
        if (this.writeSource != null) {
            this.writeSource.cancel();
            this.writeSource = null;
        }
        this.codec = null;
        if (this.onDispose != null) {
            this.onDispose.run();
            this.onDispose = null;
        }
    }

    public void onTransportFailure(IOException error) {
        this.listener.onTransportFailure(error);
        this.socketState.onCanceled();
    }

    public boolean full() {
        return this.codec == null || this.codec.full();
    }

    public boolean offer(Object command) {
        this.dispatchQueue.assertExecuting();
        try {
            Class<?> clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED;
            if (clazz == null) {
                clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
            }
            if (!this.socketState.is((Class<? extends SocketState>)clazz)) {
                throw new IOException("Not connected.");
            }
            if (this.getServiceState() != STARTED) {
                throw new IOException("Not running.");
            }
            ProtocolCodec.BufferState rc = this.codec.write(command);
            this.rejectingOffers = this.codec.full();
            switch (10.$SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState[rc.ordinal()]) {
                case 1: {
                    return false;
                }
            }
            this.drainOutboundSource.merge(_Integer.valueOf(1));
            return true;
        }
        catch (IOException e) {
            this.onTransportFailure(e);
            return false;
        }
    }

    public void flush() {
        block12: {
            block11: {
                this.dispatchQueue.assertExecuting();
                if (this.getServiceState() != STARTED) break block11;
                Class<?> clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED;
                if (clazz == null) {
                    clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
                }
                if (this.socketState.is((Class<? extends SocketState>)clazz)) break block12;
            }
            return;
        }
        try {
            if (this.codec.flush() == ProtocolCodec.BufferState.EMPTY && this.transportFlush()) {
                if (this.writeResumedForCodecFlush) {
                    this.writeResumedForCodecFlush = false;
                    this.suspendWrite();
                }
                this.rejectingOffers = false;
                this.listener.onRefill();
            } else if (!this.writeResumedForCodecFlush) {
                this.writeResumedForCodecFlush = true;
                this.resumeWrite();
            }
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    protected boolean transportFlush() throws IOException {
        return true;
    }

    public void drainInbound() {
        if (!this.getServiceState().isStarted() || this.readSource.isSuspended()) {
            return;
        }
        try {
            long initial = this.codec.getReadCounter();
            while (this.codec.getReadCounter() - initial < (long)(this.codec.getReadBufferSize() << 2)) {
                Object command = this.codec.read();
                if (command != null) {
                    try {
                        this.listener.onTransportCommand(command);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.onTransportFailure(new IOException("Transport listener failure."));
                    }
                    if (this.getServiceState() != STOPPED && !this.readSource.isSuspended()) continue;
                    return;
                }
                return;
            }
            this.yieldSource.merge(_Integer.valueOf(1));
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void suspendRead() {
        if (this.isConnected() && this.readSource != null) {
            this.readSource.suspend();
        }
    }

    public void resumeRead() {
        if (this.isConnected() && this.readSource != null) {
            this._resumeRead();
        }
    }

    private void _resumeRead() {
        this.readSource.resume();
        this.dispatchQueue.execute(new Task(){

            public void run() {
                UdpTransport.this.drainInbound();
            }
        });
    }

    protected void suspendWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.suspend();
        }
    }

    protected void resumeWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.resume();
        }
    }

    public void setTransportListener(TransportListener transportListener) {
        this.listener = transportListener;
    }

    public ProtocolCodec getProtocolCodec() {
        return this.codec;
    }

    public void setProtocolCodec(ProtocolCodec protocolCodec) throws Exception {
        this.codec = protocolCodec;
        if (this.channel != null && this.codec != null) {
            this.initializeCodec();
        }
    }

    public boolean isConnected() {
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$UdpTransport$CONNECTED = new CONNECTED[0].getClass().getComponentType();
        }
        return this.socketState.is((Class<? extends SocketState>)clazz);
    }

    public boolean isClosed() {
        return this.getServiceState() == STOPPED;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    private void trace(String message) {
    }

    public ReadableByteChannel getReadChannel() {
        return this.channel;
    }

    public WritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    static class 10 {
        static final /* synthetic */ int[] $SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState;

        static {
            $SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState = new int[ProtocolCodec.BufferState.values().length];
            try {
                10.$SwitchMap$org$fusesource$hawtdispatch$transport$ProtocolCodec$BufferState[ProtocolCodec.BufferState.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    class CANCELED
    extends SocketState {
        private boolean disposed;

        public CANCELED(boolean disposed) {
            this.disposed = disposed;
        }

        void onStop(Task onCompleted) {
            UdpTransport.this.trace("CANCELED.onStop");
            if (!this.disposed) {
                this.disposed = true;
                UdpTransport.this.dispose();
            }
            onCompleted.run();
        }
    }

    class CANCELING
    extends SocketState {
        private LinkedList<Task> runnables = new LinkedList();
        private int remaining;
        private boolean dispose;

        public CANCELING() {
            if (UdpTransport.this.readSource != null) {
                ++this.remaining;
                UdpTransport.this.readSource.cancel();
            }
            if (UdpTransport.this.writeSource != null) {
                ++this.remaining;
                UdpTransport.this.writeSource.cancel();
            }
        }

        void onStop(Task onCompleted) {
            UdpTransport.this.trace("CANCELING.onCompleted");
            this.add(onCompleted);
            this.dispose = true;
        }

        void add(Task onCompleted) {
            if (onCompleted != null) {
                this.runnables.add(onCompleted);
            }
        }

        void onCanceled() {
            UdpTransport.this.trace("CANCELING.onCanceled");
            --this.remaining;
            if (this.remaining != 0) {
                return;
            }
            try {
                UdpTransport.this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            UdpTransport.this.socketState = new CANCELED(this.dispose);
            Iterator i$ = this.runnables.iterator();
            while (i$.hasNext()) {
                Task runnable = (Task)i$.next();
                runnable.run();
            }
            if (this.dispose) {
                UdpTransport.this.dispose();
            }
        }
    }

    class CONNECTED
    extends SocketState {
        final /* synthetic */ UdpTransport this$0;

        void onStop(Task onCompleted) {
            this.this$0.trace("CONNECTED.onStop");
            CANCELING state = this.this$0.new CANCELING();
            this.this$0.socketState = state;
            state.add(this.createDisconnectTask());
            state.onStop(onCompleted);
        }

        void onCanceled() {
            this.this$0.trace("CONNECTED.onCanceled");
            CANCELING state = this.this$0.new CANCELING();
            this.this$0.socketState = state;
            state.add(this.createDisconnectTask());
            state.onCanceled();
        }

        Task createDisconnectTask() {
            return new Task(){

                public void run() {
                    CONNECTED.this.this$0.listener.onTransportDisconnected();
                }
            };
        }
    }

    class CONNECTING
    extends SocketState {
        final /* synthetic */ UdpTransport this$0;

        void onStop(Task onCompleted) {
            this.this$0.trace("CONNECTING.onStop");
            CANCELING state = this.this$0.new CANCELING();
            this.this$0.socketState = state;
            state.onStop(onCompleted);
        }

        void onCanceled() {
            this.this$0.trace("CONNECTING.onCanceled");
            CANCELING state = this.this$0.new CANCELING();
            this.this$0.socketState = state;
            state.onCanceled();
        }
    }

    static class DISCONNECTED
    extends SocketState {
        DISCONNECTED() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SocketState {
        SocketState() {
        }

        void onStop(Task onCompleted) {
        }

        void onCanceled() {
        }

        boolean is(Class<? extends SocketState> clazz) {
            return this.getClass() == clazz;
        }
    }
}

