/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.sf.retrotranslator.runtime.java.lang._Byte;
import net.sf.retrotranslator.runtime.java.lang._Short;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import net.sf.retrotranslator.runtime.java.lang._Thread_UncaughtExceptionHandler;
import net.sf.retrotranslator.runtime.java.util._LinkedList;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.HexSupport;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.DefaultTransportListener;
import org.fusesource.hawtdispatch.transport.HeartBeatMonitor;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.ExtendedListener;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.MQTTException;
import org.fusesource.mqtt.client.ProxyCallback;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MQTTProtocolCodec;
import org.fusesource.mqtt.codec.MessageSupport;
import org.fusesource.mqtt.codec.PINGREQ;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBACK;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackConnection {
    private static final ExtendedListener DEFAULT_LISTENER;
    private final DispatchQueue queue;
    private final MQTT mqtt;
    private Transport transport;
    private ExtendedListener listener = DEFAULT_LISTENER;
    private Runnable refiller;
    private Map<Short, Request> requests = new ConcurrentHashMap();
    private LinkedList<Request> overflow = new LinkedList();
    private final HashMap<Short, Callback<Void>> processed = new HashMap();
    private Throwable failure;
    private boolean disconnected = false;
    private HeartBeatMonitor heartBeatMonitor;
    private long pingedAt;
    private long reconnects = 0L;
    private final AtomicInteger suspendCount = new AtomicInteger(0);
    private final AtomicInteger suspendChanges = new AtomicInteger(0);
    private final HashMap<UTF8Buffer, QoS> activeSubs = new HashMap();
    boolean onRefillCalled = false;
    short nextMessageId = 1;
    public static final Task NOOP;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$mqtt$client$CallbackConnection;

    public CallbackConnection(MQTT mqtt) {
        this.mqtt = mqtt;
        this.queue = this.mqtt.dispatchQueue == null ? Dispatch.createQueue("mqtt client") : this.mqtt.dispatchQueue;
    }

    public void connect(Callback<Void> cb) {
        if (!$assertionsDisabled && cb == null) {
            throw new AssertionError((Object)"Callback should not be null.");
        }
        if (this.transport != null) {
            cb.onFailure(new IllegalStateException("Already connected"));
            return;
        }
        try {
            this.createTransport(new LoginHandler(cb, true));
        }
        catch (Throwable e) {
            cb.onFailure(e);
        }
    }

    void reconnect() {
        try {
            this.createTransport(new LoginHandler(new Callback<Void>(){

                @Override
                public void onSuccess(Void value) {
                    ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Restoring MQTT connection state", new Object[0]);
                    LinkedList originalOverflow = CallbackConnection.this.overflow;
                    Map originalRequests = CallbackConnection.this.requests;
                    CallbackConnection.this.overflow = new LinkedList();
                    CallbackConnection.this.requests = new ConcurrentHashMap();
                    if (!CallbackConnection.this.activeSubs.isEmpty()) {
                        ArrayList<Topic> topics = new ArrayList<Topic>(CallbackConnection.this.activeSubs.size());
                        for (Map.Entry entry : CallbackConnection.this.activeSubs.entrySet()) {
                            topics.add(new Topic((UTF8Buffer)entry.getKey(), (QoS)entry.getValue()));
                        }
                        CallbackConnection.this.send(new SUBSCRIBE().topics(topics.toArray(new Topic[topics.size()])), null);
                    }
                    for (Map.Entry entry : originalRequests.entrySet()) {
                        MQTTFrame frame = ((Request)entry.getValue()).frame;
                        frame.dup(true);
                        CallbackConnection.this.send((Request)entry.getValue());
                    }
                    for (Request request : originalOverflow) {
                        CallbackConnection.this.send(request);
                    }
                }

                @Override
                public void onFailure(Throwable value) {
                    CallbackConnection.this.handleFatalFailure(value);
                }

                @Override
                public /* synthetic */ void onSuccess(Object x0) {
                    this.onSuccess((Void)x0);
                }
            }, false));
        }
        catch (Throwable e) {
            this.handleFatalFailure(e);
        }
    }

    void handleSessionFailure(Throwable error) {
        if (!(this.disconnected || this.mqtt.reconnectAttemptsMax >= 0L && this.reconnects >= this.mqtt.reconnectAttemptsMax)) {
            this.mqtt.tracer.debug("Reconnecting transport", new Object[0]);
            if (this.heartBeatMonitor != null) {
                this.heartBeatMonitor.stop();
                this.heartBeatMonitor = null;
            }
            Transport t = this.transport;
            this.transport = null;
            if (t != null) {
                t.stop(new Task(){

                    public void run() {
                        CallbackConnection.this.listener.onDisconnected();
                        CallbackConnection.this.reconnect();
                    }
                });
            } else {
                this.reconnect();
            }
        } else {
            this.handleFatalFailure(error);
        }
    }

    void reconnect(final Callback<Transport> onConnect) {
        long reconnectDelay = this.mqtt.reconnectDelay;
        if (reconnectDelay > 0L && this.mqtt.reconnectBackOffMultiplier > 1.0) {
            reconnectDelay = (long)Math.pow(this.mqtt.reconnectDelay * this.reconnects, this.mqtt.reconnectBackOffMultiplier);
        }
        reconnectDelay = Math.min(reconnectDelay, this.mqtt.reconnectDelayMax);
        ++this.reconnects;
        this.queue.executeAfter(reconnectDelay, TimeUnit.MILLISECONDS, new Task(){

            public void run() {
                if (CallbackConnection.this.disconnected) {
                    onConnect.onFailure(CallbackConnection.createDisconnectedError());
                } else {
                    try {
                        CallbackConnection.this.createTransport(onConnect);
                    }
                    catch (Exception e) {
                        onConnect.onFailure(e);
                    }
                }
            }
        });
    }

    void createTransport(final Callback<Transport> onConnect) throws Exception {
        TcpTransport transport;
        this.mqtt.tracer.debug("Connecting", new Object[0]);
        String scheme = this.mqtt.host.getScheme();
        if ("tcp".equals(scheme)) {
            transport = new TcpTransport();
        } else if (SslTransport.protocol(scheme) != null) {
            SslTransport ssl = new SslTransport();
            if (this.mqtt.sslContext == null) {
                this.mqtt.sslContext = SSLContext.getDefault();
            }
            ssl.setSSLContext(this.mqtt.sslContext);
            transport = ssl;
        } else {
            throw new Exception(new StringBuffer().append("Unsupported URI scheme '").append(scheme).append("'").toString());
        }
        if (this.mqtt.blockingExecutor == null) {
            this.mqtt.blockingExecutor = MQTT.getBlockingThreadPool();
        }
        transport.setBlockingExecutor(this.mqtt.blockingExecutor);
        transport.setDispatchQueue(this.queue);
        transport.setProtocolCodec(new MQTTProtocolCodec());
        if (transport instanceof TcpTransport) {
            TcpTransport tcp = transport;
            tcp.setMaxReadRate(this.mqtt.maxReadRate);
            tcp.setMaxWriteRate(this.mqtt.maxWriteRate);
            tcp.setReceiveBufferSize(this.mqtt.receiveBufferSize);
            tcp.setSendBufferSize(this.mqtt.sendBufferSize);
            tcp.setTrafficClass(this.mqtt.trafficClass);
            tcp.setUseLocalHost(this.mqtt.useLocalHost);
            tcp.connecting(this.mqtt.host, this.mqtt.localAddress);
        }
        transport.setTransportListener(new DefaultTransportListener(){

            public void onTransportConnected() {
                ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Transport connected", new Object[0]);
                if (CallbackConnection.this.disconnected) {
                    this.onFailure(CallbackConnection.createDisconnectedError());
                } else {
                    onConnect.onSuccess(transport);
                }
            }

            public void onTransportFailure(IOException error) {
                ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Transport failure: %s", new Object[]{error});
                this.onFailure(error);
            }

            private void onFailure(final Throwable error) {
                if (!transport.isClosed()) {
                    transport.stop(new Task(){

                        public void run() {
                            onConnect.onFailure(error);
                        }
                    });
                }
            }
        });
        transport.start(NOOP);
    }

    public void onSessionEstablished(Transport transport) {
        this.transport = transport;
        if (this.suspendCount.get() > 0) {
            this.transport.suspendRead();
        }
        this.transport.setTransportListener(new DefaultTransportListener(){

            public void onTransportCommand(Object command) {
                MQTTFrame frame = (MQTTFrame)command;
                ((CallbackConnection)CallbackConnection.this).mqtt.tracer.onReceive(frame);
                CallbackConnection.this.processFrame(frame);
            }

            public void onRefill() {
                CallbackConnection.this.onRefillCalled = true;
                CallbackConnection.this.drainOverflow();
            }

            public void onTransportFailure(IOException error) {
                CallbackConnection.this.handleSessionFailure(error);
            }
        });
        this.pingedAt = 0L;
        if (this.mqtt.getKeepAlive() > 0) {
            this.heartBeatMonitor = new HeartBeatMonitor();
            this.heartBeatMonitor.setWriteInterval(this.mqtt.getKeepAlive() * 1000 / 2);
            this.heartBeatMonitor.setTransport(this.transport);
            this.heartBeatMonitor.suspendRead();
            this.heartBeatMonitor.setOnKeepAlive(new Task(){

                public void run() {
                    if (!CallbackConnection.this.disconnected && CallbackConnection.this.pingedAt == 0L) {
                        MQTTFrame encoded = new PINGREQ().encode();
                        if (CallbackConnection.this.transport.offer(encoded)) {
                            ((CallbackConnection)CallbackConnection.this).mqtt.tracer.onSend(encoded);
                            final long now = System.currentTimeMillis();
                            final long suspends = CallbackConnection.this.suspendChanges.get();
                            CallbackConnection.this.pingedAt = now;
                            CallbackConnection.this.queue.executeAfter(CallbackConnection.this.mqtt.getKeepAlive(), TimeUnit.SECONDS, new Task(){

                                public void run() {
                                    if (now == CallbackConnection.this.pingedAt) {
                                        if (suspends == (long)CallbackConnection.this.suspendChanges.get() && CallbackConnection.this.suspendCount.get() > 0) {
                                            CallbackConnection.this.handleFatalFailure(new IllegalStateException("The connection has remained suspended for an extended period of time so it cannot do proper keep alive processing.  Did you forget to resume the connection?"));
                                        } else {
                                            ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Ping timeout", new Object[0]);
                                            CallbackConnection.this.handleSessionFailure(new ProtocolException("Ping timeout").fillInStackTrace());
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            });
            this.heartBeatMonitor.start();
        }
    }

    public Transport transport() {
        return this.transport;
    }

    public DispatchQueue getDispatchQueue() {
        return this.queue;
    }

    public void resume() {
        this.suspendChanges.incrementAndGet();
        if (this.suspendCount.decrementAndGet() == 0 && this.transport != null) {
            this.transport.resumeRead();
            if (this.heartBeatMonitor != null) {
                this.heartBeatMonitor.resumeRead();
            }
        }
    }

    public void suspend() {
        this.suspendChanges.incrementAndGet();
        if (this.suspendCount.incrementAndGet() == 1 && this.transport != null) {
            this.transport.suspendRead();
            if (this.heartBeatMonitor != null) {
                this.heartBeatMonitor.suspendRead();
            }
        }
    }

    public CallbackConnection refiller(Runnable refiller) {
        this.queue.assertExecuting();
        this.refiller = refiller;
        return this;
    }

    public CallbackConnection listener(final Listener original) {
        this.listener = original instanceof ExtendedListener ? (ExtendedListener)original : new ExtendedListener(){

            @Override
            public void onPublish(UTF8Buffer topic, Buffer body, final Callback<Callback<Void>> ack) {
                original.onPublish(topic, body, new Runnable(){

                    public void run() {
                        ack.onSuccess(null);
                    }
                });
            }

            @Override
            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
                original.onPublish(topic, body, ack);
            }

            @Override
            public void onConnected() {
                original.onConnected();
            }

            @Override
            public void onDisconnected() {
                original.onDisconnected();
            }

            @Override
            public void onFailure(Throwable value) {
                original.onFailure(value);
            }
        };
        return this;
    }

    public boolean full() {
        this.queue.assertExecuting();
        return this.transport.full();
    }

    public Throwable failure() {
        this.queue.assertExecuting();
        return this.failure;
    }

    public void disconnect(final Callback<Void> onComplete) {
        if (this.disconnected) {
            if (onComplete != null) {
                onComplete.onSuccess(null);
            }
            return;
        }
        this.disconnected = true;
        final short requestId = this.getNextMessageId();
        final Runnable stop = new Runnable(){
            boolean executed = false;

            public void run() {
                if (!this.executed) {
                    this.executed = true;
                    CallbackConnection.this.requests.remove(_Short.valueOf(requestId));
                    if (CallbackConnection.this.heartBeatMonitor != null) {
                        CallbackConnection.this.heartBeatMonitor.stop();
                        CallbackConnection.this.heartBeatMonitor = null;
                    }
                    CallbackConnection.this.transport.stop(new Task(){

                        public void run() {
                            CallbackConnection.this.listener.onDisconnected();
                            if (onComplete != null) {
                                onComplete.onSuccess(null);
                            }
                        }
                    });
                }
            }
        };
        Callback<Void> cb = new Callback<Void>(){

            @Override
            public void onSuccess(Void v) {
                CallbackConnection.this.onRefillCalled = false;
                CallbackConnection.this.refiller = new Runnable(){

                    public void run() {
                        if (CallbackConnection.this.onRefillCalled) {
                            stop.run();
                        }
                    }
                };
                if (CallbackConnection.this.transport != null) {
                    CallbackConnection.this.transport.flush();
                }
            }

            @Override
            public void onFailure(Throwable value) {
                stop.run();
            }

            @Override
            public /* synthetic */ void onSuccess(Object x0) {
                this.onSuccess((Void)x0);
            }
        };
        if (this.transport != null) {
            MQTTFrame frame = new DISCONNECT().encode();
            this.send(new Request(this.getNextMessageId(), frame, cb));
        } else {
            cb.onSuccess(null);
        }
    }

    public void kill(final Callback<Void> onComplete) {
        if (this.disconnected) {
            if (onComplete != null) {
                onComplete.onSuccess(null);
            }
            return;
        }
        this.disconnected = true;
        if (this.heartBeatMonitor != null) {
            this.heartBeatMonitor.stop();
            this.heartBeatMonitor = null;
        }
        this.transport.stop(new Task(){

            public void run() {
                CallbackConnection.this.listener.onDisconnected();
                if (onComplete != null) {
                    onComplete.onSuccess(null);
                }
            }
        });
    }

    public void publish(String topic, byte[] payload, QoS qos, boolean retain, Callback<Void> cb) {
        this.publish(Buffer.utf8(topic), new Buffer(payload), qos, retain, cb);
    }

    public void publish(UTF8Buffer topic, Buffer payload, QoS qos, boolean retain, Callback<Void> cb) {
        this.queue.assertExecuting();
        if (this.disconnected) {
            cb.onFailure(CallbackConnection.createDisconnectedError());
            return;
        }
        PUBLISH command = new PUBLISH().qos(qos).retain(retain);
        command.topicName(topic).payload(payload);
        this.send(command, cb);
    }

    public void subscribe(final Topic[] topics, Callback<byte[]> cb) {
        if (topics == null) {
            throw new IllegalArgumentException("topics must not be null");
        }
        this.queue.assertExecuting();
        if (this.disconnected) {
            cb.onFailure(CallbackConnection.createDisconnectedError());
            return;
        }
        if (this.listener == DEFAULT_LISTENER) {
            cb.onFailure(CallbackConnection.createListenerNotSetError());
        } else {
            this.send(new SUBSCRIBE().topics(topics), new ProxyCallback<byte[]>(cb){

                @Override
                public void onSuccess(byte[] value) {
                    for (Topic topic : topics) {
                        CallbackConnection.this.activeSubs.put(topic.name(), topic.qos());
                    }
                    if (this.next != null) {
                        this.next.onSuccess(value);
                    }
                }

                @Override
                public /* synthetic */ void onSuccess(Object x0) {
                    this.onSuccess((byte[])x0);
                }
            });
        }
    }

    public void unsubscribe(final UTF8Buffer[] topics, Callback<Void> cb) {
        this.queue.assertExecuting();
        if (this.disconnected) {
            cb.onFailure(CallbackConnection.createDisconnectedError());
            return;
        }
        this.send(new UNSUBSCRIBE().topics(topics), new ProxyCallback(cb){

            public void onSuccess(Object value) {
                UTF8Buffer[] arr$ = topics;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    UTF8Buffer topic = arr$[i$];
                    CallbackConnection.this.activeSubs.remove(topic);
                }
                if (this.next != null) {
                    this.next.onSuccess(value);
                }
            }
        });
    }

    private void send(MessageSupport.Acked command, Callback cb) {
        short id = 0;
        if (command.qos() != QoS.AT_MOST_ONCE) {
            id = this.getNextMessageId();
            command.messageId(id);
        }
        this.send(new Request(id, command.encode(), cb));
    }

    private void send(Request request) {
        if (this.failure != null) {
            if (request.cb != null) {
                request.cb.onFailure(this.failure);
            }
        } else {
            if (request.id != 0) {
                this.requests.put(_Short.valueOf(request.id), request);
            }
            if (this.overflow.isEmpty() && this.transport != null && this.transport.offer(request.frame)) {
                this.mqtt.tracer.onSend(request.frame);
                if (request.id == 0 && request.cb != null) {
                    request.cb.onSuccess(null);
                }
            } else {
                this.requests.remove(_Short.valueOf(request.id));
                this.overflow.addLast(request);
            }
        }
    }

    private short getNextMessageId() {
        short rc = this.nextMessageId;
        this.nextMessageId = (short)(this.nextMessageId + 1);
        if (this.nextMessageId == 0) {
            this.nextMessageId = 1;
        }
        return rc;
    }

    private void drainOverflow() {
        Request request;
        this.queue.assertExecuting();
        if (this.overflow.isEmpty() || this.transport == null) {
            return;
        }
        while ((request = (Request)_LinkedList.peek(this.overflow)) != null && this.transport.offer(request.frame)) {
            this.mqtt.tracer.onSend(request.frame);
            this.overflow.removeFirst();
            if (request.id == 0) {
                if (request.cb == null) continue;
                request.cb.onSuccess(null);
                continue;
            }
            this.requests.put(_Short.valueOf(request.id), request);
        }
        if (this.overflow.isEmpty() && this.refiller != null) {
            try {
                this.refiller.run();
            }
            catch (Throwable e) {
                _Thread_UncaughtExceptionHandler.uncaughtException(_Thread.getUncaughtExceptionHandler(Thread.currentThread()), Thread.currentThread(), e);
            }
        }
    }

    private void completeRequest(short id, byte originalType, Object arg) {
        Request request = this.requests.remove(_Short.valueOf(id));
        if (request != null) {
            if (!$assertionsDisabled && originalType != request.frame.messageType()) {
                throw new AssertionError();
            }
            if (request.cb != null) {
                if (arg == null) {
                    request.cb.onSuccess(null);
                } else {
                    request.cb.onSuccess(arg);
                }
            }
        } else {
            this.handleFatalFailure(new ProtocolException(new StringBuffer().append("Command from server contained an invalid message id: ").append(id).toString()));
        }
    }

    private void processFrame(MQTTFrame frame) {
        try {
            switch (frame.messageType()) {
                case 3: {
                    PUBLISH publish = new PUBLISH().decode(frame);
                    this.toReceiver(publish);
                    break;
                }
                case 6: {
                    PUBREL ack = new PUBREL().decode(frame);
                    Callback<Void> onRel = this.processed.remove(_Short.valueOf(ack.messageId()));
                    PUBCOMP response = new PUBCOMP();
                    response.messageId(ack.messageId());
                    this.send(new Request(0, response.encode(), null));
                    if (onRel != null) {
                        onRel.onSuccess(null);
                    }
                    break;
                }
                case 4: {
                    PUBACK ack = new PUBACK().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)3, null);
                    break;
                }
                case 5: {
                    PUBREC ack = new PUBREC().decode(frame);
                    PUBREL response = new PUBREL();
                    response.messageId(ack.messageId());
                    this.send(new Request(0, response.encode(), null));
                    break;
                }
                case 7: {
                    PUBCOMP ack = new PUBCOMP().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)3, null);
                    break;
                }
                case 9: {
                    SUBACK ack = new SUBACK().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)8, ack.grantedQos());
                    break;
                }
                case 11: {
                    UNSUBACK ack = new UNSUBACK().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)10, null);
                    break;
                }
                case 13: {
                    this.pingedAt = 0L;
                    break;
                }
                default: {
                    throw new ProtocolException(new StringBuffer().append("Unexpected MQTT command type: ").append(frame.messageType()).toString());
                }
            }
        }
        catch (Throwable e) {
            this.handleFatalFailure(e);
        }
    }

    private void toReceiver(final PUBLISH publish) {
        if (this.listener != null) {
            try {
                Callback<Callback<Void>> cb = null;
                switch (publish.qos()) {
                    case AT_LEAST_ONCE: {
                        cb = new Callback<Callback<Void>>(){

                            @Override
                            public void onSuccess(Callback<Void> value) {
                                PUBACK response = new PUBACK();
                                response.messageId(publish.messageId());
                                CallbackConnection.this.send(new Request(0, response.encode(), null));
                                if (value != null) {
                                    value.onSuccess(null);
                                }
                            }

                            @Override
                            public void onFailure(Throwable value) {
                            }

                            @Override
                            public /* synthetic */ void onSuccess(Object x0) {
                                this.onSuccess((Callback)x0);
                            }
                        };
                        break;
                    }
                    case EXACTLY_ONCE: {
                        cb = new Callback<Callback<Void>>(){

                            @Override
                            public void onSuccess(Callback<Void> value) {
                                PUBREC response = new PUBREC();
                                response.messageId(publish.messageId());
                                CallbackConnection.this.processed.put(_Short.valueOf(publish.messageId()), value);
                                CallbackConnection.this.send(new Request(0, response.encode(), null));
                            }

                            @Override
                            public void onFailure(Throwable value) {
                            }

                            @Override
                            public /* synthetic */ void onSuccess(Object x0) {
                                this.onSuccess((Callback)x0);
                            }
                        };
                        if (this.processed.get(_Short.valueOf(publish.messageId())) == null) break;
                        return;
                    }
                }
                this.listener.onPublish(publish.topicName(), publish.payload(), cb);
            }
            catch (Throwable e) {
                this.handleFatalFailure(e);
            }
        }
    }

    private void handleFatalFailure(Throwable error) {
        if (this.failure == null) {
            this.failure = error;
            this.mqtt.tracer.debug("Fatal connection failure: %s", new Object[]{error});
            ArrayList<Request> values = new ArrayList<Request>(this.requests.values());
            this.requests.clear();
            for (Request value : values) {
                if (value.cb == null) continue;
                value.cb.onFailure(this.failure);
            }
            ArrayList<Request> overflowEntries = new ArrayList<Request>(this.overflow);
            this.overflow.clear();
            for (Request entry : overflowEntries) {
                if (entry.cb == null) continue;
                entry.cb.onFailure(this.failure);
            }
            if (this.listener != null && !this.disconnected) {
                try {
                    this.listener.onFailure(this.failure);
                }
                catch (Exception e) {
                    _Thread_UncaughtExceptionHandler.uncaughtException(_Thread.getUncaughtExceptionHandler(Thread.currentThread()), Thread.currentThread(), e);
                }
            }
        }
    }

    private static IllegalStateException createListenerNotSetError() {
        return (IllegalStateException)new IllegalStateException("No connection listener set to handle message received from the server.").fillInStackTrace();
    }

    private static IllegalStateException createDisconnectedError() {
        return (IllegalStateException)new IllegalStateException("Disconnected").fillInStackTrace();
    }

    private static String hex(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)address;
            return new StringBuffer().append(HexSupport.toHexFromBuffer(new Buffer(isa.getAddress().getAddress()))).append(Integer.toHexString(isa.getPort())).toString();
        }
        return "";
    }

    static {
        Class<?> clazz = class$org$fusesource$mqtt$client$CallbackConnection;
        if (clazz == null) {
            clazz = class$org$fusesource$mqtt$client$CallbackConnection = new CallbackConnection[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        DEFAULT_LISTENER = new ExtendedListener(){

            @Override
            public void onConnected() {
            }

            @Override
            public void onDisconnected() {
            }

            @Override
            public void onPublish(UTF8Buffer utf8Buffer, Buffer buffer, Runnable runnable) {
                this.onFailure(CallbackConnection.createListenerNotSetError());
            }

            @Override
            public void onPublish(UTF8Buffer topic, Buffer body, Callback<Callback<Void>> ack) {
                this.onFailure(CallbackConnection.createListenerNotSetError());
            }

            @Override
            public void onFailure(Throwable value) {
                _Thread_UncaughtExceptionHandler.uncaughtException(_Thread.getUncaughtExceptionHandler(Thread.currentThread()), Thread.currentThread(), value);
            }
        };
        NOOP = Dispatch.NOOP;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoginHandler
    implements Callback<Transport> {
        final Callback<Void> cb;
        private final boolean initialConnect;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$org$fusesource$mqtt$client$CallbackConnection;

        LoginHandler(Callback<Void> cb, boolean initialConnect) {
            this.cb = cb;
            this.initialConnect = initialConnect;
        }

        @Override
        public void onSuccess(final Transport transport) {
            transport.setTransportListener(new DefaultTransportListener(){

                public void onTransportFailure(IOException error) {
                    ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Transport failure: %s", new Object[]{error});
                    transport.stop(NOOP);
                    LoginHandler.this.onFailure(error);
                }

                public void onTransportCommand(Object command) {
                    MQTTFrame response = (MQTTFrame)command;
                    ((CallbackConnection)CallbackConnection.this).mqtt.tracer.onReceive(response);
                    try {
                        block1 : switch (response.messageType()) {
                            case 2: {
                                CONNACK connack = new CONNACK().decode(response);
                                switch (16.$SwitchMap$org$fusesource$mqtt$codec$CONNACK$Code[connack.code().ordinal()]) {
                                    case 1: {
                                        ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("MQTT login accepted", new Object[0]);
                                        CallbackConnection.this.onSessionEstablished(transport);
                                        LoginHandler.this.cb.onSuccess(null);
                                        CallbackConnection.this.listener.onConnected();
                                        CallbackConnection.this.queue.execute(new Task(){

                                            public void run() {
                                                CallbackConnection.this.drainOverflow();
                                            }
                                        });
                                        break block1;
                                    }
                                }
                                ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("MQTT login rejected", new Object[0]);
                                transport.stop(NOOP);
                                LoginHandler.this.cb.onFailure(new MQTTException("Could not connect: " + connack.code(), connack));
                                break;
                            }
                            default: {
                                ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Received unexpected MQTT frame: %d", new Object[]{_Byte.valueOf(response.messageType())});
                                transport.stop(NOOP);
                                LoginHandler.this.cb.onFailure(new IOException("Could not connect. Received unexpected command: " + response.messageType()));
                                break;
                            }
                        }
                    }
                    catch (ProtocolException e) {
                        ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Protocol error: %s", new Object[]{e});
                        transport.stop(NOOP);
                        LoginHandler.this.cb.onFailure(e);
                    }
                }
            });
            transport.resumeRead();
            if (((CallbackConnection)CallbackConnection.this).mqtt.connect.clientId() == null) {
                String id = new StringBuffer().append(CallbackConnection.hex(transport.getLocalAddress())).append(Long.toHexString(System.currentTimeMillis() / 1000L)).toString();
                if (id.length() > 23) {
                    id = id.substring(0, 23);
                }
                ((CallbackConnection)CallbackConnection.this).mqtt.connect.clientId(Buffer.utf8(id));
            }
            MQTTFrame encoded = ((CallbackConnection)CallbackConnection.this).mqtt.connect.encode();
            boolean accepted = transport.offer(encoded);
            ((CallbackConnection)CallbackConnection.this).mqtt.tracer.onSend(encoded);
            ((CallbackConnection)CallbackConnection.this).mqtt.tracer.debug("Logging in", new Object[0]);
            if (!$assertionsDisabled && !accepted) {
                throw new AssertionError((Object)"First frame should always be accepted by the transport");
            }
        }

        private boolean tryReconnect() {
            if (this.initialConnect) {
                return ((CallbackConnection)CallbackConnection.this).mqtt.connectAttemptsMax < 0L || CallbackConnection.this.reconnects < ((CallbackConnection)CallbackConnection.this).mqtt.connectAttemptsMax;
            }
            return ((CallbackConnection)CallbackConnection.this).mqtt.reconnectAttemptsMax < 0L || CallbackConnection.this.reconnects < ((CallbackConnection)CallbackConnection.this).mqtt.reconnectAttemptsMax;
        }

        @Override
        public void onFailure(Throwable value) {
            if (!CallbackConnection.this.disconnected && this.tryReconnect()) {
                CallbackConnection.this.reconnect(this);
            } else {
                this.cb.onFailure(value);
            }
        }

        @Override
        public /* synthetic */ void onSuccess(Object x0) {
            this.onSuccess((Transport)x0);
        }

        static {
            Class<?> clazz = class$org$fusesource$mqtt$client$CallbackConnection;
            if (clazz == null) {
                clazz = class$org$fusesource$mqtt$client$CallbackConnection = new CallbackConnection[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    private static class Request {
        final MQTTFrame frame;
        private final short id;
        final Callback cb;

        Request(int id, MQTTFrame frame, Callback cb) {
            this.id = (short)id;
            this.cb = cb;
            this.frame = frame;
        }
    }
}

