/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import net.sf.retrotranslator.runtime.java.lang.ThreadLocal_;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import net.sf.retrotranslator.runtime.java.lang._Thread_UncaughtExceptionHandler;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.internal.AbstractDispatchObject;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.NioAttachment;
import org.fusesource.hawtdispatch.internal.WorkerThread;

public final class NioDispatchSource
extends AbstractDispatchObject
implements DispatchSource {
    final SelectableChannel channel;
    volatile DispatchQueue selectorQueue;
    final AtomicBoolean canceled = new AtomicBoolean();
    final int interestOps;
    Runnable cancelHandler;
    Runnable eventHandler;
    final ThreadLocal_<KeyState> keyState = new ThreadLocal_();
    private Runnable updateInterestTask = new Runnable(){

        public void run() {
            if (!NioDispatchSource.this.isSuspended() && !NioDispatchSource.this.isCanceled()) {
                KeyState state = (KeyState)NioDispatchSource.this.keyState.get();
                if (state == null) {
                    return;
                }
                if (state.key.isValid()) {
                    state.key.interestOps(state.key.interestOps() | NioDispatchSource.this.interestOps);
                }
            }
        }
    };

    private static String opsToString(int ops) {
        ArrayList<String> sb = new ArrayList<String>();
        if ((ops & 0x10) != 0) {
            sb.add("ACCEPT");
        }
        if ((ops & 8) != 0) {
            sb.add("CONNECT");
        }
        if ((ops & 1) != 0) {
            sb.add("READ");
        }
        if ((ops & 4) != 0) {
            sb.add("WRITE");
        }
        return sb.toString();
    }

    public NioDispatchSource(HawtDispatcher dispatcher, SelectableChannel channel, int interestOps, DispatchQueue targetQueue) {
        if (interestOps == 0) {
            throw new IllegalArgumentException("invalid interest ops");
        }
        this.channel = channel;
        this.selectorQueue = NioDispatchSource.pickThreadQueue(dispatcher, targetQueue);
        this.interestOps = interestOps;
        this.suspended.incrementAndGet();
        this.setTargetQueue(targetQueue);
    }

    private static DispatchQueue pickThreadQueue(HawtDispatcher dispatcher, DispatchQueue targetQueue) {
        DispatchQueue selectorQueue = targetQueue;
        while (selectorQueue.getQueueType() != DispatchQueue.QueueType.THREAD_QUEUE && selectorQueue.getTargetQueue() != null) {
            selectorQueue = selectorQueue.getTargetQueue();
        }
        if (selectorQueue.getQueueType() != DispatchQueue.QueueType.THREAD_QUEUE) {
            WorkerThread[] threads = dispatcher.DEFAULT_QUEUE.workers.getThreads();
            WorkerThread min = threads[0];
            int minSize = min.getNioManager().getSelector().keys().size();
            for (int i = 1; i < threads.length; ++i) {
                int s = threads[i].getNioManager().getSelector().keys().size();
                if (s >= minSize) continue;
                minSize = s;
                min = threads[i];
            }
            selectorQueue = min.getDispatchQueue();
        }
        return selectorQueue;
    }

    protected void onStartup() {
        if (this.eventHandler == null) {
            throw new IllegalArgumentException("eventHandler must be set");
        }
        this.register_on(this.selectorQueue);
    }

    public void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.selectorQueue.execute(new Runnable(){

                public void run() {
                    NioDispatchSource.this.internal_cancel();
                }
            });
        }
    }

    void internal_cancel() {
        this.key_cancel();
        if (this.cancelHandler != null) {
            this.targetQueue.execute(this.cancelHandler);
        }
    }

    private void key_cancel() {
        KeyState keyState = (KeyState)this.keyState.get();
        if (keyState == null) {
            return;
        }
        this.debug("canceling source", new Object[0]);
        keyState.attachment.sources.remove(this);
        if (keyState.attachment.sources.isEmpty()) {
            this.debug("canceling key.", new Object[0]);
            keyState.key.cancel();
            Selector selector = WorkerThread.currentWorkerThread().getNioManager().getSelector();
            try {
                selector.selectNow();
            }
            catch (CancelledKeyException cancelledKeyException) {
            }
            catch (IOException iOException) {
                this.debug(iOException, "Error canceling", new Object[0]);
            }
        }
        this.debug("Canceled selector on " + WorkerThread.currentWorkerThread().getDispatchQueue().getLabel(), new Object[0]);
        this.keyState.remove();
    }

    private void register_on(DispatchQueue queue) {
        queue.execute(new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;
            static /* synthetic */ Class class$org$fusesource$hawtdispatch$internal$NioDispatchSource;

            public void run() {
                if (!$assertionsDisabled && NioDispatchSource.this.keyState.get() != null) {
                    throw new AssertionError();
                }
                Selector selector = WorkerThread.currentWorkerThread().getNioManager().getSelector();
                try {
                    KeyState state = new KeyState();
                    state.key = NioDispatchSource.this.channel.keyFor(selector);
                    if (state.key == null) {
                        state.key = NioDispatchSource.this.channel.register(selector, NioDispatchSource.this.interestOps);
                        state.attachment = new NioAttachment();
                        state.key.attach(state.attachment);
                    } else {
                        state.attachment = (NioAttachment)state.key.attachment();
                    }
                    state.attachment.sources.add(NioDispatchSource.this);
                    NioDispatchSource.this.keyState.set((Object)state);
                    try {
                        state.key.interestOps(state.key.interestOps() | NioDispatchSource.this.interestOps);
                    }
                    catch (CancelledKeyException e) {
                        state.attachment.cancel(state.key);
                    }
                }
                catch (ClosedChannelException e) {
                    NioDispatchSource.this.debug(e, "could not register with selector", new Object[0]);
                }
                NioDispatchSource.this.debug("Registered", new Object[0]);
            }

            static {
                Class<?> clazz = class$org$fusesource$hawtdispatch$internal$NioDispatchSource;
                if (clazz == null) {
                    clazz = class$org$fusesource$hawtdispatch$internal$NioDispatchSource = new NioDispatchSource[0].getClass().getComponentType();
                }
                $assertionsDisabled = !clazz.desiredAssertionStatus();
            }
        });
    }

    public void fire(final int readyOps) {
        KeyState state = (KeyState)this.keyState.get();
        if (state == null) {
            return;
        }
        state.readyOps |= readyOps;
        if (state.readyOps != 0 && !this.isSuspended() && !this.isCanceled()) {
            state.readyOps = 0;
            this.targetQueue.execute(new Runnable(){

                public void run() {
                    if (!NioDispatchSource.this.isSuspended() && !NioDispatchSource.this.isCanceled()) {
                        try {
                            NioDispatchSource.this.eventHandler.run();
                        }
                        catch (Throwable e) {
                            Thread thread = Thread.currentThread();
                            _Thread_UncaughtExceptionHandler.uncaughtException(_Thread.getUncaughtExceptionHandler(thread), thread, e);
                        }
                        NioDispatchSource.this.updateInterest();
                    }
                }
            });
        }
    }

    private void updateInterest() {
        if (this.isCurrent(this.selectorQueue)) {
            this.updateInterestTask.run();
        } else {
            this.selectorQueue.execute(this.updateInterestTask);
        }
    }

    private boolean isCurrent(DispatchQueue q) {
        WorkerThread thread = WorkerThread.currentWorkerThread();
        if (thread == null) {
            return false;
        }
        return thread.getDispatchQueue() == q;
    }

    protected void onSuspend() {
        this.debug("onSuspend", new Object[0]);
        super.onSuspend();
    }

    protected void onResume() {
        this.debug("onResume", new Object[0]);
        if (this.isCurrent(this.selectorQueue)) {
            KeyState keyState = (KeyState)this.keyState.get();
            if (keyState == null || keyState.readyOps == 0) {
                this.updateInterest();
            } else {
                this.fire(keyState.readyOps);
            }
        } else {
            this.selectorQueue.execute(new Runnable(){

                public void run() {
                    KeyState state = (KeyState)NioDispatchSource.this.keyState.get();
                    if (state == null || state.readyOps == 0) {
                        NioDispatchSource.this.updateInterest();
                    } else {
                        NioDispatchSource.this.fire(NioDispatchSource.this.interestOps);
                    }
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public void setCancelHandler(Runnable cancelHandler) {
        this.cancelHandler = cancelHandler;
    }

    public void setEventHandler(Runnable eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setTargetQueue(DispatchQueue dispatchQueue) {
        super.setTargetQueue(dispatchQueue);
        DispatchQueue dispatchQueue2 = dispatchQueue;
        while (dispatchQueue2.getQueueType() != DispatchQueue.QueueType.THREAD_QUEUE && dispatchQueue2.getTargetQueue() != null) {
            dispatchQueue2 = dispatchQueue2.getTargetQueue();
        }
        if (dispatchQueue2.getQueueType() == DispatchQueue.QueueType.THREAD_QUEUE && dispatchQueue2 != this.selectorQueue) {
            DispatchQueue dispatchQueue3 = this.selectorQueue;
            this.debug("Switching to " + dispatchQueue2.getLabel(), new Object[0]);
            this.register_on(dispatchQueue2);
            this.selectorQueue = dispatchQueue2;
            if (dispatchQueue3 != null) {
                dispatchQueue3.execute(new Runnable(){

                    public void run() {
                        NioDispatchSource.this.key_cancel();
                    }
                });
            }
        }
    }

    protected void debug(String str, Object[] args) {
    }

    protected void debug(Throwable thrown, String str, Object[] args) {
    }

    public static class KeyState {
        int readyOps;
        SelectionKey key;
        NioAttachment attachment;

        public String toString() {
            return "{ready: " + NioDispatchSource.opsToString(this.readyOps) + " }";
        }
    }
}

