/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang._System;
import sun.misc.Perf;

public final class Utils {
    private static final NanoTimer nanoTimer;
    static /* synthetic */ Class array$Ljava$lang$Object;

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    public static Object[] collectionToArray(Collection c) {
        int len = c.size();
        Object[] arr = new Object[len];
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return Arrays.copyOf(arr, idx, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Utils.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, array$Ljava$lang$Object == null ? Utils.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object);
            len = newcap;
        }
    }

    public static Object[] collectionToArray(Collection c, Object[] a) {
        Class<?> aType = a.getClass();
        int len = c.size();
        Object[] arr = a.length >= len ? a : (Object[])Array.newInstance(aType.getComponentType(), len);
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a) {
                    a[idx] = null;
                    return a;
                }
                return Arrays.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return _Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        NanoTimer timer = null;
        try {
            String nanoTimerClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return _System.getProperty("edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider");
                }
            });
            if (nanoTimerClassName != null) {
                Class cls = _Class.forName(nanoTimerClassName);
                timer = (NanoTimer)cls.newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: unable to load the system-property-defined nanotime provider; switching to the default");
            e.printStackTrace();
        }
        if (timer == null) {
            try {
                timer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (timer == null) {
            timer = new MillisProvider();
        }
        nanoTimer = timer;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged(new PrivilegedAction(this){
            private final /* synthetic */ SunPerfProvider this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long numerator = 1000000000L;
            long denominator = this.perf.highResFrequency();
            long gcd = Utils.gcd(numerator, denominator);
            this.multiplier = numerator / gcd;
            this.divisor = denominator / gcd;
        }

        public long nanoTime() {
            long ctr = this.perf.highResCounter();
            return ctr / this.divisor * this.multiplier + ctr % this.divisor * this.multiplier / this.divisor;
        }
    }
}

