/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SynchronousQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private final ReentrantLock qlock;
    private final WaitQueue waitingProducers;
    private final WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean fair) {
        if (fair) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlinkCancelledConsumer(Node node) {
        if (this.waitingConsumers.shouldUnlink(node)) {
            this.qlock.lock();
            try {
                if (this.waitingConsumers.shouldUnlink(node)) {
                    this.waitingConsumers.unlink(node);
                }
            }
            finally {
                this.qlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Node node;
        Object x;
        ReentrantLock qlock = this.qlock;
        do {
            boolean mustWait;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            qlock.lock();
            try {
                node = this.waitingProducers.deq();
                mustWait = node == null;
                if (mustWait) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            finally {
                qlock.unlock();
            }
            if (!mustWait) continue;
            try {
                x = node.waitForPut();
                return x;
            }
            catch (InterruptedException ex) {
                this.unlinkCancelledConsumer(node);
                throw ex;
            }
        } while ((x = node.getItem()) == null);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        Node node;
        Object x;
        long nanos = unit.toNanos(timeout);
        ReentrantLock qlock = this.qlock;
        do {
            boolean mustWait;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            qlock.lock();
            try {
                node = this.waitingProducers.deq();
                mustWait = node == null;
                if (mustWait) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            finally {
                qlock.unlock();
            }
            if (!mustWait) continue;
            try {
                x = node.waitForPut(nanos);
                if (x == null) {
                    this.unlinkCancelledConsumer(node);
                }
                return x;
            }
            catch (InterruptedException ex) {
                this.unlinkCancelledConsumer(node);
                throw ex;
            }
        } while ((x = node.getItem()) == null);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object e) {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock qlock = this.qlock;
        do {
            qlock.lock();
            try {
                node = this.waitingConsumers.deq();
            }
            finally {
                qlock.unlock();
            }
            if (node != null) continue;
            return false;
        } while (!node.setItem(e));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Node node;
        Object x;
        ReentrantLock qlock = this.qlock;
        do {
            qlock.lock();
            try {
                node = this.waitingProducers.deq();
            }
            finally {
                qlock.unlock();
            }
            if (node != null) continue;
            return null;
        } while ((x = node.getItem()) == null);
        return x;
    }

    public boolean isEmpty() {
        return true;
    }

    public int size() {
        return 0;
    }

    public void clear() {
    }

    public boolean contains(Object o) {
        return false;
    }

    public boolean remove(Object o) {
        return false;
    }

    public boolean containsAll(Collection c) {
        return c.isEmpty();
    }

    public boolean removeAll(Collection c) {
        return false;
    }

    public boolean retainAll(Collection c) {
        return false;
    }

    public Iterator iterator() {
        return new EmptyIterator();
    }

    public Object[] toArray() {
        return new Object[0];
    }

    public Object[] toArray(Object[] a) {
        if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    static final class Node
    implements Serializable {
        int state = 0;
        Object item;
        Node next;

        Node(Object x) {
            this.item = x;
        }

        Node(Object x, Node n) {
            this.item = x;
            this.next = n;
        }

        private Object extract() {
            Object x = this.item;
            this.item = null;
            return x;
        }

        private void checkCancellationOnInterrupt(InterruptedException ie) throws InterruptedException {
            if (this.state == 0) {
                this.state = -1;
                this.notify();
                throw ie;
            }
            Thread.currentThread().interrupt();
        }

        synchronized boolean setItem(Object x) {
            if (this.state != 0) {
                return false;
            }
            this.item = x;
            this.state = 1;
            this.notify();
            return true;
        }

        synchronized Object getItem() {
            if (this.state != 0) {
                return null;
            }
            this.state = 1;
            this.notify();
            return this.extract();
        }

        synchronized Object waitForPut() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                this.checkCancellationOnInterrupt(ie);
            }
            return this.extract();
        }

        private boolean attempt(long nanos) throws InterruptedException {
            if (this.state != 0) {
                return true;
            }
            if (nanos <= 0L) {
                this.state = -1;
                this.notify();
                return false;
            }
            long deadline = Utils.nanoTime() + nanos;
            do {
                TimeUnit.NANOSECONDS.timedWait(this, nanos);
                if (this.state == 0) continue;
                return true;
            } while ((nanos = deadline - Utils.nanoTime()) > 0L);
            this.state = -1;
            this.notify();
            return false;
        }

        synchronized Object waitForPut(long nanos) throws InterruptedException {
            try {
                if (!this.attempt(nanos)) {
                    return null;
                }
            }
            catch (InterruptedException ie) {
                this.checkCancellationOnInterrupt(ie);
            }
            return this.extract();
        }
    }

    static final class LifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private transient Node head;

        LifoWaitQueue() {
        }

        Node enq(Object x) {
            this.head = new Node(x, this.head);
            return this.head;
        }

        Node deq() {
            Node p = this.head;
            if (p != null) {
                this.head = p.next;
                p.next = null;
            }
            return p;
        }

        boolean shouldUnlink(Node node) {
            return node == this.head || node.next != null;
        }

        void unlink(Node node) {
            Node p = this.head;
            Node trail = null;
            while (p != null) {
                if (p == node) {
                    Node next = p.next;
                    if (trail == null) {
                        this.head = next;
                        break;
                    }
                    trail.next = next;
                    break;
                }
                trail = p;
                p = p.next;
            }
        }
    }

    static final class FifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private transient Node head;
        private transient Node last;

        FifoWaitQueue() {
        }

        Node enq(Object x) {
            Node p = new Node(x);
            this.last = this.last == null ? (this.head = p) : (this.last.next = p);
            return p;
        }

        Node deq() {
            Node p = this.head;
            if (p != null) {
                this.head = p.next;
                if (this.head == null) {
                    this.last = null;
                }
                p.next = null;
            }
            return p;
        }

        boolean shouldUnlink(Node node) {
            return node == this.last || node.next != null;
        }

        void unlink(Node node) {
            Node p = this.head;
            Node trail = null;
            while (p != null) {
                if (p == node) {
                    Node next = p.next;
                    if (trail == null) {
                        this.head = next;
                    } else {
                        trail.next = next;
                    }
                    if (this.last != node) break;
                    this.last = trail;
                    break;
                }
                trail = p;
                p = p.next;
            }
        }
    }

    static abstract class WaitQueue
    implements Serializable {
        WaitQueue() {
        }

        abstract Node enq(Object var1);

        abstract Node deq();

        abstract void unlink(Node var1);

        abstract boolean shouldUnlink(Node var1);
    }
}

