/*
 * Decompiled with CFR 0.152.
 */
package fj.data.hamt;

import fj.Equal;
import fj.F2;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.Show;
import fj.data.List;
import fj.data.Option;
import fj.data.Seq;
import fj.data.Stream;
import fj.data.hamt.BitSet;
import fj.data.hamt.Node;

public final class HashArrayMappedTrie<K, V> {
    private final Seq<Node<K, V>> seq;
    private final BitSet bitSet;
    private final Hash<K> hash;
    private final Equal<K> equal;
    public static final int BITS_IN_INDEX = 5;
    public static final int SIZE = (int)StrictMath.pow(2.0, 5.0);
    public static final int MIN_INDEX = 0;
    public static final int MAX_INDEX = SIZE - 1;

    private HashArrayMappedTrie(BitSet bs, Seq<Node<K, V>> s, Equal<K> e, Hash<K> h) {
        this.bitSet = bs;
        this.seq = s;
        this.hash = h;
        this.equal = e;
    }

    public static <K, V> HashArrayMappedTrie<K, V> empty(Equal<K> e, Hash<K> h) {
        return new HashArrayMappedTrie<K, V>(BitSet.empty(), Seq.empty(), e, h);
    }

    public static <V> HashArrayMappedTrie<Integer, V> emptyKeyInteger() {
        return HashArrayMappedTrie.empty(Equal.intEqual, Hash.intHash);
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    private static <K, V> HashArrayMappedTrie<K, V> hamt(BitSet bs, Seq<Node<K, V>> s, Equal<K> e, Hash<K> h) {
        return new HashArrayMappedTrie<K, V>(bs, s, e, h);
    }

    public Option<V> find(K k) {
        return this.find(k, 0, 5);
    }

    public Option<V> find(K k, int lowIndex, int highIndex) {
        BitSet bs1 = BitSet.longBitSet(this.hash.hash(k)).range(lowIndex, highIndex);
        int i = (int)bs1.longValue();
        boolean b = this.bitSet.isSet(i);
        int index = this.bitSet.bitsToRight(i);
        if (!b) {
            return Option.none();
        }
        Node<K, V> oldNode = this.seq.index(index);
        return oldNode.match(n -> this.equal.eq(n._1(), k) ? Option.some(n._2()) : Option.none(), hamt -> hamt.find(k, lowIndex + 5, highIndex + 5));
    }

    public HashArrayMappedTrie<K, V> set(K k, V v) {
        return this.set(k, v, 0, 5);
    }

    public HashArrayMappedTrie<K, V> set(List<P2<K, V>> list) {
        return list.foldLeft((B h) -> p -> h.set(p._1(), p._2()), this);
    }

    private HashArrayMappedTrie<K, V> set(K k, V v, int lowIndex, int highIndex) {
        BitSet bs1 = BitSet.longBitSet(this.hash.hash(k)).range(lowIndex, highIndex);
        int i = (int)bs1.longValue();
        boolean b = this.bitSet.isSet(i);
        int index = this.bitSet.bitsToRight(i);
        if (!b) {
            Node<K, V> sn1 = Node.p2Node(P.p(k, v));
            return HashArrayMappedTrie.hamt(this.bitSet.set(i), this.seq.insert(index, sn1), this.equal, this.hash);
        }
        Node<K, V> oldNode = this.seq.index(index);
        Node newNode = oldNode.match(n -> {
            if (this.equal.eq(n._1(), k)) {
                return Node.p2Node(P.p(k, v));
            }
            HashArrayMappedTrie<K, V> e = HashArrayMappedTrie.empty(this.equal, this.hash);
            HashArrayMappedTrie<K, V> h1 = super.set(n._1(), n._2(), lowIndex + 5, highIndex + 5);
            HashArrayMappedTrie<Object, Object> h2 = super.set(k, v, lowIndex + 5, highIndex + 5);
            return Node.hamtNode(h2);
        }, hamt -> Node.hamtNode(hamt.set(k, v, lowIndex + 5, highIndex + 5)));
        return HashArrayMappedTrie.hamt(this.bitSet, this.seq.update(index, newNode), this.equal, this.hash);
    }

    public Stream<P2<K, V>> toStream() {
        return this.seq.toStream().bind(Node::toStream);
    }

    public List<P2<K, V>> toList(Ord<K> o) {
        return this.toStream().sort(Ord.p2Ord1(o)).toList();
    }

    public List<P2<K, V>> toList() {
        return this.toStream().toList();
    }

    public String toString() {
        return Show.hamtShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    public <B> B foldLeftOnNode(F2<B, Node<K, V>, B> f, B b) {
        return this.seq.foldLeft(f, b);
    }

    public <B> B foldLeft(F2<B, P2<K, V>, B> f, F2<B, HashArrayMappedTrie<K, V>, B> g, B b) {
        return (B)this.foldLeftOnNode((acc, n) -> n.match(p -> f.f((Object)acc, (P2)p), h -> g.f((Object)acc, (HashArrayMappedTrie)h)), b);
    }

    public <B> B foldLeft(F2<B, P2<K, V>, B> f, B b) {
        return (B)this.foldLeftOnNode((acc, n) -> n.match(p -> f.f((Object)acc, (P2)p), h -> h.foldLeft(f, acc)), b);
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public Seq<Node<K, V>> getSeq() {
        return this.seq;
    }

    public int length() {
        return this.seq.foldLeft((B acc, A node) -> node.match(p2 -> acc + 1, hamt -> acc + hamt.length()), 0);
    }
}

