/*
 * Decompiled with CFR 0.152.
 */
package fj.test;

import fj.F;
import fj.data.List;
import fj.data.Option;
import fj.test.Arg;
import fj.test.Result$$Lambda$1;

public final class Result {
    private final Option<List<Arg<?>>> args;
    private final R r;
    private final Option<Throwable> t;

    private Result(Option<List<Arg<?>>> args, R r, Option<Throwable> t) {
        this.args = args;
        this.r = r;
        this.t = t;
    }

    public Option<List<Arg<?>>> args() {
        return this.args;
    }

    public Option<Throwable> exception() {
        return this.t;
    }

    public boolean isUnfalsified() {
        return this.r == R.Unfalsified;
    }

    public boolean isFalsified() {
        return this.r == R.Falsified;
    }

    public boolean isProven() {
        return this.r == R.Proven;
    }

    public boolean isException() {
        return this.r == R.Exception;
    }

    public boolean isNoResult() {
        return this.r == R.NoResult;
    }

    public boolean failed() {
        return this.isFalsified() || this.isException();
    }

    public boolean passed() {
        return this.isUnfalsified() || this.isProven();
    }

    public Result provenAsUnfalsified() {
        return this.isProven() ? Result.unfalsified((List)this.args.some()) : this;
    }

    public Result addArg(Arg<?> a) {
        F cons = List.cons();
        return new Result(this.args.map((F)cons.f(a)), this.r, this.t);
    }

    public Option<Result> toOption() {
        if (this.isNoResult()) {
            return Option.none();
        }
        return Option.some((Object)this);
    }

    public static Result noResult(Option<Result> r) {
        return (Result)r.orSome(Result$$Lambda$1.lambdaFactory$());
    }

    public static Result noResult() {
        return new Result(Option.none(), R.NoResult, (Option<Throwable>)Option.none());
    }

    public static Result unfalsified(List<Arg<?>> args) {
        return new Result(Option.some(args), R.Unfalsified, (Option<Throwable>)Option.none());
    }

    public static Result falsified(List<Arg<?>> args) {
        return new Result(Option.some(args), R.Falsified, (Option<Throwable>)Option.none());
    }

    public static Result proven(List<Arg<?>> args) {
        return new Result(Option.some(args), R.Proven, (Option<Throwable>)Option.none());
    }

    public static Result exception(List<Arg<?>> args, Throwable t) {
        return new Result(Option.some(args), R.Exception, (Option<Throwable>)Option.some((Object)t));
    }

    private static enum R {
        Unfalsified,
        Falsified,
        Proven,
        Exception,
        NoResult;

    }
}

