/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.mod.opencsv;

import com.opencsv.CSVWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.config.DocTypeHandlerDefault;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocCell;
import org.fugerit.java.doc.base.model.DocElement;
import org.fugerit.java.doc.base.model.DocPara;
import org.fugerit.java.doc.base.model.DocPhrase;
import org.fugerit.java.doc.base.model.DocRow;
import org.fugerit.java.doc.base.model.DocTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCSVTypeHandler
extends DocTypeHandlerDefault {
    private static final Logger log = LoggerFactory.getLogger(OpenCSVTypeHandler.class);
    private static final long serialVersionUID = -1832379566311585295L;
    public static final String TYPE_CSV = "csv";
    public static final String MODULE = "csv";
    public static final String MIME = "text/csv";
    public static final OpenCSVTypeHandler HANDLER = new OpenCSVTypeHandler();
    public static final DocTypeHandler HANDLER_UTF8 = new OpenCSVTypeHandler(StandardCharsets.UTF_8);

    public OpenCSVTypeHandler(Charset charset) {
        super("csv", "csv", MIME, charset);
    }

    public OpenCSVTypeHandler() {
        this(null);
    }

    private String handleCell(DocCell cell) {
        StringBuilder currentContent = new StringBuilder();
        for (DocElement contentElement : cell.getElementList()) {
            DocPara para;
            if (contentElement instanceof DocPara) {
                para = (DocPara)contentElement;
                currentContent.append(para.getText());
                continue;
            }
            if (!(contentElement instanceof DocPhrase)) continue;
            para = (DocPhrase)contentElement;
            currentContent.append(para.getText());
        }
        return currentContent.toString();
    }

    public void handle(DocInput docInput, DocOutput docOutput) throws Exception {
        String csvLineEnd;
        DocBase docBase = docInput.getDoc();
        char separator = ',';
        char quotechar = '\"';
        char escapechar = '\"';
        String lineEnd = "\n";
        String csvSeparator = docBase.getStableInfo().getProperty("csv-separator");
        if (StringUtils.isNotEmpty((String)csvSeparator)) {
            log.info("override default separator : {} -> {}", (Object)csvSeparator, (Object)Character.valueOf(separator));
            separator = csvSeparator.charAt(0);
        }
        if (StringUtils.isNotEmpty((String)(csvLineEnd = docBase.getStableInfo().getProperty("csv-line-end")))) {
            log.info("override default lineEnd : {} -> {}", (Object)csvLineEnd, (Object)lineEnd);
            lineEnd = csvLineEnd.replace("\\n", String.valueOf('\n')).replace("\\r", String.valueOf('\r'));
        }
        try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(docOutput.getOs(), this.getCharset()), separator, quotechar, escapechar, lineEnd);){
            String csvTableId = docBase.getStableInfo().getProperty("csv-table-id");
            DocTable table = (DocTable)docBase.getElementById(csvTableId);
            if (table == null) {
                log.warn("table id {} not found!", (Object)csvTableId);
            } else {
                log.info("handling table id {}", (Object)csvTableId);
                String[] currentRow = new String[table.getColumns()];
                for (DocElement currentElement : table.getElementList()) {
                    DocRow row = (DocRow)currentElement;
                    int count = 0;
                    for (DocElement currentCell : row.getElementList()) {
                        DocCell cell = (DocCell)currentCell;
                        currentRow[count] = this.handleCell(cell);
                        ++count;
                    }
                    writer.writeNext(currentRow);
                }
                writer.flush();
            }
        }
    }
}

