/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mongodb;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.mongodb.MongoDBDatabase;
import org.flywaydb.database.mongodb.MongoDBTable;

public class MongoDBSchema
extends Schema<MongoDBDatabase, MongoDBTable> {
    public MongoDBSchema(JdbcTemplate jdbcTemplate, MongoDBDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("db.getMongo().getDBNames().indexOf('" + this.name + "')", new String[0]) >= 0;
    }

    protected boolean doEmpty() throws SQLException {
        return ((MongoDBTable[])this.allTables()).length == 0;
    }

    protected void doCreate() throws SQLException {
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("db.getSiblingDB('" + this.name + "').dropDatabase()", new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (MongoDBTable table : (MongoDBTable[])this.allTables()) {
            table.drop();
        }
    }

    protected MongoDBTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("db.getSiblingDB('" + this.name + "').getCollectionNames().filter(function (c) { return !c.startsWith(\"system\"); })", new String[0]);
        MongoDBTable[] tables = new MongoDBTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new MongoDBTable(this.jdbcTemplate, (MongoDBDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new MongoDBTable(this.jdbcTemplate, (MongoDBDatabase)this.database, this, tableName);
    }
}

