/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.api.client.util.Preconditions;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.jdbc.AbstractJdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcArray;
import com.google.cloud.spanner.jdbc.JdbcBlob;
import com.google.cloud.spanner.jdbc.JdbcClob;
import com.google.cloud.spanner.jdbc.JdbcDatabaseMetaData;
import com.google.cloud.spanner.jdbc.JdbcParameterStore;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcStatement;
import com.google.cloud.spanner.jdbc.TransactionRetryListener;
import com.google.common.collect.Iterators;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class JdbcConnection
extends AbstractJdbcConnection {
    private static final String ONLY_RS_FORWARD_ONLY = "Only result sets of type TYPE_FORWARD_ONLY are supported";
    private static final String ONLY_CONCUR_READ_ONLY = "Only result sets with concurrency CONCUR_READ_ONLY are supported";
    private static final String ONLY_CLOSE_CURSORS_AT_COMMIT = "Only result sets with holdability CLOSE_CURSORS_AT_COMMIT are supported";
    static final String ONLY_NO_GENERATED_KEYS = "Only NO_GENERATED_KEYS are supported";
    static final String IS_VALID_QUERY = "SELECT 1";
    private Map<String, Class<?>> typeMap = new HashMap();

    JdbcConnection(String connectionUrl, ConnectionOptions options) throws SQLException {
        super(connectionUrl, options);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new JdbcStatement(this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new JdbcPreparedStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return JdbcParameterStore.convertPositionalParametersToNamedParameters((String)StatementParser.removeCommentsAndTrim((String)sql)).sqlWithNamedParameters;
    }

    @Override
    public String getStatementTag() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getStatementTag();
    }

    @Override
    public void setStatementTag(String tag) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setStatementTag(tag);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public String getTransactionTag() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getTransactionTag();
    }

    @Override
    public void setTransactionTag(String tag) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setTransactionTag(tag);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setTransactionMode(TransactionMode mode) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setTransactionMode(mode);
    }

    @Override
    public TransactionMode getTransactionMode() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getTransactionMode();
    }

    @Override
    public void setAutocommitDmlMode(AutocommitDmlMode mode) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setAutocommitDmlMode(mode);
    }

    @Override
    public AutocommitDmlMode getAutocommitDmlMode() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getAutocommitDmlMode();
    }

    @Override
    public void setReadOnlyStaleness(TimestampBound staleness) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setReadOnlyStaleness(staleness);
    }

    @Override
    public TimestampBound getReadOnlyStaleness() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getReadOnlyStaleness();
    }

    @Override
    public void setOptimizerVersion(String optimizerVersion) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setOptimizerVersion(optimizerVersion);
    }

    @Override
    public String getOptimizerVersion() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getOptimizerVersion();
    }

    @Override
    public boolean isInTransaction() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isInTransaction();
    }

    @Override
    public boolean isTransactionStarted() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isTransactionStarted();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            if (this.getSpannerConnection().isAutocommit() != autoCommit && this.getSpannerConnection().isTransactionStarted()) {
                this.commit();
            }
            this.getSpannerConnection().setAutocommit(autoCommit);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isAutocommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().commit();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().rollback();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.getSpannerConnection().close();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.getSpannerConnection().isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JdbcDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setReadOnly(readOnly);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isReadOnly();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetHoldability == 2, ONLY_CLOSE_CURSORS_AT_COMMIT);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetHoldability == 2, ONLY_CLOSE_CURSORS_AT_COMMIT);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(autoGeneratedKeys == 2, ONLY_NO_GENERATED_KEYS);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap(this.typeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        this.typeMap = new HashMap(map);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        JdbcPreconditions.checkArgument(timeout >= 0, "timeout must be >= 0");
        if (this.isClosed()) return false;
        try {
            Statement statement = this.createStatement();
            statement.setQueryTimeout(timeout);
            try (ResultSet rs = statement.executeQuery(IS_VALID_QUERY);){
                if (!rs.next()) return false;
                if (rs.getLong(1) != 1L) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JdbcBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JdbcClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JdbcClob();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return JdbcArray.createArray(typeName, elements);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkArgument("".equals(catalog), "Only catalog \"\" is supported");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkArgument("".equals(schema), "Only schema \"\" is supported");
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public java.sql.Timestamp getCommitTimestamp() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().getCommitTimestamp().toSqlTimestamp();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public CommitResponse getCommitResponse() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().getCommitResponse();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setReturnCommitStats(boolean returnCommitStats) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setReturnCommitStats(returnCommitStats);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isReturnCommitStats() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().isReturnCommitStats();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public java.sql.Timestamp getReadTimestamp() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().getReadTimestamp().toSqlTimestamp();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isRetryAbortsInternally() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().isRetryAbortsInternally();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setRetryAbortsInternally(boolean retryAbortsInternally) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setRetryAbortsInternally(retryAbortsInternally);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void write(Mutation mutation) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().write(mutation);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void write(Iterable<Mutation> mutations) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().write(mutations);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void bufferedWrite(Mutation mutation) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().bufferedWrite(mutation);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void bufferedWrite(Iterable<Mutation> mutations) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().bufferedWrite(mutations);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void addTransactionRetryListener(TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().addTransactionRetryListener((com.google.cloud.spanner.connection.TransactionRetryListener)new JdbcToSpannerTransactionRetryListener(listener));
    }

    @Override
    public void addTransactionRetryListener(com.google.cloud.spanner.connection.TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().addTransactionRetryListener(listener);
    }

    @Override
    public boolean removeTransactionRetryListener(TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().removeTransactionRetryListener((com.google.cloud.spanner.connection.TransactionRetryListener)new JdbcToSpannerTransactionRetryListener(listener));
    }

    @Override
    public boolean removeTransactionRetryListener(com.google.cloud.spanner.connection.TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().removeTransactionRetryListener(listener);
    }

    @Override
    public Iterator<TransactionRetryListener> getTransactionRetryListeners() throws SQLException {
        this.checkClosed();
        return Iterators.transform((Iterator)this.getSpannerConnection().getTransactionRetryListeners(), input -> {
            if (input instanceof JdbcToSpannerTransactionRetryListener) {
                return ((JdbcToSpannerTransactionRetryListener)input).delegate;
            }
            return null;
        });
    }

    @Override
    public Iterator<com.google.cloud.spanner.connection.TransactionRetryListener> getTransactionRetryListenersFromConnection() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getTransactionRetryListeners();
    }

    private static final class JdbcToSpannerTransactionRetryListener
    implements com.google.cloud.spanner.connection.TransactionRetryListener {
        private final TransactionRetryListener delegate;

        JdbcToSpannerTransactionRetryListener(TransactionRetryListener delegate) {
            this.delegate = (TransactionRetryListener)Preconditions.checkNotNull((Object)delegate);
        }

        public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
            this.delegate.retryStarting(transactionStarted, transactionId, retryAttempt);
        }

        public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
            this.delegate.retryFinished(transactionStarted, transactionId, retryAttempt, TransactionRetryListener.RetryResult.valueOf(result.name()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof JdbcToSpannerTransactionRetryListener)) {
                return false;
            }
            JdbcToSpannerTransactionRetryListener other = (JdbcToSpannerTransactionRetryListener)o;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

