/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import com.google.spanner.v1.RequestOptions;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientSideStatementValueConverters {
    ClientSideStatementValueConverters() {
    }

    static class RpcPriorityConverter
    implements ClientSideStatementValueConverter<RequestOptions.Priority> {
        private final CaseInsensitiveEnumMap<RequestOptions.Priority> values = new CaseInsensitiveEnumMap(RequestOptions.Priority.class);
        private final Pattern allowedValues;

        public RpcPriorityConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<RequestOptions.Priority> getParameterClass() {
            return RequestOptions.Priority.class;
        }

        @Override
        public RequestOptions.Priority convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find() && matcher.group(0).equalsIgnoreCase("null")) {
                return RequestOptions.Priority.PRIORITY_UNSPECIFIED;
            }
            return (RequestOptions.Priority)((CaseInsensitiveEnumMap)this.values).get("PRIORITY_" + value);
        }
    }

    static class TransactionModeConverter
    implements ClientSideStatementValueConverter<TransactionMode> {
        private final CaseInsensitiveEnumMap<TransactionMode> values = new CaseInsensitiveEnumMap(TransactionMode.class, TransactionMode::getStatementString);

        public TransactionModeConverter(String allowedValues) {
        }

        @Override
        public Class<TransactionMode> getParameterClass() {
            return TransactionMode.class;
        }

        @Override
        public TransactionMode convert(String value) {
            String valueWithSingleSpaces = value.replaceAll("\\s+", " ");
            return (TransactionMode)((CaseInsensitiveEnumMap)this.values).get(valueWithSingleSpaces);
        }
    }

    static class StringValueConverter
    implements ClientSideStatementValueConverter<String> {
        public StringValueConverter(String allowedValues) {
        }

        @Override
        public Class<String> getParameterClass() {
            return String.class;
        }

        @Override
        public String convert(String value) {
            return value;
        }
    }

    static class AutocommitDmlModeConverter
    implements ClientSideStatementValueConverter<AutocommitDmlMode> {
        private final CaseInsensitiveEnumMap<AutocommitDmlMode> values = new CaseInsensitiveEnumMap(AutocommitDmlMode.class);

        public AutocommitDmlModeConverter(String allowedValues) {
        }

        @Override
        public Class<AutocommitDmlMode> getParameterClass() {
            return AutocommitDmlMode.class;
        }

        @Override
        public AutocommitDmlMode convert(String value) {
            return (AutocommitDmlMode)((CaseInsensitiveEnumMap)this.values).get(value);
        }
    }

    static class ReadOnlyStalenessConverter
    implements ClientSideStatementValueConverter<TimestampBound> {
        private final Pattern allowedValues;
        private final CaseInsensitiveEnumMap<TimestampBound.Mode> values = new CaseInsensitiveEnumMap(TimestampBound.Mode.class);

        public ReadOnlyStalenessConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<TimestampBound> getParameterClass() {
            return TimestampBound.class;
        }

        @Override
        public TimestampBound convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find() && matcher.groupCount() >= 1) {
                Enum mode = null;
                int groupIndex = 0;
                for (int group = 1; group <= matcher.groupCount(); ++group) {
                    if (matcher.group(group) == null || (mode = (TimestampBound.Mode)((CaseInsensitiveEnumMap)this.values).get(matcher.group(group))) == null) continue;
                    groupIndex = group;
                    break;
                }
                switch (1.$SwitchMap$com$google$cloud$spanner$TimestampBound$Mode[mode.ordinal()]) {
                    case 1: {
                        return TimestampBound.strong();
                    }
                    case 2: {
                        return TimestampBound.ofReadTimestamp(ReadOnlyStalenessUtil.parseRfc3339(matcher.group(groupIndex + 1)));
                    }
                    case 3: {
                        return TimestampBound.ofMinReadTimestamp(ReadOnlyStalenessUtil.parseRfc3339(matcher.group(groupIndex + 1)));
                    }
                    case 4: {
                        try {
                            return TimestampBound.ofExactStaleness(Long.parseLong(matcher.group(groupIndex + 2)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(groupIndex + 3)));
                        }
                        catch (IllegalArgumentException e) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                    case 5: {
                        try {
                            return TimestampBound.ofMaxStaleness(Long.parseLong(matcher.group(groupIndex + 2)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(groupIndex + 3)));
                        }
                        catch (IllegalArgumentException e) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                }
            }
            return null;
        }
    }

    static class DurationConverter
    implements ClientSideStatementValueConverter<Duration> {
        private final Pattern allowedValues;

        public DurationConverter(String allowedValues) {
            this.allowedValues = Pattern.compile("(?is)\\A" + allowedValues.substring(1, allowedValues.length() - 1) + "\\z");
        }

        @Override
        public Class<Duration> getParameterClass() {
            return Duration.class;
        }

        @Override
        public Duration convert(String value) {
            Matcher matcher = this.allowedValues.matcher(value);
            if (matcher.find()) {
                if (matcher.group(0).equalsIgnoreCase("null")) {
                    return Durations.fromNanos((long)0L);
                }
                Duration duration = ReadOnlyStalenessUtil.createDuration(Long.parseLong(matcher.group(1)), ReadOnlyStalenessUtil.parseTimeUnit(matcher.group(2)));
                if (duration.getSeconds() == 0L && duration.getNanos() == 0) {
                    return null;
                }
                return duration;
            }
            return null;
        }
    }

    static class BooleanConverter
    implements ClientSideStatementValueConverter<Boolean> {
        public BooleanConverter(String allowedValues) {
        }

        @Override
        public Class<Boolean> getParameterClass() {
            return Boolean.class;
        }

        @Override
        public Boolean convert(String value) {
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static final class CaseInsensitiveEnumMap<E extends Enum<E>> {
        private final Map<String, E> map = new HashMap<String, E>();

        private CaseInsensitiveEnumMap(Class<E> elementType) {
            this(elementType, Enum::name);
        }

        private CaseInsensitiveEnumMap(Class<E> elementType, Function<E, String> keyFunction) {
            Preconditions.checkNotNull(elementType);
            Preconditions.checkNotNull(keyFunction);
            EnumSet<Enum> set = EnumSet.allOf(elementType);
            for (Enum e : set) {
                if (this.map.put(((String)keyFunction.apply((Object)e)).toUpperCase(), e) == null) continue;
                throw new IllegalArgumentException("Enum contains multiple elements with the same case-insensitive key");
            }
        }

        private E get(String value) {
            Preconditions.checkNotNull((Object)value);
            return (E)((Enum)this.map.get(value.toUpperCase()));
        }
    }
}

